/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.testing.logs.internal;

import io.opentelemetry.api.common.Value;
import io.opentelemetry.api.incubator.common.ExtendedAttributes;
import io.opentelemetry.api.logs.Severity;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.testing.logs.internal.TestExtendedLogRecordData;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
final class AutoValue_TestExtendedLogRecordData
extends TestExtendedLogRecordData {
    private final Resource resource;
    private final InstrumentationScopeInfo instrumentationScopeInfo;
    private final long timestampEpochNanos;
    private final long observedTimestampEpochNanos;
    private final SpanContext spanContext;
    private final Severity severity;
    @Nullable
    private final String severityText;
    private final int totalAttributeCount;
    private final ExtendedAttributes extendedAttributes;
    @Nullable
    private final Value<?> bodyValue;
    @Nullable
    private final String eventName;

    private AutoValue_TestExtendedLogRecordData(Resource resource, InstrumentationScopeInfo instrumentationScopeInfo, long timestampEpochNanos, long observedTimestampEpochNanos, SpanContext spanContext, Severity severity, @Nullable String severityText, int totalAttributeCount, ExtendedAttributes extendedAttributes, @Nullable Value<?> bodyValue, @Nullable String eventName) {
        this.resource = resource;
        this.instrumentationScopeInfo = instrumentationScopeInfo;
        this.timestampEpochNanos = timestampEpochNanos;
        this.observedTimestampEpochNanos = observedTimestampEpochNanos;
        this.spanContext = spanContext;
        this.severity = severity;
        this.severityText = severityText;
        this.totalAttributeCount = totalAttributeCount;
        this.extendedAttributes = extendedAttributes;
        this.bodyValue = bodyValue;
        this.eventName = eventName;
    }

    @Override
    public Resource getResource() {
        return this.resource;
    }

    @Override
    public InstrumentationScopeInfo getInstrumentationScopeInfo() {
        return this.instrumentationScopeInfo;
    }

    @Override
    public long getTimestampEpochNanos() {
        return this.timestampEpochNanos;
    }

    @Override
    public long getObservedTimestampEpochNanos() {
        return this.observedTimestampEpochNanos;
    }

    @Override
    public SpanContext getSpanContext() {
        return this.spanContext;
    }

    @Override
    public Severity getSeverity() {
        return this.severity;
    }

    @Override
    @Nullable
    public String getSeverityText() {
        return this.severityText;
    }

    @Override
    public int getTotalAttributeCount() {
        return this.totalAttributeCount;
    }

    @Override
    public ExtendedAttributes getExtendedAttributes() {
        return this.extendedAttributes;
    }

    @Override
    @Nullable
    public Value<?> getBodyValue() {
        return this.bodyValue;
    }

    @Override
    @Nullable
    public String getEventName() {
        return this.eventName;
    }

    public String toString() {
        return "TestExtendedLogRecordData{resource=" + this.resource + ", instrumentationScopeInfo=" + this.instrumentationScopeInfo + ", timestampEpochNanos=" + this.timestampEpochNanos + ", observedTimestampEpochNanos=" + this.observedTimestampEpochNanos + ", spanContext=" + this.spanContext + ", severity=" + (Object)((Object)this.severity) + ", severityText=" + this.severityText + ", totalAttributeCount=" + this.totalAttributeCount + ", extendedAttributes=" + this.extendedAttributes + ", bodyValue=" + this.bodyValue + ", eventName=" + this.eventName + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof TestExtendedLogRecordData) {
            TestExtendedLogRecordData that = (TestExtendedLogRecordData)o;
            return this.resource.equals(that.getResource()) && this.instrumentationScopeInfo.equals(that.getInstrumentationScopeInfo()) && this.timestampEpochNanos == that.getTimestampEpochNanos() && this.observedTimestampEpochNanos == that.getObservedTimestampEpochNanos() && this.spanContext.equals(that.getSpanContext()) && this.severity.equals((Object)that.getSeverity()) && (this.severityText == null ? that.getSeverityText() == null : this.severityText.equals(that.getSeverityText())) && this.totalAttributeCount == that.getTotalAttributeCount() && this.extendedAttributes.equals((Object)that.getExtendedAttributes()) && (this.bodyValue == null ? that.getBodyValue() == null : this.bodyValue.equals(that.getBodyValue())) && (this.eventName == null ? that.getEventName() == null : this.eventName.equals(that.getEventName()));
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.resource.hashCode();
        h$ *= 1000003;
        h$ ^= this.instrumentationScopeInfo.hashCode();
        h$ *= 1000003;
        h$ ^= (int)(this.timestampEpochNanos >>> 32 ^ this.timestampEpochNanos);
        h$ *= 1000003;
        h$ ^= (int)(this.observedTimestampEpochNanos >>> 32 ^ this.observedTimestampEpochNanos);
        h$ *= 1000003;
        h$ ^= this.spanContext.hashCode();
        h$ *= 1000003;
        h$ ^= this.severity.hashCode();
        h$ *= 1000003;
        h$ ^= this.severityText == null ? 0 : this.severityText.hashCode();
        h$ *= 1000003;
        h$ ^= this.totalAttributeCount;
        h$ *= 1000003;
        h$ ^= this.extendedAttributes.hashCode();
        h$ *= 1000003;
        h$ ^= this.bodyValue == null ? 0 : this.bodyValue.hashCode();
        h$ *= 1000003;
        return h$ ^= this.eventName == null ? 0 : this.eventName.hashCode();
    }

    static final class Builder
    extends TestExtendedLogRecordData.Builder {
        private Resource resource;
        private InstrumentationScopeInfo instrumentationScopeInfo;
        private long timestampEpochNanos;
        private long observedTimestampEpochNanos;
        private SpanContext spanContext;
        private Severity severity;
        private String severityText;
        private int totalAttributeCount;
        private ExtendedAttributes extendedAttributes;
        private Value<?> bodyValue;
        private String eventName;
        private byte set$0;

        Builder() {
        }

        @Override
        public TestExtendedLogRecordData.Builder setResource(Resource resource) {
            if (resource == null) {
                throw new NullPointerException("Null resource");
            }
            this.resource = resource;
            return this;
        }

        @Override
        public TestExtendedLogRecordData.Builder setInstrumentationScopeInfo(InstrumentationScopeInfo instrumentationScopeInfo) {
            if (instrumentationScopeInfo == null) {
                throw new NullPointerException("Null instrumentationScopeInfo");
            }
            this.instrumentationScopeInfo = instrumentationScopeInfo;
            return this;
        }

        @Override
        TestExtendedLogRecordData.Builder setTimestampEpochNanos(long timestampEpochNanos) {
            this.timestampEpochNanos = timestampEpochNanos;
            this.set$0 = (byte)(this.set$0 | 1);
            return this;
        }

        @Override
        TestExtendedLogRecordData.Builder setObservedTimestampEpochNanos(long observedTimestampEpochNanos) {
            this.observedTimestampEpochNanos = observedTimestampEpochNanos;
            this.set$0 = (byte)(this.set$0 | 2);
            return this;
        }

        @Override
        public TestExtendedLogRecordData.Builder setSpanContext(SpanContext spanContext) {
            if (spanContext == null) {
                throw new NullPointerException("Null spanContext");
            }
            this.spanContext = spanContext;
            return this;
        }

        @Override
        public TestExtendedLogRecordData.Builder setSeverity(Severity severity) {
            if (severity == null) {
                throw new NullPointerException("Null severity");
            }
            this.severity = severity;
            return this;
        }

        @Override
        public TestExtendedLogRecordData.Builder setSeverityText(String severityText) {
            this.severityText = severityText;
            return this;
        }

        @Override
        public TestExtendedLogRecordData.Builder setTotalAttributeCount(int totalAttributeCount) {
            this.totalAttributeCount = totalAttributeCount;
            this.set$0 = (byte)(this.set$0 | 4);
            return this;
        }

        @Override
        public TestExtendedLogRecordData.Builder setExtendedAttributes(ExtendedAttributes extendedAttributes) {
            if (extendedAttributes == null) {
                throw new NullPointerException("Null extendedAttributes");
            }
            this.extendedAttributes = extendedAttributes;
            return this;
        }

        @Override
        public TestExtendedLogRecordData.Builder setBodyValue(@Nullable Value<?> bodyValue) {
            this.bodyValue = bodyValue;
            return this;
        }

        @Override
        public TestExtendedLogRecordData.Builder setEventName(String eventName) {
            this.eventName = eventName;
            return this;
        }

        @Override
        TestExtendedLogRecordData autoBuild() {
            if (this.set$0 != 7 || this.resource == null || this.instrumentationScopeInfo == null || this.spanContext == null || this.severity == null || this.extendedAttributes == null) {
                StringBuilder missing = new StringBuilder();
                if (this.resource == null) {
                    missing.append(" resource");
                }
                if (this.instrumentationScopeInfo == null) {
                    missing.append(" instrumentationScopeInfo");
                }
                if ((this.set$0 & 1) == 0) {
                    missing.append(" timestampEpochNanos");
                }
                if ((this.set$0 & 2) == 0) {
                    missing.append(" observedTimestampEpochNanos");
                }
                if (this.spanContext == null) {
                    missing.append(" spanContext");
                }
                if (this.severity == null) {
                    missing.append(" severity");
                }
                if ((this.set$0 & 4) == 0) {
                    missing.append(" totalAttributeCount");
                }
                if (this.extendedAttributes == null) {
                    missing.append(" extendedAttributes");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_TestExtendedLogRecordData(this.resource, this.instrumentationScopeInfo, this.timestampEpochNanos, this.observedTimestampEpochNanos, this.spanContext, this.severity, this.severityText, this.totalAttributeCount, this.extendedAttributes, this.bodyValue, this.eventName);
        }
    }
}

