/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.trace;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.incubator.propagation.ExtendedContextPropagators;
import io.opentelemetry.api.incubator.trace.ExtendedSpanBuilder;
import io.opentelemetry.api.incubator.trace.SpanCallable;
import io.opentelemetry.api.incubator.trace.SpanRunnable;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import io.opentelemetry.sdk.trace.SdkSpanBuilder;
import io.opentelemetry.sdk.trace.SpanLimits;
import io.opentelemetry.sdk.trace.TracerSharedState;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;

final class ExtendedSdkSpanBuilder
extends SdkSpanBuilder
implements ExtendedSpanBuilder {
    ExtendedSdkSpanBuilder(String spanName, InstrumentationScopeInfo instrumentationScopeInfo, TracerSharedState tracerSharedState, SpanLimits spanLimits) {
        super(spanName, instrumentationScopeInfo, tracerSharedState, spanLimits);
    }

    public ExtendedSpanBuilder setParent(Context context) {
        super.setParent(context);
        return this;
    }

    public ExtendedSpanBuilder setNoParent() {
        super.setNoParent();
        return this;
    }

    public ExtendedSpanBuilder setSpanKind(SpanKind spanKind) {
        super.setSpanKind(spanKind);
        return this;
    }

    public ExtendedSpanBuilder addLink(SpanContext spanContext) {
        super.addLink(spanContext);
        return this;
    }

    public ExtendedSpanBuilder addLink(SpanContext spanContext, Attributes attributes) {
        super.addLink(spanContext, attributes);
        return this;
    }

    public ExtendedSpanBuilder setAttribute(String key, String value) {
        super.setAttribute(key, value);
        return this;
    }

    public ExtendedSpanBuilder setAttribute(String key, long value) {
        super.setAttribute(key, value);
        return this;
    }

    public ExtendedSpanBuilder setAttribute(String key, double value) {
        super.setAttribute(key, value);
        return this;
    }

    public ExtendedSpanBuilder setAttribute(String key, boolean value) {
        super.setAttribute(key, value);
        return this;
    }

    public <T> ExtendedSpanBuilder setAttribute(AttributeKey<T> key, T value) {
        super.setAttribute(key, value);
        return this;
    }

    public ExtendedSpanBuilder setStartTimestamp(long startTimestamp, TimeUnit unit) {
        super.setStartTimestamp(startTimestamp, unit);
        return this;
    }

    public ExtendedSpanBuilder setParentFrom(ContextPropagators propagators, Map<String, String> carrier) {
        super.setParent(ExtendedContextPropagators.extractTextMapPropagationContext(carrier, (ContextPropagators)propagators));
        return this;
    }

    public <T, E extends Throwable> T startAndCall(SpanCallable<T, E> spanCallable) throws E {
        return this.startAndCall(spanCallable, ExtendedSdkSpanBuilder::setSpanError);
    }

    public <T, E extends Throwable> T startAndCall(SpanCallable<T, E> spanCallable, BiConsumer<Span, Throwable> handleException) throws E {
        Span span = this.startSpan();
        try {
            Object object;
            block11: {
                Scope unused = span.makeCurrent();
                try {
                    object = spanCallable.callInSpan();
                    if (unused == null) break block11;
                    unused.close();
                }
                catch (Throwable throwable) {
                    try {
                        if (unused != null) {
                            try {
                                unused.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable e) {
                        handleException.accept(span, e);
                        throw e;
                    }
                }
            }
            return (T)object;
        }
        finally {
            span.end();
        }
    }

    public <E extends Throwable> void startAndRun(SpanRunnable<E> runnable2) throws E {
        this.startAndRun(runnable2, ExtendedSdkSpanBuilder::setSpanError);
    }

    public <E extends Throwable> void startAndRun(SpanRunnable<E> runnable2, BiConsumer<Span, Throwable> handleException) throws E {
        this.startAndCall(() -> {
            runnable2.runInSpan();
            return null;
        }, handleException);
    }

    private static void setSpanError(Span span, Throwable exception) {
        span.setStatus(StatusCode.ERROR);
        span.recordException(exception);
    }
}

