/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.prometheus.internal;

import io.opentelemetry.api.incubator.config.DeclarativeConfigProperties;
import io.opentelemetry.exporter.prometheus.PrometheusHttpServer;
import io.opentelemetry.exporter.prometheus.PrometheusHttpServerBuilder;
import io.opentelemetry.sdk.autoconfigure.spi.internal.ComponentProvider;
import io.opentelemetry.sdk.internal.IncludeExcludePredicate;
import io.opentelemetry.sdk.metrics.export.MetricReader;
import java.util.List;

public class PrometheusComponentProvider
implements ComponentProvider<MetricReader> {
    @Override
    public Class<MetricReader> getType() {
        return MetricReader.class;
    }

    @Override
    public String getName() {
        return "prometheus";
    }

    @Override
    public MetricReader create(DeclarativeConfigProperties config) {
        DeclarativeConfigProperties withResourceConstantLabels;
        String host;
        PrometheusHttpServerBuilder prometheusBuilder = PrometheusHttpServer.builder();
        Integer port = config.getInt("port");
        if (port != null) {
            prometheusBuilder.setPort(port);
        }
        if ((host = config.getString("host")) != null) {
            prometheusBuilder.setHost(host);
        }
        if ((withResourceConstantLabels = config.getStructured("with_resource_constant_labels")) != null) {
            List included = withResourceConstantLabels.getScalarList("included", String.class);
            List excluded = withResourceConstantLabels.getScalarList("excluded", String.class);
            if (included != null || excluded != null) {
                prometheusBuilder.setAllowedResourceAttributesFilter(IncludeExcludePredicate.createPatternMatching(included, excluded));
            }
        }
        return prometheusBuilder.build();
    }
}

