/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.internal.metrics;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.metrics.DoubleHistogram;
import io.opentelemetry.api.metrics.LongCounter;
import io.opentelemetry.api.metrics.LongUpDownCounter;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.MeterProvider;
import io.opentelemetry.exporter.internal.metrics.ExporterMetrics;
import io.opentelemetry.sdk.common.Clock;
import io.opentelemetry.sdk.internal.ComponentId;
import io.opentelemetry.sdk.internal.SemConvAttributes;
import io.opentelemetry.sdk.internal.Signal;
import java.util.Collections;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public class SemConvExporterMetrics
implements ExporterMetrics {
    private static final Clock CLOCK = Clock.getDefault();
    private final Supplier<MeterProvider> meterProviderSupplier;
    private final Signal signal;
    private final ComponentId componentId;
    private final Attributes additionalAttributes;
    @Nullable
    private volatile LongUpDownCounter inflight = null;
    @Nullable
    private volatile LongCounter exported = null;
    @Nullable
    private volatile DoubleHistogram duration = null;
    @Nullable
    private volatile Attributes allAttributes = null;

    public SemConvExporterMetrics(Supplier<MeterProvider> meterProviderSupplier, Signal signal, ComponentId componentId, Attributes additionalAttributes) {
        this.meterProviderSupplier = meterProviderSupplier;
        this.componentId = componentId;
        this.signal = signal;
        this.additionalAttributes = additionalAttributes;
    }

    @Override
    public ExporterMetrics.Recording startRecordingExport(int itemCount) {
        return new Recording(itemCount);
    }

    private Meter meter() {
        MeterProvider meterProvider = this.meterProviderSupplier.get();
        if (meterProvider == null) {
            meterProvider = MeterProvider.noop();
        }
        return meterProvider.get("io.opentelemetry.exporters." + this.componentId.getTypeName());
    }

    private Attributes allAttributes() {
        Attributes allAttributes = this.allAttributes;
        if (allAttributes == null) {
            AttributesBuilder builder = Attributes.builder();
            builder.put(SemConvAttributes.OTEL_COMPONENT_TYPE, this.componentId.getTypeName());
            builder.put(SemConvAttributes.OTEL_COMPONENT_NAME, this.componentId.getComponentName());
            builder.putAll(this.additionalAttributes);
            this.allAttributes = allAttributes = builder.build();
        }
        return allAttributes;
    }

    private LongUpDownCounter inflight() {
        LongUpDownCounter inflight = this.inflight;
        if (inflight == null || SemConvExporterMetrics.isNoop(inflight)) {
            String unit = this.signal.getMetricUnit();
            this.inflight = inflight = this.meter().upDownCounterBuilder(this.signal.getExporterMetricNamespace() + ".inflight").setUnit("{" + unit + "}").setDescription("The number of " + unit + "s which were passed to the exporter, but that have not been exported yet (neither successful, nor failed)").build();
        }
        return inflight;
    }

    private LongCounter exported() {
        LongCounter exported = this.exported;
        if (exported == null || SemConvExporterMetrics.isNoop(exported)) {
            String unit = this.signal.getMetricUnit();
            this.exported = exported = this.meter().counterBuilder(this.signal.getExporterMetricNamespace() + ".exported").setUnit("{" + unit + "}").setDescription("The number of " + unit + "s for which the export has finished, either successful or failed").build();
        }
        return exported;
    }

    private DoubleHistogram duration() {
        DoubleHistogram duration = this.duration;
        if (duration == null || SemConvExporterMetrics.isNoop(duration)) {
            this.duration = duration = this.meter().histogramBuilder("otel.sdk.exporter.operation.duration").setUnit("s").setDescription("The duration of exporting a batch of telemetry records").setExplicitBucketBoundariesAdvice(Collections.emptyList()).build();
        }
        return duration;
    }

    private void incrementInflight(long count) {
        this.inflight().add(count, this.allAttributes());
    }

    private void decrementInflight(long count) {
        this.inflight().add(-count, this.allAttributes());
    }

    private void incrementExported(long count, @Nullable String errorType) {
        this.exported().add(count, this.getAttributesWithPotentialError(errorType, Attributes.empty()));
    }

    static boolean isNoop(Object instrument) {
        return instrument.getClass().getSimpleName().startsWith("Noop");
    }

    private Attributes getAttributesWithPotentialError(@Nullable String errorType, Attributes additionalAttributes) {
        boolean errorPresent;
        Attributes attributes = this.allAttributes();
        boolean bl = errorPresent = errorType != null && !errorType.isEmpty();
        if (errorPresent || !additionalAttributes.isEmpty()) {
            AttributesBuilder builder = attributes.toBuilder();
            if (errorPresent) {
                builder.put(SemConvAttributes.ERROR_TYPE, errorType);
            }
            attributes = builder.putAll(additionalAttributes).build();
        }
        return attributes;
    }

    private void recordDuration(double seconds, @Nullable String errorType, Attributes requestAttributes) {
        this.duration().record(seconds, this.getAttributesWithPotentialError(errorType, requestAttributes));
    }

    private class Recording
    extends ExporterMetrics.Recording {
        private final int itemCount;
        private final long startNanoTime;

        private Recording(int itemCount) {
            this.itemCount = itemCount;
            this.startNanoTime = CLOCK.nanoTime();
            SemConvExporterMetrics.this.incrementInflight(itemCount);
        }

        @Override
        protected void doFinish(@Nullable String errorType, Attributes requestAttributes) {
            SemConvExporterMetrics.this.decrementInflight(this.itemCount);
            SemConvExporterMetrics.this.incrementExported(this.itemCount, errorType);
            long durationNanos = CLOCK.nanoTime() - this.startNanoTime;
            SemConvExporterMetrics.this.recordDuration((double)durationNanos / 1.0E9, errorType, requestAttributes);
        }
    }
}

