/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.internal.view;

import io.opentelemetry.sdk.metrics.aggregator.AggregatorFactory;
import io.opentelemetry.sdk.metrics.common.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.common.InstrumentType;
import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.internal.view.ViewRegistryBuilder;
import io.opentelemetry.sdk.metrics.view.View;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class ViewRegistry {
    static final View CUMULATIVE_SUM = View.builder().setAggregatorFactory(AggregatorFactory.sum(AggregationTemporality.CUMULATIVE)).build();
    static final View SUMMARY = View.builder().setAggregatorFactory(AggregatorFactory.minMaxSumCount()).build();
    static final View LAST_VALUE = View.builder().setAggregatorFactory(AggregatorFactory.lastValue()).build();
    private final EnumMap<InstrumentType, LinkedHashMap<Pattern, View>> configuration = new EnumMap(InstrumentType.class);

    ViewRegistry(EnumMap<InstrumentType, LinkedHashMap<Pattern, View>> configuration) {
        configuration.forEach((instrumentType, patternViewLinkedHashMap) -> this.configuration.put((InstrumentType)((Object)instrumentType), new LinkedHashMap(patternViewLinkedHashMap)));
    }

    public static ViewRegistryBuilder builder() {
        return new ViewRegistryBuilder();
    }

    public View findView(InstrumentDescriptor descriptor) {
        LinkedHashMap<Pattern, View> configPerType = this.configuration.get((Object)descriptor.getType());
        for (Map.Entry<Pattern, View> entry : configPerType.entrySet()) {
            if (!entry.getKey().matcher(descriptor.getName()).matches()) continue;
            return entry.getValue();
        }
        return ViewRegistry.getDefaultSpecification(descriptor);
    }

    private static View getDefaultSpecification(InstrumentDescriptor descriptor) {
        switch (descriptor.getType()) {
            case COUNTER: 
            case UP_DOWN_COUNTER: 
            case OBSERVABLE_SUM: 
            case OBSERVABLE_UP_DOWN_SUM: {
                return CUMULATIVE_SUM;
            }
            case HISTOGRAM: {
                return SUMMARY;
            }
            case OBSERVABLE_GAUGE: {
                return LAST_VALUE;
            }
        }
        throw new IllegalArgumentException("Unknown descriptor type: " + (Object)((Object)descriptor.getType()));
    }
}

