/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.internal.state;

import io.opentelemetry.sdk.metrics.internal.descriptor.MetricDescriptor;
import io.opentelemetry.sdk.metrics.internal.state.MetricStorage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class MetricStorageRegistry {
    private final ConcurrentMap<String, MetricStorage> registry = new ConcurrentHashMap<String, MetricStorage>();

    public Collection<MetricStorage> getMetrics() {
        return Collections.unmodifiableCollection(new ArrayList(this.registry.values()));
    }

    public <I extends MetricStorage> I register(I storage) {
        MetricDescriptor descriptor = storage.getMetricDescriptor();
        MetricStorage oldOrNewStorage = this.registry.computeIfAbsent(descriptor.getName().toLowerCase(), key -> storage);
        if (!oldOrNewStorage.getMetricDescriptor().isCompatibleWith(descriptor)) {
            throw new IllegalArgumentException("Metric with same name and different descriptor already created.   Found: " + oldOrNewStorage.getMetricDescriptor() + ", Want: " + descriptor);
        }
        if (!storage.getClass().equals(oldOrNewStorage.getClass())) {
            throw new IllegalArgumentException("Metric with same name and different instrument already created.   Found: " + oldOrNewStorage.getClass() + ", Want: " + storage.getClass());
        }
        return (I)oldOrNewStorage;
    }
}

