/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.autoconfigure;

import io.opentelemetry.sdk.autoconfigure.ConfigProperties;
import io.opentelemetry.sdk.autoconfigure.ConfigurationException;
import io.opentelemetry.sdk.autoconfigure.SpanExporterConfiguration;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigurableSamplerProvider;
import io.opentelemetry.sdk.autoconfigure.spi.SdkTracerProviderConfigurer;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.SdkTracerProvider;
import io.opentelemetry.sdk.trace.SdkTracerProviderBuilder;
import io.opentelemetry.sdk.trace.SpanLimits;
import io.opentelemetry.sdk.trace.SpanLimitsBuilder;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.export.BatchSpanProcessor;
import io.opentelemetry.sdk.trace.export.BatchSpanProcessorBuilder;
import io.opentelemetry.sdk.trace.export.SimpleSpanProcessor;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import io.opentelemetry.sdk.trace.samplers.Sampler;
import java.time.Duration;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

final class TracerProviderConfiguration {
    static SdkTracerProvider configureTracerProvider(Resource resource, ConfigProperties config) {
        SpanExporter exporter;
        SdkTracerProviderBuilder tracerProviderBuilder = SdkTracerProvider.builder().setResource(resource).setSpanLimits(TracerProviderConfiguration.configureSpanLimits(config));
        String sampler = config.getString("otel.traces.sampler");
        if (sampler != null) {
            tracerProviderBuilder.setSampler(TracerProviderConfiguration.configureSampler(sampler, config));
        }
        for (SdkTracerProviderConfigurer configurer : ServiceLoader.load(SdkTracerProviderConfigurer.class)) {
            configurer.configure(tracerProviderBuilder);
        }
        String exporterName = config.getString("otel.traces.exporter");
        if (exporterName == null) {
            exporterName = "otlp";
        }
        if ((exporter = SpanExporterConfiguration.configureExporter(exporterName, config)) != null) {
            tracerProviderBuilder.addSpanProcessor(TracerProviderConfiguration.configureSpanProcessor(config, exporter, exporterName));
        }
        SdkTracerProvider tracerProvider = tracerProviderBuilder.build();
        Runtime.getRuntime().addShutdownHook(new Thread(tracerProvider::close));
        return tracerProvider;
    }

    static SpanProcessor configureSpanProcessor(ConfigProperties config, SpanExporter exporter, String exporterName) {
        if (exporterName.equals("logging")) {
            return SimpleSpanProcessor.create(exporter);
        }
        return TracerProviderConfiguration.configureSpanProcessor(config, exporter);
    }

    static BatchSpanProcessor configureSpanProcessor(ConfigProperties config, SpanExporter exporter) {
        Duration timeout;
        Integer maxExportBatch;
        Integer maxQueue;
        BatchSpanProcessorBuilder builder = BatchSpanProcessor.builder(exporter);
        Duration scheduleDelay = config.getDuration("otel.bsp.schedule.delay");
        if (scheduleDelay != null) {
            builder.setScheduleDelay(scheduleDelay);
        }
        if ((maxQueue = config.getInt("otel.bsp.max.queue.size")) != null) {
            builder.setMaxQueueSize(maxQueue);
        }
        if ((maxExportBatch = config.getInt("otel.bsp.max.export.batch.size")) != null) {
            builder.setMaxExportBatchSize(maxExportBatch);
        }
        if ((timeout = config.getDuration("otel.bsp.export.timeout")) != null) {
            builder.setExporterTimeout(timeout);
        }
        return builder.build();
    }

    static SpanLimits configureSpanLimits(ConfigProperties config) {
        Integer maxLinks;
        Integer maxEvents;
        SpanLimitsBuilder builder = SpanLimits.builder();
        Integer maxAttrs = config.getInt("otel.span.attribute.count.limit");
        if (maxAttrs != null) {
            builder.setMaxNumberOfAttributes(maxAttrs);
        }
        if ((maxEvents = config.getInt("otel.span.event.count.limit")) != null) {
            builder.setMaxNumberOfEvents(maxEvents);
        }
        if ((maxLinks = config.getInt("otel.span.link.count.limit")) != null) {
            builder.setMaxNumberOfLinks(maxLinks);
        }
        return builder.build();
    }

    static Sampler configureSampler(String sampler, ConfigProperties config) {
        Map<String, Sampler> spiSamplers = StreamSupport.stream(ServiceLoader.load(ConfigurableSamplerProvider.class).spliterator(), false).collect(Collectors.toMap(ConfigurableSamplerProvider::getName, provider -> provider.createSampler(config)));
        switch (sampler) {
            case "always_on": {
                return Sampler.alwaysOn();
            }
            case "always_off": {
                return Sampler.alwaysOff();
            }
            case "traceidratio": {
                Double ratio = config.getDouble("otel.traces.sampler.arg");
                if (ratio == null) {
                    ratio = 1.0;
                }
                return Sampler.traceIdRatioBased(ratio);
            }
            case "parentbased_always_on": {
                return Sampler.parentBased(Sampler.alwaysOn());
            }
            case "parentbased_always_off": {
                return Sampler.parentBased(Sampler.alwaysOff());
            }
            case "parentbased_traceidratio": {
                Double ratio = config.getDouble("otel.traces.sampler.arg");
                if (ratio == null) {
                    ratio = 1.0;
                }
                return Sampler.parentBased(Sampler.traceIdRatioBased(ratio));
            }
        }
        Sampler spiSampler = spiSamplers.get(sampler);
        if (spiSampler == null) {
            throw new ConfigurationException("Unrecognized value for otel.traces.sampler: " + sampler);
        }
        return spiSampler;
    }

    private TracerProviderConfiguration() {
    }
}

