/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.autoconfigure;

import io.opentelemetry.exporter.jaeger.JaegerGrpcSpanExporter;
import io.opentelemetry.exporter.jaeger.JaegerGrpcSpanExporterBuilder;
import io.opentelemetry.exporter.logging.LoggingSpanExporter;
import io.opentelemetry.exporter.otlp.trace.OtlpGrpcSpanExporter;
import io.opentelemetry.exporter.otlp.trace.OtlpGrpcSpanExporterBuilder;
import io.opentelemetry.exporter.zipkin.ZipkinSpanExporter;
import io.opentelemetry.exporter.zipkin.ZipkinSpanExporterBuilder;
import io.opentelemetry.sdk.autoconfigure.ClasspathUtil;
import io.opentelemetry.sdk.autoconfigure.ConfigProperties;
import io.opentelemetry.sdk.autoconfigure.ConfigurationException;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigurableSpanExporterProvider;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;

final class SpanExporterConfiguration {
    @Nullable
    static SpanExporter configureExporter(String name, ConfigProperties config) {
        Map<String, SpanExporter> spiExporters = StreamSupport.stream(ServiceLoader.load(ConfigurableSpanExporterProvider.class).spliterator(), false).collect(Collectors.toMap(ConfigurableSpanExporterProvider::getName, configurableSpanExporterProvider -> configurableSpanExporterProvider.createExporter(config)));
        switch (name) {
            case "otlp": {
                return SpanExporterConfiguration.configureOtlpSpans(config);
            }
            case "jaeger": {
                return SpanExporterConfiguration.configureJaeger(config);
            }
            case "zipkin": {
                return SpanExporterConfiguration.configureZipkin(config);
            }
            case "logging": {
                ClasspathUtil.checkClassExists("io.opentelemetry.exporter.logging.LoggingSpanExporter", "Logging Trace Exporter", "opentelemetry-exporter-logging");
                return new LoggingSpanExporter();
            }
            case "none": {
                return null;
            }
        }
        SpanExporter spiExporter = spiExporters.get(name);
        if (spiExporter == null) {
            throw new ConfigurationException("Unrecognized value for otel.traces.exporter: " + name);
        }
        return spiExporter;
    }

    static OtlpGrpcSpanExporter configureOtlpSpans(ConfigProperties config) {
        String certificate;
        Map<String, String> headers;
        ClasspathUtil.checkClassExists("io.opentelemetry.exporter.otlp.trace.OtlpGrpcSpanExporter", "OTLP Trace Exporter", "opentelemetry-exporter-otlp");
        OtlpGrpcSpanExporterBuilder builder = OtlpGrpcSpanExporter.builder();
        String endpoint = config.getString("otel.exporter.otlp.traces.endpoint");
        if (endpoint == null) {
            endpoint = config.getString("otel.exporter.otlp.endpoint");
        }
        if (endpoint != null) {
            builder.setEndpoint(endpoint);
        }
        if ((headers = config.getCommaSeparatedMap("otel.exporter.otlp.traces.headers")).isEmpty()) {
            headers = config.getCommaSeparatedMap("otel.exporter.otlp.headers");
        }
        headers.forEach((arg_0, arg_1) -> ((OtlpGrpcSpanExporterBuilder)builder).addHeader(arg_0, arg_1));
        Duration timeout = config.getDuration("otel.exporter.otlp.traces.timeout");
        if (timeout == null) {
            timeout = config.getDuration("otel.exporter.otlp.timeout");
        }
        if (timeout != null) {
            builder.setTimeout(timeout);
        }
        if ((certificate = config.getString("otel.exporter.otlp.traces.certificate")) == null) {
            certificate = config.getString("otel.exporter.otlp.certificate");
        }
        if (certificate != null) {
            byte[] certificateBytes;
            Path path = Paths.get(certificate, new String[0]);
            if (!Files.exists(path, new LinkOption[0])) {
                throw new ConfigurationException("Invalid OTLP certificate path: " + path);
            }
            try {
                certificateBytes = Files.readAllBytes(path);
            }
            catch (IOException e) {
                throw new ConfigurationException("Error reading OTLP certificate.", e);
            }
            builder.setTrustedCertificates(certificateBytes);
        }
        return builder.build();
    }

    private static SpanExporter configureJaeger(ConfigProperties config) {
        Duration timeout;
        ClasspathUtil.checkClassExists("io.opentelemetry.exporter.jaeger.JaegerGrpcSpanExporter", "Jaeger gRPC Exporter", "opentelemetry-exporter-jaeger");
        JaegerGrpcSpanExporterBuilder builder = JaegerGrpcSpanExporter.builder();
        String endpoint = config.getString("otel.exporter.jaeger.endpoint");
        if (endpoint != null) {
            builder.setEndpoint(endpoint);
        }
        if ((timeout = config.getDuration("otel.exporter.jaeger.timeout")) != null) {
            builder.setTimeout(timeout);
        }
        return builder.build();
    }

    private static SpanExporter configureZipkin(ConfigProperties config) {
        Duration timeout;
        ClasspathUtil.checkClassExists("io.opentelemetry.exporter.zipkin.ZipkinSpanExporter", "Zipkin Exporter", "opentelemetry-exporter-zipkin");
        ZipkinSpanExporterBuilder builder = ZipkinSpanExporter.builder();
        String endpoint = config.getString("otel.exporter.zipkin.endpoint");
        if (endpoint != null) {
            builder.setEndpoint(endpoint);
        }
        if ((timeout = config.getDuration("otel.exporter.zipkin.timeout")) != null) {
            builder.setReadTimeout(timeout);
        }
        return builder.build();
    }

    private SpanExporterConfiguration() {
    }
}

