/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.otlp.internal;

import com.google.protobuf.ByteString;
import com.google.protobuf.UnsafeByteOperations;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.internal.OtelEncodingUtils;
import io.opentelemetry.api.trace.SpanId;
import io.opentelemetry.api.trace.TraceId;
import io.opentelemetry.exporter.otlp.internal.CommonAdapter;
import io.opentelemetry.exporter.otlp.internal.ResourceAdapter;
import io.opentelemetry.proto.common.v1.KeyValue;
import io.opentelemetry.proto.common.v1.StringKeyValue;
import io.opentelemetry.proto.metrics.v1.AggregationTemporality;
import io.opentelemetry.proto.metrics.v1.Exemplar;
import io.opentelemetry.proto.metrics.v1.Gauge;
import io.opentelemetry.proto.metrics.v1.Histogram;
import io.opentelemetry.proto.metrics.v1.HistogramDataPoint;
import io.opentelemetry.proto.metrics.v1.InstrumentationLibraryMetrics;
import io.opentelemetry.proto.metrics.v1.Metric;
import io.opentelemetry.proto.metrics.v1.NumberDataPoint;
import io.opentelemetry.proto.metrics.v1.ResourceMetrics;
import io.opentelemetry.proto.metrics.v1.Sum;
import io.opentelemetry.proto.metrics.v1.Summary;
import io.opentelemetry.proto.metrics.v1.SummaryDataPoint;
import io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import io.opentelemetry.sdk.internal.ThrottlingLogger;
import io.opentelemetry.sdk.metrics.data.DoubleExemplar;
import io.opentelemetry.sdk.metrics.data.DoubleGaugeData;
import io.opentelemetry.sdk.metrics.data.DoubleHistogramData;
import io.opentelemetry.sdk.metrics.data.DoubleHistogramPointData;
import io.opentelemetry.sdk.metrics.data.DoublePointData;
import io.opentelemetry.sdk.metrics.data.DoubleSumData;
import io.opentelemetry.sdk.metrics.data.DoubleSummaryData;
import io.opentelemetry.sdk.metrics.data.DoubleSummaryPointData;
import io.opentelemetry.sdk.metrics.data.LongExemplar;
import io.opentelemetry.sdk.metrics.data.LongGaugeData;
import io.opentelemetry.sdk.metrics.data.LongPointData;
import io.opentelemetry.sdk.metrics.data.LongSumData;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.data.ValueAtPercentile;
import io.opentelemetry.sdk.resources.Resource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class MetricAdapter {
    private static final ThrottlingLogger logger = new ThrottlingLogger(Logger.getLogger(MetricAdapter.class.getName()));

    public static List<ResourceMetrics> toProtoResourceMetrics(Collection<MetricData> metricData) {
        Map<Resource, Map<InstrumentationLibraryInfo, List<Metric>>> resourceAndLibraryMap = MetricAdapter.groupByResourceAndLibrary(metricData);
        ArrayList<ResourceMetrics> resourceMetrics = new ArrayList<ResourceMetrics>(resourceAndLibraryMap.size());
        for (Map.Entry<Resource, Map<InstrumentationLibraryInfo, List<Metric>>> entryResource : resourceAndLibraryMap.entrySet()) {
            ArrayList<InstrumentationLibraryMetrics> instrumentationLibraryMetrics = new ArrayList<InstrumentationLibraryMetrics>(entryResource.getValue().size());
            for (Map.Entry<InstrumentationLibraryInfo, List<Metric>> entryLibrary : entryResource.getValue().entrySet()) {
                instrumentationLibraryMetrics.add(MetricAdapter.buildInstrumentationLibraryMetrics(entryLibrary));
            }
            resourceMetrics.add(MetricAdapter.buildResourceMetrics(entryResource.getKey(), instrumentationLibraryMetrics));
        }
        return resourceMetrics;
    }

    private static ResourceMetrics buildResourceMetrics(Resource resource, List<InstrumentationLibraryMetrics> instrumentationLibraryMetrics) {
        ResourceMetrics.Builder resourceMetricsBuilder = ResourceMetrics.newBuilder().setResource(ResourceAdapter.toProtoResource(resource)).addAllInstrumentationLibraryMetrics(instrumentationLibraryMetrics);
        String schemaUrl = resource.getSchemaUrl();
        if (schemaUrl != null) {
            resourceMetricsBuilder.setSchemaUrl(schemaUrl);
        }
        return resourceMetricsBuilder.build();
    }

    private static InstrumentationLibraryMetrics buildInstrumentationLibraryMetrics(Map.Entry<InstrumentationLibraryInfo, List<Metric>> entryLibrary) {
        InstrumentationLibraryMetrics.Builder metricsBuilder = InstrumentationLibraryMetrics.newBuilder().setInstrumentationLibrary(CommonAdapter.toProtoInstrumentationLibrary(entryLibrary.getKey())).addAllMetrics((Iterable<? extends Metric>)entryLibrary.getValue());
        if (entryLibrary.getKey().getSchemaUrl() != null) {
            metricsBuilder.setSchemaUrl(entryLibrary.getKey().getSchemaUrl());
        }
        return metricsBuilder.build();
    }

    private static Map<Resource, Map<InstrumentationLibraryInfo, List<Metric>>> groupByResourceAndLibrary(Collection<MetricData> metricDataList) {
        HashMap<Resource, Map<InstrumentationLibraryInfo, List<Metric>>> result = new HashMap<Resource, Map<InstrumentationLibraryInfo, List<Metric>>>();
        for (MetricData metricData : metricDataList) {
            if (metricData.isEmpty()) continue;
            Resource resource = metricData.getResource();
            HashMap<InstrumentationLibraryInfo, List> libraryInfoListMap = (HashMap<InstrumentationLibraryInfo, List>)result.get(metricData.getResource());
            if (libraryInfoListMap == null) {
                libraryInfoListMap = new HashMap<InstrumentationLibraryInfo, List>();
                result.put(resource, libraryInfoListMap);
            }
            List metricList = libraryInfoListMap.computeIfAbsent(metricData.getInstrumentationLibraryInfo(), k -> new ArrayList());
            metricList.add(MetricAdapter.toProtoMetric(metricData));
        }
        return result;
    }

    static Metric toProtoMetric(MetricData metricData) {
        Metric.Builder builder = Metric.newBuilder().setName(metricData.getName()).setDescription(metricData.getDescription()).setUnit(metricData.getUnit());
        switch (metricData.getType()) {
            case LONG_SUM: {
                LongSumData longSumData = metricData.getLongSumData();
                builder.setSum(Sum.newBuilder().setIsMonotonic(longSumData.isMonotonic()).setAggregationTemporality(MetricAdapter.mapToTemporality(longSumData.getAggregationTemporality())).addAllDataPoints(MetricAdapter.toIntDataPoints(longSumData.getPoints())).build());
                break;
            }
            case DOUBLE_SUM: {
                DoubleSumData doubleSumData = metricData.getDoubleSumData();
                builder.setSum(Sum.newBuilder().setIsMonotonic(doubleSumData.isMonotonic()).setAggregationTemporality(MetricAdapter.mapToTemporality(doubleSumData.getAggregationTemporality())).addAllDataPoints(MetricAdapter.toDoubleDataPoints(doubleSumData.getPoints())).build());
                break;
            }
            case SUMMARY: {
                DoubleSummaryData doubleSummaryData = metricData.getDoubleSummaryData();
                builder.setSummary(Summary.newBuilder().addAllDataPoints(MetricAdapter.toSummaryDataPoints(doubleSummaryData.getPoints())).build());
                break;
            }
            case LONG_GAUGE: {
                LongGaugeData longGaugeData = metricData.getLongGaugeData();
                builder.setGauge(Gauge.newBuilder().addAllDataPoints(MetricAdapter.toIntDataPoints(longGaugeData.getPoints())).build());
                break;
            }
            case DOUBLE_GAUGE: {
                DoubleGaugeData doubleGaugeData = metricData.getDoubleGaugeData();
                builder.setGauge(Gauge.newBuilder().addAllDataPoints(MetricAdapter.toDoubleDataPoints(doubleGaugeData.getPoints())).build());
                break;
            }
            case HISTOGRAM: {
                DoubleHistogramData doubleHistogramData = metricData.getDoubleHistogramData();
                builder.setHistogram(Histogram.newBuilder().setAggregationTemporality(MetricAdapter.mapToTemporality(doubleHistogramData.getAggregationTemporality())).addAllDataPoints(MetricAdapter.toHistogramDataPoints(doubleHistogramData.getPoints())).build());
            }
        }
        return builder.build();
    }

    private static AggregationTemporality mapToTemporality(io.opentelemetry.sdk.metrics.data.AggregationTemporality temporality) {
        switch (temporality) {
            case CUMULATIVE: {
                return AggregationTemporality.AGGREGATION_TEMPORALITY_CUMULATIVE;
            }
            case DELTA: {
                return AggregationTemporality.AGGREGATION_TEMPORALITY_DELTA;
            }
        }
        return AggregationTemporality.AGGREGATION_TEMPORALITY_UNSPECIFIED;
    }

    static List<NumberDataPoint> toIntDataPoints(Collection<LongPointData> points) {
        ArrayList<NumberDataPoint> result = new ArrayList<NumberDataPoint>(points.size());
        for (LongPointData longPoint : points) {
            NumberDataPoint.Builder builder = NumberDataPoint.newBuilder().setStartTimeUnixNano(longPoint.getStartEpochNanos()).setTimeUnixNano(longPoint.getEpochNanos()).setAsInt(longPoint.getValue());
            MetricAdapter.fillAttributes(longPoint.getAttributes(), builder::addAttributes, builder::addLabels);
            longPoint.getExemplars().forEach(e -> builder.addExemplars(MetricAdapter.toExemplar(e)));
            result.add(builder.build());
        }
        return result;
    }

    static Collection<NumberDataPoint> toDoubleDataPoints(Collection<DoublePointData> points) {
        ArrayList<NumberDataPoint> result = new ArrayList<NumberDataPoint>(points.size());
        for (DoublePointData doublePoint : points) {
            NumberDataPoint.Builder builder = NumberDataPoint.newBuilder().setStartTimeUnixNano(doublePoint.getStartEpochNanos()).setTimeUnixNano(doublePoint.getEpochNanos()).setAsDouble(doublePoint.getValue());
            MetricAdapter.fillAttributes(doublePoint.getAttributes(), builder::addAttributes, builder::addLabels);
            doublePoint.getExemplars().forEach(e -> builder.addExemplars(MetricAdapter.toExemplar(e)));
            result.add(builder.build());
        }
        return result;
    }

    static List<SummaryDataPoint> toSummaryDataPoints(Collection<DoubleSummaryPointData> points) {
        ArrayList<SummaryDataPoint> result = new ArrayList<SummaryDataPoint>(points.size());
        for (DoubleSummaryPointData doubleSummaryPoint : points) {
            SummaryDataPoint.Builder builder = SummaryDataPoint.newBuilder().setStartTimeUnixNano(doubleSummaryPoint.getStartEpochNanos()).setTimeUnixNano(doubleSummaryPoint.getEpochNanos()).setCount(doubleSummaryPoint.getCount()).setSum(doubleSummaryPoint.getSum());
            MetricAdapter.fillAttributes(doubleSummaryPoint.getAttributes(), builder::addAttributes, builder::addLabels);
            if (!doubleSummaryPoint.getPercentileValues().isEmpty()) {
                for (ValueAtPercentile valueAtPercentile : doubleSummaryPoint.getPercentileValues()) {
                    builder.addQuantileValues(SummaryDataPoint.ValueAtQuantile.newBuilder().setQuantile(valueAtPercentile.getPercentile() / 100.0).setValue(valueAtPercentile.getValue()).build());
                }
            }
            result.add(builder.build());
        }
        return result;
    }

    static Collection<HistogramDataPoint> toHistogramDataPoints(Collection<DoubleHistogramPointData> points) {
        ArrayList<HistogramDataPoint> result = new ArrayList<HistogramDataPoint>(points.size());
        for (DoubleHistogramPointData doubleHistogramPoint : points) {
            HistogramDataPoint.Builder builder = HistogramDataPoint.newBuilder().setStartTimeUnixNano(doubleHistogramPoint.getStartEpochNanos()).setTimeUnixNano(doubleHistogramPoint.getEpochNanos()).setCount(doubleHistogramPoint.getCount()).setSum(doubleHistogramPoint.getSum()).addAllBucketCounts(doubleHistogramPoint.getCounts());
            List<Double> boundaries = doubleHistogramPoint.getBoundaries();
            if (!boundaries.isEmpty()) {
                builder.addAllExplicitBounds(boundaries);
            }
            MetricAdapter.fillAttributes(doubleHistogramPoint.getAttributes(), builder::addAttributes, builder::addLabels);
            doubleHistogramPoint.getExemplars().forEach(e -> builder.addExemplars(MetricAdapter.toExemplar(e)));
            result.add(builder.build());
        }
        return result;
    }

    static Exemplar toExemplar(io.opentelemetry.sdk.metrics.data.Exemplar exemplar) {
        Exemplar.Builder builder = Exemplar.newBuilder();
        builder.setTimeUnixNano(exemplar.getEpochNanos());
        if (exemplar.getSpanId() != null) {
            builder.setSpanId(MetricAdapter.convertSpanId(exemplar.getSpanId()));
        }
        if (exemplar.getTraceId() != null) {
            builder.setTraceId(MetricAdapter.convertTraceId(exemplar.getTraceId()));
        }
        MetricAdapter.fillAttributes(exemplar.getFilteredAttributes(), builder::addFilteredAttributes, builder::addFilteredLabels);
        if (exemplar instanceof LongExemplar) {
            builder.setAsInt(((LongExemplar)exemplar).getValue());
        } else if (exemplar instanceof DoubleExemplar) {
            builder.setAsDouble(((DoubleExemplar)exemplar).getValue());
        } else if (logger.isLoggable(Level.SEVERE)) {
            logger.log(Level.SEVERE, "Unable to convert unknown exemplar type: " + exemplar);
        }
        return builder.build();
    }

    private static ByteString convertTraceId(String id) {
        return UnsafeByteOperations.unsafeWrap(OtelEncodingUtils.bytesFromBase16(id, TraceId.getLength()));
    }

    private static ByteString convertSpanId(String id) {
        return UnsafeByteOperations.unsafeWrap(OtelEncodingUtils.bytesFromBase16(id, SpanId.getLength()));
    }

    private static void fillAttributes(Attributes attributes, Consumer<KeyValue> attributeSetter, Consumer<StringKeyValue> labelSetter) {
        attributes.forEach((key, value) -> {
            attributeSetter.accept(CommonAdapter.toProtoAttribute(key, value));
            labelSetter.accept(StringKeyValue.newBuilder().setKey(key.getKey()).setValue(value.toString()).build());
        });
    }

    private MetricAdapter() {
    }
}

