/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.remote.opt.security;

import com.sun.jmx.remote.opt.util.ClassLogger;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.Properties;
import javax.management.remote.JMXAuthenticator;
import javax.management.remote.JMXPrincipal;
import javax.security.auth.Subject;

public class JMXPasswordAuthenticator
implements JMXAuthenticator {
    private Properties props;
    private Properties originalProps;
    private String pwFile;
    private static final ClassLogger logger = new ClassLogger("javax.management.remote.misc", "JMXPasswordAuthenticator");

    public JMXPasswordAuthenticator(String pwFile) throws IOException {
        this.pwFile = pwFile;
        this.props = JMXPasswordAuthenticator.propertiesFromFile(pwFile);
    }

    public JMXPasswordAuthenticator(Properties pwProps) {
        if (pwProps == null) {
            throw new IllegalArgumentException("Null properties");
        }
        this.originalProps = pwProps;
        this.props = (Properties)pwProps.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Subject authenticate(Object credentials) {
        String message;
        String localPasswd;
        String[] aCredentials;
        if (!(credentials instanceof String[])) {
            if (credentials == null) {
                JMXPasswordAuthenticator.authenticationFailure("authenticate", "Credentials required");
            }
            String message2 = "Credentials should be String[] instead of " + (credentials == null ? "null" : credentials.getClass().getName());
            JMXPasswordAuthenticator.authenticationFailure("authenticate", message2);
        }
        if ((aCredentials = (String[])credentials).length != 2) {
            String message3 = "Credentials should have 2 elements not " + aCredentials.length;
            JMXPasswordAuthenticator.authenticationFailure("authenticate", message3);
        }
        String username = aCredentials[0];
        String password = aCredentials[1];
        if (username == null || password == null) {
            String message4 = "Username or password is null";
            JMXPasswordAuthenticator.authenticationFailure("authenticate", "Username or password is null");
        }
        Properties properties = this.props;
        synchronized (properties) {
            localPasswd = this.props.getProperty(username);
        }
        if (password.equals(localPasswd)) {
            return new Subject(true, Collections.singleton(new JMXPrincipal(username)), Collections.EMPTY_SET, Collections.EMPTY_SET);
        }
        if (this.props.containsKey(username)) {
            message = "Invalid password for username [" + username + "]";
            JMXPasswordAuthenticator.authenticationFailure("authenticate", message);
        } else {
            message = "Invalid username/password";
            JMXPasswordAuthenticator.authenticationFailure("authenticate", "Invalid username/password");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() throws IOException {
        Properties properties = this.props;
        synchronized (properties) {
            this.props = this.pwFile == null ? (Properties)this.originalProps.clone() : JMXPasswordAuthenticator.propertiesFromFile(this.pwFile);
        }
    }

    private static Properties propertiesFromFile(String fname) throws IOException {
        FileInputStream fin = new FileInputStream(fname);
        Properties p = new Properties();
        p.load(fin);
        fin.close();
        return p;
    }

    private static void authenticationFailure(String method, String message) throws SecurityException {
        String msg = "Authentication failed! " + message;
        SecurityException e = new SecurityException(msg);
        JMXPasswordAuthenticator.logException(method, msg, e);
        throw e;
    }

    private static void logException(String method, String message, Exception e) {
        if (logger.traceOn()) {
            logger.trace(method, message);
        }
        if (logger.debugOn()) {
            logger.debug(method, e);
        }
    }
}

