/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.client;

import io.prometheus.client.Predicate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;

public class SampleNameFilter
implements Predicate<String> {
    public static final Predicate<String> ALLOW_ALL = new AllowAll();
    private final Collection<String> nameIsEqualTo;
    private final Collection<String> nameIsNotEqualTo;
    private final Collection<String> nameStartsWith;
    private final Collection<String> nameDoesNotStartWith;

    @Override
    public boolean test(String sampleName) {
        return this.matchesNameEqualTo(sampleName) && !this.matchesNameNotEqualTo(sampleName) && this.matchesNameStartsWith(sampleName) && !this.matchesNameDoesNotStartWith(sampleName);
    }

    public Predicate<String> and(final Predicate<? super String> other) {
        if (other == null) {
            throw new NullPointerException();
        }
        return new Predicate<String>(){

            @Override
            public boolean test(String s) {
                return SampleNameFilter.this.test(s) && other.test(s);
            }
        };
    }

    private boolean matchesNameEqualTo(String metricName) {
        if (this.nameIsEqualTo.isEmpty()) {
            return true;
        }
        return this.nameIsEqualTo.contains(metricName);
    }

    private boolean matchesNameNotEqualTo(String metricName) {
        if (this.nameIsNotEqualTo.isEmpty()) {
            return false;
        }
        return this.nameIsNotEqualTo.contains(metricName);
    }

    private boolean matchesNameStartsWith(String metricName) {
        if (this.nameStartsWith.isEmpty()) {
            return true;
        }
        for (String prefix : this.nameStartsWith) {
            if (!metricName.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    private boolean matchesNameDoesNotStartWith(String metricName) {
        if (this.nameDoesNotStartWith.isEmpty()) {
            return false;
        }
        for (String prefix : this.nameDoesNotStartWith) {
            if (!metricName.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    private SampleNameFilter(Collection<String> nameIsEqualTo, Collection<String> nameIsNotEqualTo, Collection<String> nameStartsWith, Collection<String> nameDoesNotStartWith) {
        this.nameIsEqualTo = Collections.unmodifiableCollection(nameIsEqualTo);
        this.nameIsNotEqualTo = Collections.unmodifiableCollection(nameIsNotEqualTo);
        this.nameStartsWith = Collections.unmodifiableCollection(nameStartsWith);
        this.nameDoesNotStartWith = Collections.unmodifiableCollection(nameDoesNotStartWith);
    }

    public static List<String> stringToList(String s) {
        ArrayList<String> result2 = new ArrayList<String>();
        if (s != null) {
            StringTokenizer tokenizer = new StringTokenizer(s, ",; \t\n");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if ((token = token.trim()).length() <= 0) continue;
                result2.add(token);
            }
        }
        return result2;
    }

    public static Predicate<String> restrictToNamesEqualTo(Predicate<String> filter, Collection<String> allowedNames) {
        if (allowedNames != null && !allowedNames.isEmpty()) {
            SampleNameFilter allowedNamesFilter = new Builder().nameMustBeEqualTo(allowedNames).build();
            if (filter == null) {
                return allowedNamesFilter;
            }
            return allowedNamesFilter.and(filter);
        }
        return filter;
    }

    private static class AllowAll
    implements Predicate<String> {
        private AllowAll() {
        }

        @Override
        public boolean test(String s) {
            return true;
        }
    }

    public static class Builder {
        private final Collection<String> nameEqualTo = new ArrayList<String>();
        private final Collection<String> nameNotEqualTo = new ArrayList<String>();
        private final Collection<String> nameStartsWith = new ArrayList<String>();
        private final Collection<String> nameDoesNotStartWith = new ArrayList<String>();

        public Builder nameMustBeEqualTo(String ... names) {
            return this.nameMustBeEqualTo(Arrays.asList(names));
        }

        public Builder nameMustBeEqualTo(Collection<String> names) {
            this.nameEqualTo.addAll(names);
            return this;
        }

        public Builder nameMustNotBeEqualTo(String ... names) {
            return this.nameMustNotBeEqualTo(Arrays.asList(names));
        }

        public Builder nameMustNotBeEqualTo(Collection<String> names) {
            this.nameNotEqualTo.addAll(names);
            return this;
        }

        public Builder nameMustStartWith(String ... prefixes) {
            return this.nameMustStartWith(Arrays.asList(prefixes));
        }

        public Builder nameMustStartWith(Collection<String> prefixes) {
            this.nameStartsWith.addAll(prefixes);
            return this;
        }

        public Builder nameMustNotStartWith(String ... prefixes) {
            return this.nameMustNotStartWith(Arrays.asList(prefixes));
        }

        public Builder nameMustNotStartWith(Collection<String> prefixes) {
            this.nameDoesNotStartWith.addAll(prefixes);
            return this;
        }

        public SampleNameFilter build() {
            return new SampleNameFilter(this.nameEqualTo, this.nameNotEqualTo, this.nameStartsWith, this.nameDoesNotStartWith);
        }
    }
}

