/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.testing.logs.internal;

import com.google.auto.value.AutoValue;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.Value;
import io.opentelemetry.api.incubator.common.ExtendedAttributes;
import io.opentelemetry.api.logs.Severity;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import io.opentelemetry.sdk.logs.data.Body;
import io.opentelemetry.sdk.logs.data.internal.ExtendedLogRecordData;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.testing.logs.internal.AutoValue_TestExtendedLogRecordData;
import java.time.Instant;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
@AutoValue
@AutoValue.CopyAnnotations
public abstract class TestExtendedLogRecordData
implements ExtendedLogRecordData {
    public static Builder builder() {
        return new AutoValue_TestExtendedLogRecordData.Builder().setResource(Resource.empty()).setInstrumentationScopeInfo(InstrumentationScopeInfo.empty()).setTimestamp(0L, TimeUnit.NANOSECONDS).setObservedTimestamp(0L, TimeUnit.NANOSECONDS).setSpanContext(SpanContext.getInvalid()).setSeverity(Severity.UNDEFINED_SEVERITY_NUMBER).setAttributes(Attributes.empty()).setTotalAttributeCount(0);
    }

    @Override
    @Deprecated
    public Body getBody() {
        Value<?> valueBody = this.getBodyValue();
        return valueBody == null ? Body.empty() : Body.string(valueBody.asString());
    }

    @Override
    @Nullable
    public abstract Value<?> getBodyValue();

    @Override
    @Nullable
    public abstract String getEventName();

    TestExtendedLogRecordData() {
    }

    @AutoValue.Builder
    public static abstract class Builder {
        abstract TestExtendedLogRecordData autoBuild();

        public TestExtendedLogRecordData build() {
            return this.autoBuild();
        }

        public abstract Builder setResource(Resource var1);

        public abstract Builder setInstrumentationScopeInfo(InstrumentationScopeInfo var1);

        public abstract Builder setEventName(String var1);

        public Builder setTimestamp(Instant instant) {
            return this.setTimestampEpochNanos(TimeUnit.SECONDS.toNanos(instant.getEpochSecond()) + (long)instant.getNano());
        }

        public Builder setTimestamp(long timestamp, TimeUnit unit) {
            return this.setTimestampEpochNanos(unit.toNanos(timestamp));
        }

        abstract Builder setTimestampEpochNanos(long var1);

        public Builder setObservedTimestamp(Instant instant) {
            return this.setObservedTimestampEpochNanos(TimeUnit.SECONDS.toNanos(instant.getEpochSecond()) + (long)instant.getNano());
        }

        public Builder setObservedTimestamp(long timestamp, TimeUnit unit) {
            return this.setObservedTimestampEpochNanos(unit.toNanos(timestamp));
        }

        abstract Builder setObservedTimestampEpochNanos(long var1);

        public abstract Builder setSpanContext(SpanContext var1);

        public abstract Builder setSeverity(Severity var1);

        public abstract Builder setSeverityText(String var1);

        public Builder setBody(String body) {
            return this.setBodyValue(Value.of(body));
        }

        @Deprecated
        public Builder setBody(Body body) {
            if (body.getType() == Body.Type.STRING) {
                this.setBodyValue(Value.of(body.asString()));
            } else if (body.getType() == Body.Type.EMPTY) {
                this.setBodyValue(null);
            }
            return this;
        }

        public abstract Builder setBodyValue(@Nullable Value<?> var1);

        public Builder setAttributes(Attributes attributes) {
            return this.setExtendedAttributes(ExtendedAttributes.builder().putAll(attributes).build());
        }

        public abstract Builder setTotalAttributeCount(int var1);

        public abstract Builder setExtendedAttributes(ExtendedAttributes var1);
    }
}

