/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.testing.assertj;

import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.data.ExponentialHistogramData;
import io.opentelemetry.sdk.testing.assertj.AssertUtil;
import io.opentelemetry.sdk.testing.assertj.ExponentialHistogramPointAssert;
import java.util.Arrays;
import java.util.function.Consumer;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;

public final class ExponentialHistogramAssert
extends AbstractAssert<ExponentialHistogramAssert, ExponentialHistogramData> {
    ExponentialHistogramAssert(ExponentialHistogramData actual) {
        super((Object)actual, ExponentialHistogramAssert.class);
    }

    public ExponentialHistogramAssert isCumulative() {
        this.isNotNull();
        if (((ExponentialHistogramData)this.actual).getAggregationTemporality() != AggregationTemporality.CUMULATIVE) {
            this.failWithActualExpectedAndMessage(this.actual, "aggregationTemporality: CUMULATIVE", "Expected Histogram to have cumulative aggregation but found <%s>", new Object[]{((ExponentialHistogramData)this.actual).getAggregationTemporality()});
        }
        return this;
    }

    public ExponentialHistogramAssert isDelta() {
        this.isNotNull();
        if (((ExponentialHistogramData)this.actual).getAggregationTemporality() != AggregationTemporality.DELTA) {
            this.failWithActualExpectedAndMessage(this.actual, "aggregationTemporality: DELTA", "Expected Histogram to have cumulative aggregation but found <%s>", new Object[]{AggregationTemporality.DELTA, ((ExponentialHistogramData)this.actual).getAggregationTemporality()});
        }
        return this;
    }

    @SafeVarargs
    public final ExponentialHistogramAssert hasPointsSatisfying(Consumer<ExponentialHistogramPointAssert> ... assertions) {
        return this.hasPointsSatisfying(Arrays.asList(assertions));
    }

    public ExponentialHistogramAssert hasPointsSatisfying(Iterable<? extends Consumer<ExponentialHistogramPointAssert>> assertions) {
        Assertions.assertThat(((ExponentialHistogramData)this.actual).getPoints()).satisfiesExactlyInAnyOrder((Consumer[])AssertUtil.toConsumers(assertions, ExponentialHistogramPointAssert::new));
        return this;
    }
}

