/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.testing.assertj;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.sdk.testing.assertj.AttributeAssertion;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.Assertions;

final class AssertUtil {
    static <T, U extends AbstractAssert<U, T>> Consumer<T>[] toConsumers(Iterable<? extends Consumer<U>> assertions, Function<T, U> assertionFactory) {
        Stream.Builder<Consumer<Object>> builder = Stream.builder();
        for (Consumer assertion : assertions) {
            builder.add(item -> assertion.accept((AbstractAssert)assertionFactory.apply(item)));
        }
        Consumer[] consumers = (Consumer[])builder.build().toArray(Consumer[]::new);
        return consumers;
    }

    static void assertAttributes(Attributes actual, Iterable<AttributeAssertion> assertions) {
        AssertUtil.assertAttributes(actual, assertions, "attribute keys");
    }

    static void assertAttributes(Attributes actual, Iterable<AttributeAssertion> assertions, String name) {
        Set<AttributeKey<?>> actualKeys = actual.asMap().keySet();
        HashSet checkedKeys = new HashSet();
        for (AttributeAssertion attributeAssertion : assertions) {
            AttributeKey<?> key = attributeAssertion.getKey();
            Object value = actual.get(key);
            if (value != null) {
                checkedKeys.add(key);
            }
            AbstractAssert<?, ?> assertion = AttributeAssertion.attributeValueAssertion(key, value);
            attributeAssertion.getAssertion().accept(assertion);
        }
        ((AbstractCollectionAssert)Assertions.assertThat(actualKeys).as(name, new Object[0])).containsAll(checkedKeys);
    }

    static void assertAttributesExactly(Attributes actual, Iterable<AttributeAssertion> assertions) {
        AssertUtil.assertAttributesExactly(actual, assertions, "attribute keys");
    }

    static void assertAttributesExactly(Attributes actual, Iterable<AttributeAssertion> assertions, String name) {
        Set<AttributeKey<?>> actualKeys = actual.asMap().keySet();
        HashSet checkedKeys = new HashSet();
        for (AttributeAssertion attributeAssertion : assertions) {
            AttributeKey<?> key = attributeAssertion.getKey();
            Object value = actual.get(key);
            if (value != null) {
                checkedKeys.add(key);
            }
            AbstractAssert<?, ?> assertion = AttributeAssertion.attributeValueAssertion(key, value);
            attributeAssertion.getAssertion().accept(assertion);
        }
        ((AbstractCollectionAssert)Assertions.assertThat(actualKeys).as(name, new Object[0])).containsExactlyInAnyOrderElementsOf(checkedKeys);
    }

    static boolean attributesAreEqual(Attributes actual, Attributes other) {
        return actual.asMap().equals(other.asMap());
    }

    private AssertUtil() {
    }
}

