/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.internal.descriptor;

import com.google.auto.value.AutoValue;
import io.opentelemetry.sdk.metrics.InstrumentType;
import io.opentelemetry.sdk.metrics.InstrumentValueType;
import io.opentelemetry.sdk.metrics.internal.debug.SourceInfo;
import io.opentelemetry.sdk.metrics.internal.descriptor.Advice;
import io.opentelemetry.sdk.metrics.internal.descriptor.AutoValue_InstrumentDescriptor;
import java.util.Locale;
import javax.annotation.concurrent.Immutable;

@AutoValue
@Immutable
public abstract class InstrumentDescriptor {
    private final SourceInfo sourceInfo = SourceInfo.fromCurrentStack();
    private int hashcode;

    public static InstrumentDescriptor create(String name, String description, String unit, InstrumentType type, InstrumentValueType valueType, Advice advice) {
        return new AutoValue_InstrumentDescriptor(name, description, unit, type, valueType, advice);
    }

    InstrumentDescriptor() {
    }

    public abstract String getName();

    public abstract String getDescription();

    public abstract String getUnit();

    public abstract InstrumentType getType();

    public abstract InstrumentValueType getValueType();

    public abstract Advice getAdvice();

    public final SourceInfo getSourceInfo() {
        return this.sourceInfo;
    }

    public final int hashCode() {
        int result2 = this.hashcode;
        if (result2 == 0) {
            result2 = 1;
            result2 *= 1000003;
            result2 ^= this.getName().toLowerCase(Locale.ROOT).hashCode();
            result2 *= 1000003;
            result2 ^= this.getDescription().hashCode();
            result2 *= 1000003;
            result2 ^= this.getUnit().hashCode();
            result2 *= 1000003;
            result2 ^= this.getType().hashCode();
            result2 *= 1000003;
            this.hashcode = result2 ^= this.getValueType().hashCode();
        }
        return result2;
    }

    public final boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof InstrumentDescriptor) {
            InstrumentDescriptor that = (InstrumentDescriptor)o;
            return this.getName().equalsIgnoreCase(that.getName()) && this.getDescription().equals(that.getDescription()) && this.getUnit().equals(that.getUnit()) && this.getType().equals((Object)that.getType()) && this.getValueType().equals((Object)that.getValueType());
        }
        return false;
    }
}

