/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.prometheus;

import com.sun.net.httpserver.Authenticator;
import com.sun.net.httpserver.HttpHandler;
import io.opentelemetry.api.internal.Utils;
import io.opentelemetry.exporter.prometheus.PrometheusHttpServer;
import io.opentelemetry.sdk.common.export.MemoryMode;
import io.opentelemetry.sdk.metrics.export.DefaultAggregationSelector;
import io.prometheus.metrics.model.registry.PrometheusRegistry;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.function.Predicate;
import javax.annotation.Nullable;

public final class PrometheusHttpServerBuilder {
    static final int DEFAULT_PORT = 9464;
    private static final String DEFAULT_HOST = "0.0.0.0";
    private static final MemoryMode DEFAULT_MEMORY_MODE = MemoryMode.REUSABLE_DATA;
    private String host = "0.0.0.0";
    private int port = 9464;
    private PrometheusRegistry prometheusRegistry = new PrometheusRegistry();
    private boolean otelScopeEnabled = true;
    @Nullable
    private Predicate<String> allowedResourceAttributesFilter;
    @Nullable
    private ExecutorService executor;
    private MemoryMode memoryMode = DEFAULT_MEMORY_MODE;
    @Nullable
    private HttpHandler defaultHandler;
    private DefaultAggregationSelector defaultAggregationSelector = DefaultAggregationSelector.getDefault();
    @Nullable
    private Authenticator authenticator;

    PrometheusHttpServerBuilder() {
    }

    PrometheusHttpServerBuilder(PrometheusHttpServerBuilder builder) {
        this.host = builder.host;
        this.port = builder.port;
        this.prometheusRegistry = builder.prometheusRegistry;
        this.otelScopeEnabled = builder.otelScopeEnabled;
        this.allowedResourceAttributesFilter = builder.allowedResourceAttributesFilter;
        this.executor = builder.executor;
        this.memoryMode = builder.memoryMode;
        this.defaultAggregationSelector = builder.defaultAggregationSelector;
        this.authenticator = builder.authenticator;
    }

    public PrometheusHttpServerBuilder setHost(String host) {
        Objects.requireNonNull(host, "host");
        Utils.checkArgument(!host.isEmpty(), "host must not be empty");
        this.host = host;
        return this;
    }

    public PrometheusHttpServerBuilder setPort(int port) {
        Utils.checkArgument(port >= 0, "port must be positive");
        this.port = port;
        return this;
    }

    public PrometheusHttpServerBuilder setExecutor(ExecutorService executor) {
        Objects.requireNonNull(executor, "executor");
        this.executor = executor;
        return this;
    }

    public PrometheusHttpServerBuilder setPrometheusRegistry(PrometheusRegistry prometheusRegistry) {
        Objects.requireNonNull(prometheusRegistry, "prometheusRegistry");
        this.prometheusRegistry = prometheusRegistry;
        return this;
    }

    public PrometheusHttpServerBuilder setOtelScopeEnabled(boolean otelScopeEnabled) {
        this.otelScopeEnabled = otelScopeEnabled;
        return this;
    }

    public PrometheusHttpServerBuilder setAllowedResourceAttributesFilter(Predicate<String> resourceAttributesFilter) {
        this.allowedResourceAttributesFilter = Objects.requireNonNull(resourceAttributesFilter);
        return this;
    }

    public PrometheusHttpServerBuilder setMemoryMode(MemoryMode memoryMode) {
        Objects.requireNonNull(memoryMode, "memoryMode");
        this.memoryMode = memoryMode;
        return this;
    }

    public PrometheusHttpServerBuilder setDefaultHandler(HttpHandler defaultHandler) {
        Objects.requireNonNull(defaultHandler, "defaultHandler");
        this.defaultHandler = defaultHandler;
        return this;
    }

    public PrometheusHttpServerBuilder setDefaultAggregationSelector(DefaultAggregationSelector defaultAggregationSelector) {
        Objects.requireNonNull(defaultAggregationSelector, "defaultAggregationSelector");
        this.defaultAggregationSelector = defaultAggregationSelector;
        return this;
    }

    public PrometheusHttpServerBuilder setAuthenticator(Authenticator authenticator) {
        Objects.requireNonNull(authenticator, "authenticator");
        this.authenticator = authenticator;
        return this;
    }

    public PrometheusHttpServer build() {
        if (this.memoryMode == MemoryMode.REUSABLE_DATA && this.executor != null) {
            throw new IllegalArgumentException("MemoryMode REUSEABLE_DATA cannot be used with custom executor, since data may be corrupted if reading metrics concurrently");
        }
        return new PrometheusHttpServer(new PrometheusHttpServerBuilder(this), this.host, this.port, this.executor, this.prometheusRegistry, this.otelScopeEnabled, this.allowedResourceAttributesFilter, this.memoryMode, this.defaultHandler, this.defaultAggregationSelector, this.authenticator);
    }
}

