/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.internal.metrics;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.LongCounter;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.MeterProvider;
import io.opentelemetry.exporter.internal.metrics.ExporterMetrics;
import io.opentelemetry.exporter.internal.metrics.SemConvExporterMetrics;
import io.opentelemetry.sdk.internal.Signal;
import io.opentelemetry.sdk.internal.StandardComponentId;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public class LegacyExporterMetrics
implements ExporterMetrics {
    private static final AttributeKey<String> ATTRIBUTE_KEY_TYPE = AttributeKey.stringKey("type");
    private static final AttributeKey<Boolean> ATTRIBUTE_KEY_SUCCESS = AttributeKey.booleanKey("success");
    private final Supplier<MeterProvider> meterProviderSupplier;
    private final String exporterName;
    private final String transportName;
    private final Attributes seenAttrs;
    private final Attributes successAttrs;
    private final Attributes failedAttrs;
    @Nullable
    private volatile LongCounter seen;
    @Nullable
    private volatile LongCounter exported;

    LegacyExporterMetrics(Supplier<MeterProvider> meterProviderSupplier, StandardComponentId.ExporterType exporterType) {
        this.meterProviderSupplier = meterProviderSupplier;
        this.exporterName = LegacyExporterMetrics.getExporterName(exporterType);
        this.transportName = LegacyExporterMetrics.getTransportName(exporterType);
        this.seenAttrs = Attributes.builder().put(ATTRIBUTE_KEY_TYPE, LegacyExporterMetrics.getTypeString(exporterType.signal())).build();
        this.successAttrs = this.seenAttrs.toBuilder().put(ATTRIBUTE_KEY_SUCCESS, Boolean.valueOf(true)).build();
        this.failedAttrs = this.seenAttrs.toBuilder().put(ATTRIBUTE_KEY_SUCCESS, Boolean.valueOf(false)).build();
    }

    public static boolean isSupportedType(StandardComponentId.ExporterType exporterType) {
        switch (exporterType) {
            case OTLP_GRPC_SPAN_EXPORTER: 
            case OTLP_HTTP_SPAN_EXPORTER: 
            case OTLP_HTTP_JSON_SPAN_EXPORTER: 
            case ZIPKIN_HTTP_SPAN_EXPORTER: 
            case ZIPKIN_HTTP_JSON_SPAN_EXPORTER: 
            case OTLP_GRPC_LOG_EXPORTER: 
            case OTLP_HTTP_LOG_EXPORTER: 
            case OTLP_HTTP_JSON_LOG_EXPORTER: 
            case OTLP_GRPC_METRIC_EXPORTER: 
            case OTLP_HTTP_METRIC_EXPORTER: 
            case OTLP_HTTP_JSON_METRIC_EXPORTER: {
                return true;
            }
        }
        return false;
    }

    private static String getTypeString(Signal signal) {
        switch (signal) {
            case SPAN: {
                return "span";
            }
            case LOG: {
                return "log";
            }
            case METRIC: {
                return "metric";
            }
            case PROFILE: {
                throw new IllegalArgumentException("Profiles are not supported");
            }
        }
        throw new IllegalArgumentException("Unhandled signal type: " + (Object)((Object)signal));
    }

    private static String getExporterName(StandardComponentId.ExporterType exporterType) {
        switch (exporterType) {
            case OTLP_GRPC_SPAN_EXPORTER: 
            case OTLP_HTTP_SPAN_EXPORTER: 
            case OTLP_HTTP_JSON_SPAN_EXPORTER: 
            case OTLP_GRPC_LOG_EXPORTER: 
            case OTLP_HTTP_LOG_EXPORTER: 
            case OTLP_HTTP_JSON_LOG_EXPORTER: 
            case OTLP_GRPC_METRIC_EXPORTER: 
            case OTLP_HTTP_METRIC_EXPORTER: 
            case OTLP_HTTP_JSON_METRIC_EXPORTER: {
                return "otlp";
            }
            case ZIPKIN_HTTP_SPAN_EXPORTER: 
            case ZIPKIN_HTTP_JSON_SPAN_EXPORTER: {
                return "zipkin";
            }
            case OTLP_GRPC_PROFILES_EXPORTER: {
                throw new IllegalArgumentException("Profiles are not supported");
            }
        }
        throw new IllegalArgumentException("Not a supported exporter type: " + (Object)((Object)exporterType));
    }

    private static String getTransportName(StandardComponentId.ExporterType exporterType) {
        switch (exporterType) {
            case OTLP_GRPC_SPAN_EXPORTER: 
            case OTLP_GRPC_LOG_EXPORTER: 
            case OTLP_GRPC_METRIC_EXPORTER: {
                return "grpc";
            }
            case OTLP_HTTP_SPAN_EXPORTER: 
            case ZIPKIN_HTTP_SPAN_EXPORTER: 
            case OTLP_HTTP_LOG_EXPORTER: 
            case OTLP_HTTP_METRIC_EXPORTER: {
                return "http";
            }
            case OTLP_HTTP_JSON_SPAN_EXPORTER: 
            case ZIPKIN_HTTP_JSON_SPAN_EXPORTER: 
            case OTLP_HTTP_JSON_LOG_EXPORTER: 
            case OTLP_HTTP_JSON_METRIC_EXPORTER: {
                return "http-json";
            }
            case OTLP_GRPC_PROFILES_EXPORTER: {
                throw new IllegalArgumentException("Profiles are not supported");
            }
        }
        throw new IllegalArgumentException("Not a supported exporter type: " + (Object)((Object)exporterType));
    }

    private void addSeen(long value) {
        this.seen().add(value, this.seenAttrs);
    }

    private void addSuccess(long value) {
        this.exported().add(value, this.successAttrs);
    }

    private void addFailed(long value) {
        this.exported().add(value, this.failedAttrs);
    }

    private LongCounter seen() {
        LongCounter seen = this.seen;
        if (seen == null || SemConvExporterMetrics.isNoop(seen)) {
            this.seen = seen = this.meter().counterBuilder(this.exporterName + ".exporter.seen").build();
        }
        return seen;
    }

    private LongCounter exported() {
        LongCounter exported = this.exported;
        if (exported == null || SemConvExporterMetrics.isNoop(exported)) {
            this.exported = exported = this.meter().counterBuilder(this.exporterName + ".exporter.exported").build();
        }
        return exported;
    }

    private Meter meter() {
        MeterProvider meterProvider = this.meterProviderSupplier.get();
        if (meterProvider == null) {
            meterProvider = MeterProvider.noop();
        }
        return meterProvider.get("io.opentelemetry.exporters." + this.exporterName + "-" + this.transportName);
    }

    @Override
    public ExporterMetrics.Recording startRecordingExport(int itemCount) {
        return new Recording(itemCount);
    }

    private class Recording
    extends ExporterMetrics.Recording {
        private final int itemCount;

        private Recording(int itemCount) {
            this.itemCount = itemCount;
            LegacyExporterMetrics.this.addSeen(itemCount);
        }

        @Override
        protected void doFinish(@Nullable String errorType, Attributes requestAttributes) {
            if (errorType != null) {
                LegacyExporterMetrics.this.addFailed(this.itemCount);
            } else {
                LegacyExporterMetrics.this.addSuccess(this.itemCount);
            }
        }
    }
}

