/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.jmxmetrics;

import io.opentelemetry.contrib.jmxmetrics.ClientCallbackHandler;
import io.opentelemetry.contrib.jmxmetrics.JmxConfig;
import io.opentelemetry.contrib.jmxmetrics.JmxConnectorHelper;
import java.io.IOException;
import java.net.MalformedURLException;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXServiceURL;

public class JmxClient {
    private static final Logger logger = Logger.getLogger(JmxClient.class.getName());
    private final JMXServiceURL url;
    private final String username;
    private final String password;
    private final String realm;
    private final String remoteProfile;
    private final boolean registrySsl;
    @Nullable
    private JMXConnector jmxConn;

    JmxClient(JmxConfig config) throws MalformedURLException {
        this.url = new JMXServiceURL(config.serviceUrl);
        this.username = config.username;
        this.password = config.password;
        this.realm = config.realm;
        this.remoteProfile = config.remoteProfile;
        this.registrySsl = config.registrySsl;
    }

    public MBeanServerConnection getConnection() {
        if (this.jmxConn != null) {
            try {
                return this.jmxConn.getMBeanServerConnection();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            HashMap<String, Object> env = new HashMap<String, Object>();
            if (!JmxConfig.isBlank(this.username)) {
                env.put("jmx.remote.credentials", new String[]{this.username, this.password});
            }
            try {
                Class<?> klass = Class.forName("com.sun.security.sasl.Provider");
                Provider provider = (Provider)klass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                Security.addProvider(provider);
                env.put("jmx.remote.profile", this.remoteProfile);
                env.put("jmx.remote.sasl.callback.handler", new ClientCallbackHandler(this.username, this.password, this.realm));
            }
            catch (ReflectiveOperationException e) {
                logger.warning("SASL unsupported in current environment: " + e.getMessage());
            }
            this.jmxConn = JmxConnectorHelper.connect(this.url, env, this.registrySsl);
            return this.jmxConn.getMBeanServerConnection();
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Could not connect to remote JMX server: ", e);
            return null;
        }
    }

    public List<ObjectName> query(ObjectName objectName) {
        MBeanServerConnection mbsc = this.getConnection();
        if (mbsc == null) {
            return Collections.emptyList();
        }
        try {
            ArrayList<ObjectName> objectNames = new ArrayList<ObjectName>(mbsc.queryNames(objectName, null));
            Collections.sort(objectNames);
            return objectNames;
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Could not query remote JMX server: ", e);
            return Collections.emptyList();
        }
    }
}

