/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.remote.opt.util;

import com.sun.jmx.remote.opt.util.ClassLogger;
import com.sun.jmx.remote.opt.util.JobExecutor;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;

public class ThreadService {
    private int min;
    private int max;
    private boolean simple;
    private int total = 0;
    private int idle = 0;
    private boolean terminated = false;
    private ArrayList jobList = new ArrayList();
    private ArrayList threadList = new ArrayList();
    private static final ThreadService shared = new ThreadService(0, Integer.MAX_VALUE);
    private int defaultPriority;
    private ClassLoader defaultLoader;
    private int[] lock = new int[0];
    private static final int LEAVING_WAITING_TIME = 1000;
    private static final ClassLogger logger = new ClassLogger("com.sun.jmx.remote.opt.util", "ThreadService");

    public ThreadService(int min, int max) {
        this(min, max, true);
    }

    public ThreadService(int min, int max, boolean simple) {
        if (min < 0) {
            throw new IllegalArgumentException("Negative minimal thread number.");
        }
        if (max < min) {
            throw new IllegalArgumentException("Maximum number less than minimal number.");
        }
        this.min = min;
        this.max = max;
        this.simple = simple;
        this.defaultPriority = Thread.currentThread().getPriority();
        this.defaultLoader = this.getContextClassLoader();
        if (min > 0) {
            JobExecutor.handoff(new ThreadServiceJob());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handoff(Runnable job) {
        this.isTerminated();
        if (job == null) {
            throw new IllegalArgumentException("Null job.");
        }
        int[] nArray = this.lock;
        synchronized (this.lock) {
            this.jobList.add(job);
            if (this.jobList.size() <= this.idle) {
                this.lock.notify();
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            if (this.total < this.min || this.total == 0) {
                ++this.total;
                JobExecutor.handoff(new ThreadServiceJob());
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            if (this.total == this.max) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            Thread.yield();
            nArray = this.lock;
            synchronized (this.lock) {
                if (this.jobList.size() > this.idle && this.total < this.max) {
                    ++this.total;
                    JobExecutor.handoff(new ThreadServiceJob());
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() {
        int[] nArray = this.lock;
        synchronized (this.lock) {
            if (this.terminated) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            this.terminated = true;
            this.jobList.clear();
            this.lock.notifyAll();
            Thread ct = Thread.currentThread();
            while (this.threadList.size() > 0) {
                Thread rt = (Thread)this.threadList.remove(0);
                if (ct == rt) continue;
                rt.interrupt();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    protected void finalize() {
        this.terminate();
    }

    private void isTerminated() throws IllegalStateException {
        if (this.terminated) {
            throw new IllegalStateException("The Thread Service has been terminated.");
        }
    }

    private ClassLoader getContextClassLoader() {
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    private void setContextClassLoader(final Thread currentThread, final ClassLoader classloader) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                currentThread.setContextClassLoader(classloader);
                return null;
            }
        });
    }

    private class ThreadServiceJob
    implements Runnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            Thread currentThread = Thread.currentThread();
            int[] nArray = ThreadService.this.lock;
            synchronized (nArray) {
                ThreadService.this.threadList.add(currentThread);
            }
            currentThread.setPriority(ThreadService.this.defaultPriority);
            currentThread.interrupted();
            ThreadService.this.setContextClassLoader(currentThread, ThreadService.this.defaultLoader);
            Runnable job = null;
            while (!ThreadService.this.terminated) {
                int[] nArray2 = ThreadService.this.lock;
                synchronized (nArray2) {
                    block24: {
                        block26: {
                            long startTime;
                            long remainingTime;
                            block22: {
                                block25: {
                                    if (ThreadService.this.jobList.size() != 0) break block25;
                                    if (ThreadService.this.total > ThreadService.this.min) {
                                        if (ThreadService.this.idle == 0) {
                                            ThreadService.this.idle++;
                                            remainingTime = 1000L;
                                            startTime = System.currentTimeMillis();
                                            break block22;
                                        } else {
                                            ThreadService.this.total--;
                                            ThreadService.this.threadList.remove(currentThread);
                                            break;
                                        }
                                    }
                                    ThreadService.this.idle++;
                                    break block26;
                                }
                                job = (Runnable)ThreadService.this.jobList.remove(0);
                                break block24;
                            }
                            while (ThreadService.this.jobList.size() <= 0 && remainingTime > 0L) {
                                block23: {
                                    try {
                                        ThreadService.this.lock.wait(remainingTime);
                                    }
                                    catch (InterruptedException e) {
                                        currentThread.interrupted();
                                        if (!ThreadService.this.terminated) break block23;
                                        return;
                                    }
                                }
                                remainingTime = 1000L - (System.currentTimeMillis() - startTime);
                            }
                            ThreadService.this.idle--;
                            if (ThreadService.this.jobList.size() > 0) {
                                job = (Runnable)ThreadService.this.jobList.remove(0);
                                break block24;
                            } else {
                                ThreadService.this.total--;
                                ThreadService.this.threadList.remove(currentThread);
                                break;
                            }
                        }
                        while (!ThreadService.this.terminated && ThreadService.this.jobList.size() <= 0) {
                            try {
                                ThreadService.this.lock.wait();
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        ThreadService.this.idle--;
                        if (ThreadService.this.terminated) {
                            break;
                        }
                        job = (Runnable)ThreadService.this.jobList.remove(0);
                    }
                    if (ThreadService.this.terminated) break;
                }
                try {
                    try {
                        job.run();
                        job = null;
                    }
                    catch (Exception e) {
                        if (logger.warningOn()) {
                            logger.warning("run", "Got an unexpected exception.", e);
                        }
                        job = null;
                    }
                }
                catch (Throwable throwable) {
                    job = null;
                    throw throwable;
                }
                currentThread.interrupted();
                if (ThreadService.this.simple) continue;
                currentThread.setPriority(ThreadService.this.defaultPriority);
                ThreadService.this.setContextClassLoader(currentThread, ThreadService.this.defaultLoader);
            }
            currentThread.interrupted();
        }
    }
}

