/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.runtime.memoize;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.StampedLock;
import javax.annotation.concurrent.ThreadSafe;
import org.codehaus.groovy.runtime.memoize.CommonCache;
import org.codehaus.groovy.runtime.memoize.EvictableCache;
import org.codehaus.groovy.runtime.memoize.MemoizeCache;
import org.codehaus.groovy.runtime.memoize.ValueConvertable;

@ThreadSafe
public class StampedCommonCache<K, V>
implements EvictableCache<K, V>,
ValueConvertable<V, Object>,
Serializable {
    private static final long serialVersionUID = 6760742552334555146L;
    private final StampedLock sl = new StampedLock();
    private final CommonCache<K, V> commonCache;

    public StampedCommonCache() {
        this.commonCache = new CommonCache();
    }

    public StampedCommonCache(int initialCapacity, int maxSize, EvictableCache.EvictionStrategy evictionStrategy) {
        this.commonCache = new CommonCache(initialCapacity, maxSize, evictionStrategy);
    }

    public StampedCommonCache(int initialCapacity, int maxSize) {
        this.commonCache = new CommonCache(initialCapacity, maxSize);
    }

    public StampedCommonCache(int maxSize) {
        this.commonCache = new CommonCache(maxSize);
    }

    public StampedCommonCache(Map<K, V> map) {
        this.commonCache = new CommonCache<K, V>(map);
    }

    @Override
    public V get(Object key) {
        return (V)this.doWithReadLock(c -> c.get(key));
    }

    @Override
    public V put(K key, V value) {
        return (V)this.doWithWriteLock(c -> c.put(key, value));
    }

    @Override
    public V getAndPut(K key, MemoizeCache.ValueProvider<? super K, ? extends V> valueProvider) {
        return this.getAndPut(key, valueProvider, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V getAndPut(K key, MemoizeCache.ValueProvider<? super K, ? extends V> valueProvider, boolean shouldCache) {
        long optimisticReadStamp = this.sl.tryOptimisticRead();
        V value = this.commonCache.get((Object)key);
        if (this.sl.validate(optimisticReadStamp) && null != this.convertValue(value)) {
            return value;
        }
        long stamp = this.sl.readLock();
        try {
            if (!this.sl.validate(optimisticReadStamp) && null != this.convertValue(value = this.commonCache.get((Object)key))) {
                V v = value;
                return v;
            }
            long ws = this.sl.tryConvertToWriteLock(stamp);
            if (0L == ws) {
                this.sl.unlockRead(stamp);
                stamp = this.sl.writeLock();
                value = this.commonCache.get((Object)key);
                if (null != this.convertValue(value)) {
                    V v = value;
                    return v;
                }
            } else {
                stamp = ws;
            }
            value = this.compute(key, valueProvider, shouldCache);
        }
        finally {
            this.sl.unlock(stamp);
        }
        return value;
    }

    private V compute(K key, MemoizeCache.ValueProvider<? super K, ? extends V> valueProvider, boolean shouldCache) {
        Object value;
        Object v = value = null == valueProvider ? null : (Object)valueProvider.provide((K)key);
        if (shouldCache && null != this.convertValue((V)value)) {
            this.commonCache.put(key, value);
        }
        return value;
    }

    @Override
    public Collection<V> values() {
        return this.doWithReadLock(c -> c.values());
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.doWithReadLock(c -> c.entrySet());
    }

    @Override
    public Set<K> keys() {
        return this.doWithReadLock(c -> c.keys());
    }

    @Override
    public boolean containsKey(Object key) {
        return this.doWithReadLock(c -> c.containsKey(key));
    }

    @Override
    public boolean containsValue(Object value) {
        return this.doWithReadLock(c -> c.containsValue(value));
    }

    @Override
    public int size() {
        return this.doWithReadLock(c -> c.size());
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public V remove(Object key) {
        return (V)this.doWithWriteLock(c -> c.remove(key));
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.doWithWriteLock(c -> {
            c.putAll(m);
            return null;
        });
    }

    @Override
    public Set<K> keySet() {
        return this.keys();
    }

    @Override
    public Map<K, V> clearAll() {
        return this.doWithWriteLock(c -> c.clearAll());
    }

    @Override
    public void cleanUpNullReferences() {
        this.doWithWriteLock(c -> {
            c.cleanUpNullReferences();
            return null;
        });
    }

    @Override
    public Object convertValue(V value) {
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <R> R doWithWriteLock(EvictableCache.Action<K, V, R> action) {
        long stamp = this.sl.writeLock();
        try {
            R r = action.doWith(this.commonCache);
            return r;
        }
        finally {
            this.sl.unlockWrite(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <R> R doWithReadLock(EvictableCache.Action<K, V, R> action) {
        long stamp = this.sl.tryOptimisticRead();
        R result2 = action.doWith(this.commonCache);
        if (!this.sl.validate(stamp)) {
            stamp = this.sl.readLock();
            try {
                result2 = action.doWith(this.commonCache);
            }
            finally {
                this.sl.unlockRead(stamp);
            }
        }
        return result2;
    }
}

