/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast;

import java.lang.reflect.Modifier;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.Parameter;

public class AstToTextHelper {
    public static String getClassText(ClassNode node) {
        if (node == null) {
            return "<unknown>";
        }
        if (node.getName() == null) {
            return "<unknown>";
        }
        return node.getName();
    }

    public static String getParameterText(Parameter node) {
        if (node == null) {
            return "<unknown>";
        }
        String name = node.getName() == null ? "<unknown>" : node.getName();
        String type = AstToTextHelper.getClassText(node.getType());
        if (node.getInitialExpression() != null) {
            return type + " " + name + " = " + node.getInitialExpression().getText();
        }
        return type + " " + name;
    }

    public static String getParametersText(Parameter[] parameters) {
        if (parameters == null) {
            return "";
        }
        if (parameters.length == 0) {
            return "";
        }
        StringBuilder result2 = new StringBuilder();
        int max = parameters.length;
        for (int x = 0; x < max; ++x) {
            result2.append(AstToTextHelper.getParameterText(parameters[x]));
            if (x >= max - 1) continue;
            result2.append(", ");
        }
        return result2.toString();
    }

    public static String getThrowsClauseText(ClassNode[] exceptions) {
        if (exceptions == null) {
            return "";
        }
        if (exceptions.length == 0) {
            return "";
        }
        StringBuilder result2 = new StringBuilder("throws ");
        int max = exceptions.length;
        for (int x = 0; x < max; ++x) {
            result2.append(AstToTextHelper.getClassText(exceptions[x]));
            if (x >= max - 1) continue;
            result2.append(", ");
        }
        return result2.toString();
    }

    public static String getModifiersText(int modifiers) {
        StringBuilder result2 = new StringBuilder();
        if (Modifier.isPrivate(modifiers)) {
            result2.append("private ");
        }
        if (Modifier.isProtected(modifiers)) {
            result2.append("protected ");
        }
        if (Modifier.isPublic(modifiers)) {
            result2.append("public ");
        }
        if (Modifier.isStatic(modifiers)) {
            result2.append("static ");
        }
        if (Modifier.isAbstract(modifiers)) {
            result2.append("abstract ");
        }
        if (Modifier.isFinal(modifiers)) {
            result2.append("final ");
        }
        if (Modifier.isInterface(modifiers)) {
            result2.append("interface ");
        }
        if (Modifier.isNative(modifiers)) {
            result2.append("native ");
        }
        if (Modifier.isSynchronized(modifiers)) {
            result2.append("synchronized ");
        }
        if (Modifier.isTransient(modifiers)) {
            result2.append("transient ");
        }
        if (Modifier.isVolatile(modifiers)) {
            result2.append("volatile ");
        }
        return result2.toString().trim();
    }
}

