/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.testing.assertj;

import io.opentelemetry.sdk.metrics.data.DoubleExemplarData;
import io.opentelemetry.sdk.metrics.data.ExponentialHistogramPointData;
import io.opentelemetry.sdk.testing.assertj.AbstractPointAssert;
import io.opentelemetry.sdk.testing.assertj.AssertUtil;
import io.opentelemetry.sdk.testing.assertj.DoubleExemplarAssert;
import io.opentelemetry.sdk.testing.assertj.ExponentialHistogramBucketsAssert;
import java.util.Arrays;
import java.util.function.Consumer;
import org.assertj.core.api.AbstractDoubleAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;

public final class ExponentialHistogramPointAssert
extends AbstractPointAssert<ExponentialHistogramPointAssert, ExponentialHistogramPointData> {
    ExponentialHistogramPointAssert(ExponentialHistogramPointData actual) {
        super(actual, ExponentialHistogramPointAssert.class);
    }

    public ExponentialHistogramPointAssert hasSum(double expected) {
        this.isNotNull();
        ((AbstractDoubleAssert)Assertions.assertThat((double)((ExponentialHistogramPointData)this.actual).getSum()).as("sum", new Object[0])).isEqualTo(expected);
        return this;
    }

    public ExponentialHistogramPointAssert hasMin(double expected) {
        this.isNotNull();
        ((AbstractDoubleAssert)Assertions.assertThat((double)((ExponentialHistogramPointData)this.actual).getMin()).as("min", new Object[0])).isEqualTo(expected);
        return this;
    }

    public ExponentialHistogramPointAssert hasMax(double expected) {
        this.isNotNull();
        ((AbstractDoubleAssert)Assertions.assertThat((double)((ExponentialHistogramPointData)this.actual).getMax()).as("max", new Object[0])).isEqualTo(expected);
        return this;
    }

    public ExponentialHistogramPointAssert hasCount(long expected) {
        this.isNotNull();
        ((AbstractLongAssert)Assertions.assertThat((long)((ExponentialHistogramPointData)this.actual).getCount()).as("count", new Object[0])).isEqualTo(expected);
        return this;
    }

    public ExponentialHistogramPointAssert hasScale(int expected) {
        this.isNotNull();
        ((AbstractIntegerAssert)Assertions.assertThat((int)((ExponentialHistogramPointData)this.actual).getScale()).as("scale", new Object[0])).isEqualTo(expected);
        return this;
    }

    public ExponentialHistogramPointAssert hasZeroCount(long expected) {
        this.isNotNull();
        ((AbstractLongAssert)Assertions.assertThat((long)((ExponentialHistogramPointData)this.actual).getZeroCount()).as("zeroCount", new Object[0])).isEqualTo(expected);
        return this;
    }

    public ExponentialHistogramPointAssert hasPositiveBucketsSatisfying(Consumer<ExponentialHistogramBucketsAssert> assertion) {
        this.isNotNull();
        assertion.accept(new ExponentialHistogramBucketsAssert(((ExponentialHistogramPointData)this.actual).getPositiveBuckets()));
        return this;
    }

    public ExponentialHistogramPointAssert hasNegativeBucketsSatisfying(Consumer<ExponentialHistogramBucketsAssert> assertion) {
        this.isNotNull();
        assertion.accept(new ExponentialHistogramBucketsAssert(((ExponentialHistogramPointData)this.actual).getNegativeBuckets()));
        return this;
    }

    public ExponentialHistogramPointAssert hasExemplars(DoubleExemplarData ... exemplars) {
        this.isNotNull();
        ((ListAssert)Assertions.assertThat(((ExponentialHistogramPointData)this.actual).getExemplars()).as("exemplars", new Object[0])).containsExactlyInAnyOrder((Object[])exemplars);
        return (ExponentialHistogramPointAssert)this.myself;
    }

    @SafeVarargs
    public final ExponentialHistogramPointAssert hasExemplarsSatisfying(Consumer<DoubleExemplarAssert> ... assertions) {
        return this.hasExemplarsSatisfying(Arrays.asList(assertions));
    }

    public ExponentialHistogramPointAssert hasExemplarsSatisfying(Iterable<? extends Consumer<DoubleExemplarAssert>> assertions) {
        this.isNotNull();
        Assertions.assertThat(((ExponentialHistogramPointData)this.actual).getExemplars()).satisfiesExactlyInAnyOrder((Consumer[])AssertUtil.toConsumers(assertions, DoubleExemplarAssert::new));
        return (ExponentialHistogramPointAssert)this.myself;
    }
}

