/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.autoconfigure.internal;

import io.opentelemetry.common.ComponentLoader;
import io.opentelemetry.sdk.autoconfigure.internal.NamedSpiManager;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.autoconfigure.spi.Ordered;
import io.opentelemetry.sdk.autoconfigure.spi.internal.AutoConfigureListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;

public final class SpiHelper {
    private final ComponentLoader componentLoader;
    private final Set<AutoConfigureListener> listeners = Collections.newSetFromMap(new IdentityHashMap());

    private SpiHelper(ComponentLoader componentLoader) {
        this.componentLoader = componentLoader;
    }

    public static SpiHelper create(ClassLoader classLoader) {
        return new SpiHelper(ComponentLoader.forClassLoader(classLoader));
    }

    public static SpiHelper create(ComponentLoader componentLoader) {
        return new SpiHelper(componentLoader);
    }

    public ComponentLoader getComponentLoader() {
        return this.componentLoader;
    }

    public <T, S> NamedSpiManager<T> loadConfigurable(Class<S> spiClass, Function<S, String> getName, BiFunction<S, ConfigProperties, T> getConfigurable, ConfigProperties config) {
        HashMap nameToProvider = new HashMap();
        for (Object provider : this.load(spiClass)) {
            String name = getName.apply(provider);
            nameToProvider.put(name, () -> {
                Object result2 = getConfigurable.apply(provider, config);
                this.maybeAddListener(result2);
                return result2;
            });
        }
        return NamedSpiManager.create(nameToProvider);
    }

    public <T extends Ordered> List<T> loadOrdered(Class<T> spiClass) {
        List<T> result2 = this.load(spiClass);
        result2.sort(Comparator.comparing(Ordered::order));
        return result2;
    }

    public <T> List<T> load(Class<T> spiClass) {
        ArrayList<T> result2 = new ArrayList<T>();
        for (T service : this.componentLoader.load(spiClass)) {
            this.maybeAddListener(service);
            result2.add(service);
        }
        return result2;
    }

    private void maybeAddListener(Object object) {
        if (object instanceof AutoConfigureListener) {
            this.listeners.add((AutoConfigureListener)object);
        }
    }

    public Set<AutoConfigureListener> getListeners() {
        return Collections.unmodifiableSet(this.listeners);
    }
}

