/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.autoconfigure;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.common.ComponentLoader;
import io.opentelemetry.sdk.autoconfigure.EnvironmentResourceProvider;
import io.opentelemetry.sdk.autoconfigure.internal.SpiHelper;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigurationException;
import io.opentelemetry.sdk.autoconfigure.spi.ResourceProvider;
import io.opentelemetry.sdk.autoconfigure.spi.internal.ConditionalResourceProvider;
import io.opentelemetry.sdk.autoconfigure.spi.internal.DefaultConfigProperties;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.resources.ResourceBuilder;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ResourceConfiguration {
    private static final Logger logger = Logger.getLogger(ResourceConfiguration.class.getName());
    private static final AttributeKey<String> SERVICE_NAME = AttributeKey.stringKey("service.name");
    static final String ATTRIBUTE_PROPERTY = "otel.resource.attributes";
    static final String SERVICE_NAME_PROPERTY = "otel.service.name";
    static final String DISABLED_ATTRIBUTE_KEYS = "otel.resource.disabled.keys";
    static final String ENABLED_RESOURCE_PROVIDERS = "otel.java.enabled.resource.providers";
    static final String DISABLED_RESOURCE_PROVIDERS = "otel.java.disabled.resource.providers";
    private static final String OLD_ENVIRONMENT_DETECTOR_FQCN = "io.opentelemetry.sdk.autoconfigure.internal.EnvironmentResourceProvider";
    private static final String NEW_ENVIRONMENT_DETECT_FQCN = EnvironmentResourceProvider.class.getName();

    public static Resource createEnvironmentResource() {
        return ResourceConfiguration.createEnvironmentResource(DefaultConfigProperties.create(Collections.emptyMap(), ComponentLoader.forClassLoader(ResourceConfiguration.class.getClassLoader())));
    }

    public static Resource createEnvironmentResource(ConfigProperties config) {
        AttributesBuilder resourceAttributes = Attributes.builder();
        try {
            for (Map.Entry<String, String> entry : config.getMap(ATTRIBUTE_PROPERTY).entrySet()) {
                resourceAttributes.put(entry.getKey(), URLDecoder.decode(entry.getValue(), StandardCharsets.UTF_8.displayName()));
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new ConfigurationException("Unable to decode resource attributes.", e);
        }
        String serviceName = config.getString(SERVICE_NAME_PROPERTY);
        if (serviceName != null) {
            resourceAttributes.put(SERVICE_NAME, serviceName);
        }
        return Resource.create(resourceAttributes.build());
    }

    static Resource configureResource(ConfigProperties config, SpiHelper spiHelper, BiFunction<? super Resource, ConfigProperties, ? extends Resource> resourceCustomizer) {
        HashSet<String> disabledProviders;
        Resource result2 = Resource.getDefault();
        HashSet<String> enabledProviders = new HashSet<String>(config.getList(ENABLED_RESOURCE_PROVIDERS));
        if (enabledProviders.remove(OLD_ENVIRONMENT_DETECTOR_FQCN)) {
            logger.log(Level.WARNING, "Found reference to io.opentelemetry.sdk.autoconfigure.internal.EnvironmentResourceProvider in otel.java.enabled.resource.providers. Please update to " + NEW_ENVIRONMENT_DETECT_FQCN + ". Support for the old provider name will be removed after 1.49.0.");
            enabledProviders.add(NEW_ENVIRONMENT_DETECT_FQCN);
        }
        if ((disabledProviders = new HashSet<String>(config.getList(DISABLED_RESOURCE_PROVIDERS))).remove(OLD_ENVIRONMENT_DETECTOR_FQCN)) {
            logger.log(Level.WARNING, "Found reference to io.opentelemetry.sdk.autoconfigure.internal.EnvironmentResourceProvider in otel.java.disabled.resource.providers. Please update to " + NEW_ENVIRONMENT_DETECT_FQCN + ". Support for the old provider name will be removed after 1.49.0.");
            disabledProviders.add(NEW_ENVIRONMENT_DETECT_FQCN);
        }
        for (ResourceProvider resourceProvider : spiHelper.loadOrdered(ResourceProvider.class)) {
            if (!enabledProviders.isEmpty() && !enabledProviders.contains(resourceProvider.getClass().getName()) || disabledProviders.contains(resourceProvider.getClass().getName()) || resourceProvider instanceof ConditionalResourceProvider && !((ConditionalResourceProvider)resourceProvider).shouldApply(config, result2)) continue;
            result2 = result2.merge(resourceProvider.createResource(config));
        }
        result2 = ResourceConfiguration.filterAttributes(result2, config);
        return resourceCustomizer.apply(result2, config);
    }

    static Resource filterAttributes(Resource resource, ConfigProperties configProperties) {
        List<String> disabledAttibuteKeys = configProperties.getList(DISABLED_ATTRIBUTE_KEYS);
        HashSet<String> disabledKeys = new HashSet<String>(disabledAttibuteKeys);
        ResourceBuilder builder = resource.toBuilder().removeIf(attributeKey -> disabledKeys.contains(attributeKey.getKey()));
        if (resource.getSchemaUrl() != null) {
            builder.setSchemaUrl(resource.getSchemaUrl());
        }
        return builder.build();
    }

    private ResourceConfiguration() {
    }
}

