/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.remote.opt.security;

import com.sun.jmx.remote.generic.CheckProfiles;
import com.sun.jmx.remote.generic.ProfileServer;
import com.sun.jmx.remote.generic.ProfileServerFactory;
import com.sun.jmx.remote.generic.ServerAdmin;
import com.sun.jmx.remote.opt.security.AdminClient;
import com.sun.jmx.remote.opt.util.ClassLogger;
import com.sun.jmx.remote.socket.SocketConnectionIf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import javax.management.remote.JMXAuthenticator;
import javax.management.remote.generic.MessageConnection;
import javax.management.remote.message.HandshakeBeginMessage;
import javax.management.remote.message.HandshakeEndMessage;
import javax.management.remote.message.HandshakeErrorMessage;
import javax.management.remote.message.Message;
import javax.management.remote.message.ProfileMessage;
import javax.management.remote.message.VersionMessage;
import javax.security.auth.Subject;

public class AdminServer
implements ServerAdmin {
    private Map env = null;
    private Map subjectsTable = new WeakHashMap();
    private Map profilesTable = new WeakHashMap();
    private static final ClassLogger logger = new ClassLogger("javax.management.remote.misc", "AdminServer");

    public AdminServer(Map env) {
        this.env = env != null ? env : Collections.EMPTY_MAP;
    }

    @Override
    public MessageConnection connectionOpen(MessageConnection mc) throws IOException {
        boolean sendError = true;
        try {
            String connectionId;
            Object scontext;
            Subject subject;
            block22: {
                Message msg;
                subject = null;
                String serverProfiles = (String)this.env.get("jmx.remote.profiles");
                String serverVersion = "1.0";
                if (logger.traceOn()) {
                    logger.trace("connectionOpen", ">>>>> Handshake Begin <<<<<");
                    logger.trace("connectionOpen", "Server Supported Profiles [ " + serverProfiles + " ]");
                    logger.trace("connectionOpen", "Server JMXMP Version [ " + serverVersion + " ]");
                }
                HandshakeBeginMessage begin = new HandshakeBeginMessage(serverProfiles, serverVersion);
                mc.writeMessage(begin);
                while (true) {
                    if ((msg = mc.readMessage()) instanceof HandshakeErrorMessage) {
                        sendError = false;
                        HandshakeErrorMessage error = (HandshakeErrorMessage)msg;
                        AdminClient.throwExceptionOnError(error);
                        continue;
                    }
                    if (msg instanceof HandshakeEndMessage) {
                        HandshakeEndMessage cend = (HandshakeEndMessage)msg;
                        Object ccontext = cend.getContext();
                        if (logger.traceOn()) {
                            logger.trace("connectionOpen", ">>>>> Handshake End <<<<<");
                            logger.trace("connectionOpen", "Client Context Object [ " + ccontext + " ]");
                        }
                        scontext = this.env.get("jmx.remote.context");
                        if (mc instanceof SocketConnectionIf) {
                            ((SocketConnectionIf)((Object)mc)).setSubject(subject);
                        }
                        connectionId = mc.getConnectionId();
                        JMXAuthenticator authenticator = (JMXAuthenticator)this.env.get("jmx.remote.authenticator");
                        if (authenticator != null) {
                            Object[] credentials = new Object[]{connectionId, subject};
                            subject = authenticator.authenticate(credentials);
                            if (mc instanceof SocketConnectionIf) {
                                ((SocketConnectionIf)((Object)mc)).setSubject(subject);
                            }
                            connectionId = mc.getConnectionId();
                        }
                        if (logger.traceOn()) {
                            logger.trace("connectionOpen", "Server Context Object [ " + scontext + " ]");
                            logger.trace("connectionOpen", "Server Connection Id [ " + connectionId + " ]");
                        }
                        ArrayList profileNames = this.getProfilesByName(mc);
                        CheckProfiles np = (CheckProfiles)this.env.get("com.sun.jmx.remote.profile.checker");
                        if (np != null) {
                            np.checkProfiles(this.env, profileNames, ccontext, connectionId);
                        } else {
                            this.checkProfilesForEquality(serverProfiles, profileNames);
                        }
                        break block22;
                    }
                    if (msg instanceof VersionMessage) {
                        VersionMessage cjmxmp = (VersionMessage)msg;
                        String clientVersion = cjmxmp.getVersion();
                        if (clientVersion.equals(serverVersion)) {
                            VersionMessage sjmxmp = new VersionMessage(serverVersion);
                            mc.writeMessage(sjmxmp);
                            continue;
                        }
                        throw new IOException("Protocol version mismatch: Client [" + clientVersion + "] vs. Server [" + serverVersion + "]");
                    }
                    if (!(msg instanceof ProfileMessage)) break;
                    ProfileMessage pm = (ProfileMessage)msg;
                    String pn = pm.getProfileName();
                    ProfileServer p = this.getProfile(mc, pn);
                    if (p == null) {
                        p = ProfileServerFactory.createProfile(pn, this.env);
                        if (logger.traceOn()) {
                            logger.trace("connectionOpen", ">>>>> Profile " + p.getClass().getName() + " <<<<<");
                        }
                        p.initialize(mc, subject);
                        this.putProfile(mc, p);
                    }
                    p.consumeMessage(pm);
                    pm = p.produceMessage();
                    mc.writeMessage(pm);
                    if (!p.isComplete()) continue;
                    subject = p.activate();
                }
                throw new IOException("Unexpected message: " + msg.getClass().getName());
            }
            HandshakeEndMessage send = new HandshakeEndMessage(scontext, connectionId);
            mc.writeMessage(send);
            this.putSubject(mc, subject);
        }
        catch (Exception e) {
            block23: {
                if (sendError) {
                    try {
                        mc.writeMessage(new HandshakeErrorMessage(e.toString()));
                    }
                    catch (Exception hsem) {
                        if (!logger.debugOn()) break block23;
                        logger.debug("connectionOpen", "Could not send HandshakeErrorMessage to the client", hsem);
                    }
                }
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException(e.getMessage());
        }
        return mc;
    }

    @Override
    public void connectionClosed(MessageConnection mc) {
        this.removeSubject(mc);
        this.removeProfiles(mc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Subject getSubject(MessageConnection mc) {
        Map map = this.subjectsTable;
        synchronized (map) {
            return (Subject)this.subjectsTable.get(mc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putSubject(MessageConnection mc, Subject s) {
        Map map = this.subjectsTable;
        synchronized (map) {
            this.subjectsTable.put(mc, s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeSubject(MessageConnection mc) {
        Map map = this.subjectsTable;
        synchronized (map) {
            this.subjectsTable.remove(mc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProfileServer getProfile(MessageConnection mc, String pn) {
        Map map = this.profilesTable;
        synchronized (map) {
            ArrayList list = (ArrayList)this.profilesTable.get(mc);
            if (list == null) {
                return null;
            }
            for (ProfileServer p : list) {
                if (!p.getName().equals(pn)) continue;
                return p;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void putProfile(MessageConnection mc, ProfileServer p) {
        Map map = this.profilesTable;
        synchronized (map) {
            ArrayList<ProfileServer> list = (ArrayList<ProfileServer>)this.profilesTable.get(mc);
            if (list == null) {
                list = new ArrayList<ProfileServer>();
                this.profilesTable.put(mc, list);
            }
            if (!list.contains(p)) {
                list.add(p);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList getProfiles(MessageConnection mc) {
        Map map = this.profilesTable;
        synchronized (map) {
            return (ArrayList)this.profilesTable.get(mc);
        }
    }

    private ArrayList getProfilesByName(MessageConnection mc) {
        ArrayList profiles = this.getProfiles(mc);
        if (profiles == null) {
            return null;
        }
        ArrayList<String> profileNames = new ArrayList<String>(profiles.size());
        for (ProfileServer p : profiles) {
            profileNames.add(p.getName());
        }
        return profileNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void removeProfiles(MessageConnection mc) {
        Map map = this.profilesTable;
        synchronized (map) {
            ArrayList list = (ArrayList)this.profilesTable.get(mc);
            if (list != null) {
                for (ProfileServer p : list) {
                    try {
                        p.terminate();
                    }
                    catch (Exception e) {
                        if (!logger.debugOn()) continue;
                        logger.debug("removeProfiles", "Got an exception to terminate a ProfileServer: " + p.getName(), e);
                    }
                }
                list.clear();
            }
            this.profilesTable.remove(mc);
        }
    }

    private void checkProfilesForEquality(String serverProfiles, List clientProfilesList) throws IOException {
        boolean clientFlag;
        boolean serverFlag = serverProfiles == null || serverProfiles.equals("");
        boolean bl = clientFlag = clientProfilesList == null || clientProfilesList.isEmpty();
        if (serverFlag && clientFlag) {
            return;
        }
        if (serverFlag) {
            throw new IOException("The server does not support any profile but the client requires one");
        }
        if (clientFlag) {
            throw new IOException("The client does not require any profile but the server mandates one");
        }
        StringTokenizer sst = new StringTokenizer(serverProfiles, " ");
        ArrayList<String> serverProfilesList = new ArrayList<String>(sst.countTokens());
        while (sst.hasMoreTokens()) {
            String serverToken = sst.nextToken();
            serverProfilesList.add(serverToken);
        }
        if (serverProfilesList.size() != clientProfilesList.size()) {
            throw new IOException("The client negotiated profiles do not match the server required profiles.");
        }
        if (!clientProfilesList.containsAll(serverProfilesList)) {
            throw new IOException("The client negotiated profiles " + clientProfilesList + " do not match the server required profiles " + serverProfilesList + ".");
        }
    }
}

