/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.antlr.treewalker;

import groovyjarjarantlr.collections.AST;
import java.io.PrintStream;
import java.util.Stack;
import org.codehaus.groovy.antlr.GroovySourceAST;
import org.codehaus.groovy.antlr.treewalker.VisitorAdapter;

public class SourcePrinter
extends VisitorAdapter {
    private final String[] tokenNames;
    private int tabLevel;
    private int lastLinePrinted;
    private final boolean newLines;
    protected final PrintStream out;
    private String className;
    private final Stack stack;
    private int stringConstructorCounter;

    public SourcePrinter(PrintStream out, String[] tokenNames) {
        this(out, tokenNames, true);
    }

    public SourcePrinter(PrintStream out, String[] tokenNames, boolean newLines) {
        this.tokenNames = tokenNames;
        this.tabLevel = 0;
        this.lastLinePrinted = 0;
        this.out = out;
        this.newLines = newLines;
        this.stack = new Stack();
    }

    @Override
    public void visitAbstract(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "abstract ", null, null);
    }

    @Override
    public void visitAnnotation(GroovySourceAST t2, int visit) {
        if (visit == 1) {
            this.print(t2, visit, "@");
        }
        if (visit == 2) {
            this.print(t2, visit, "(");
        }
        if (visit == 3) {
            this.print(t2, visit, ", ");
        }
        if (visit == 4) {
            if (t2.getNumberOfChildren() > 1) {
                this.print(t2, visit, ") ");
            } else {
                this.print(t2, visit, " ");
            }
        }
    }

    @Override
    public void visitAnnotations(GroovySourceAST t2, int visit) {
    }

    @Override
    public void visitAnnotationDef(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "@interface ", null, null);
    }

    @Override
    public void visitAnnotationFieldDef(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "() ", "default ", null);
    }

    @Override
    public void visitAnnotationMemberValuePair(GroovySourceAST t2, int visit) {
        this.print(t2, visit, " = ", null, null);
    }

    @Override
    public void visitArrayDeclarator(GroovySourceAST t2, int visit) {
        if (this.getParentNode().getType() == 12 || this.getParentNode().getType() == 23) {
            this.print(t2, visit, null, null, "[]");
        } else {
            this.print(t2, visit, "[", null, "]");
        }
    }

    @Override
    public void visitAssign(GroovySourceAST t2, int visit) {
        this.print(t2, visit, " = ", null, null);
    }

    @Override
    public void visitBand(GroovySourceAST t2, int visit) {
        this.print(t2, visit, " & ", null, null);
    }

    @Override
    public void visitBandAssign(GroovySourceAST t2, int visit) {
        this.print(t2, visit, " &= ", null, null);
    }

    @Override
    public void visitBnot(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "~", null, null);
    }

    @Override
    public void visitBor(GroovySourceAST t2, int visit) {
        this.print(t2, visit, " | ", null, null);
    }

    @Override
    public void visitBorAssign(GroovySourceAST t2, int visit) {
        this.print(t2, visit, " |= ", null, null);
    }

    @Override
    public void visitBsr(GroovySourceAST t2, int visit) {
        this.print(t2, visit, " >>> ", null, null);
    }

    @Override
    public void visitBsrAssign(GroovySourceAST t2, int visit) {
        this.print(t2, visit, " >>>= ", null, null);
    }

    @Override
    public void visitBxor(GroovySourceAST t2, int visit) {
        this.print(t2, visit, " ^ ", null, null);
    }

    @Override
    public void visitBxorAssign(GroovySourceAST t2, int visit) {
        this.print(t2, visit, " ^= ", null, null);
    }

    @Override
    public void visitCaseGroup(GroovySourceAST t2, int visit) {
        if (visit == 1) {
            ++this.tabLevel;
        }
        if (visit == 4) {
            --this.tabLevel;
        }
    }

    @Override
    public void visitClassDef(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "class ", null, null);
        if (visit == 1) {
            this.className = t2.childOfType(87).getText();
        }
    }

    @Override
    public void visitClosedBlock(GroovySourceAST t2, int visit) {
        this.printUpdatingTabLevel(t2, visit, "{", "-> ", "}");
    }

    @Override
    public void visitClosureList(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "(", "; ", ")");
    }

    @Override
    public void visitCompareTo(GroovySourceAST t2, int visit) {
        this.print(t2, visit, " <=> ", null, null);
    }

    @Override
    public void visitCtorCall(GroovySourceAST t2, int visit) {
        this.printUpdatingTabLevel(t2, visit, "this(", " ", ")");
    }

    @Override
    public void visitCtorIdent(GroovySourceAST t2, int visit) {
        this.print(t2, visit, this.className, null, null);
    }

    @Override
    public void visitDec(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "--", null, null);
    }

    @Override
    public void visitDiv(GroovySourceAST t2, int visit) {
        this.print(t2, visit, " / ", null, null);
    }

    @Override
    public void visitDivAssign(GroovySourceAST t2, int visit) {
        this.print(t2, visit, " /= ", null, null);
    }

    @Override
    public void visitDot(GroovySourceAST t2, int visit) {
        this.print(t2, visit, ".", null, null);
    }

    @Override
    public void visitDynamicMember(GroovySourceAST t2, int visit) {
        if (t2.childOfType(48) == null) {
            this.printUpdatingTabLevel(t2, visit, "(", null, ")");
        }
    }

    @Override
    public void visitElist(GroovySourceAST t2, int visit) {
        if (this.getParentNode().getType() == 62) {
            this.print(t2, visit, "(", ", ", ")");
        } else {
            this.print(t2, visit, null, ", ", null);
        }
    }

    @Override
    public void visitEnumConstantDef(GroovySourceAST t2, int visit) {
        GroovySourceAST sibling = (GroovySourceAST)t2.getNextSibling();
        if (sibling != null && sibling.getType() == 62) {
            this.print(t2, visit, null, null, ", ");
        }
    }

    @Override
    public void visitEnumDef(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "enum ", null, null);
    }

    @Override
    public void visitEqual(GroovySourceAST t2, int visit) {
        this.print(t2, visit, " == ", null, null);
    }

    @Override
    public void visitExpr(GroovySourceAST t2, int visit) {
    }

    @Override
    public void visitExtendsClause(GroovySourceAST t2, int visit) {
        if (visit == 1 && t2.getNumberOfChildren() != 0) {
            this.print(t2, visit, " extends ");
        }
    }

    @Override
    public void visitFinal(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "final ", null, null);
    }

    @Override
    public void visitForCondition(GroovySourceAST t2, int visit) {
        this.print(t2, visit, " ; ", null, null);
    }

    @Override
    public void visitForInit(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "(", null, null);
    }

    @Override
    public void visitForInIterable(GroovySourceAST t2, int visit) {
        this.printUpdatingTabLevel(t2, visit, "(", " in ", ") ");
    }

    @Override
    public void visitForIterator(GroovySourceAST t2, int visit) {
        this.print(t2, visit, " ; ", null, ")");
    }

    @Override
    public void visitGe(GroovySourceAST t2, int visit) {
        this.print(t2, visit, " >= ", null, null);
    }

    @Override
    public void visitGt(GroovySourceAST t2, int visit) {
        this.print(t2, visit, " > ", null, null);
    }

    @Override
    public void visitIdent(GroovySourceAST t2, int visit) {
        this.print(t2, visit, t2.getText(), null, null);
    }

    @Override
    public void visitImplementsClause(GroovySourceAST t2, int visit) {
        if (visit == 1 && t2.getNumberOfChildren() != 0) {
            this.print(t2, visit, " implements ");
        }
        if (visit == 4) {
            this.print(t2, visit, " ");
        }
    }

    @Override
    public void visitImplicitParameters(GroovySourceAST t2, int visit) {
    }

    @Override
    public void visitImport(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "import ", null, null);
    }

    @Override
    public void visitInc(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "++", null, null);
    }

    @Override
    public void visitIndexOp(GroovySourceAST t2, int visit) {
        this.printUpdatingTabLevel(t2, visit, "[", null, "]");
    }

    @Override
    public void visitInterfaceDef(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "interface ", null, null);
    }

    @Override
    public void visitInstanceInit(GroovySourceAST t2, int visit) {
    }

    @Override
    public void visitLabeledArg(GroovySourceAST t2, int visit) {
        this.print(t2, visit, ":", null, null);
    }

    @Override
    public void visitLabeledStat(GroovySourceAST t2, int visit) {
        this.print(t2, visit, ":", null, null);
    }

    @Override
    public void visitLand(GroovySourceAST t2, int visit) {
        this.print(t2, visit, " && ", null, null);
    }

    @Override
    public void visitLe(GroovySourceAST t2, int visit) {
        this.print(t2, visit, " <= ", null, null);
    }

    @Override
    public void visitListConstructor(GroovySourceAST t2, int visit) {
        this.printUpdatingTabLevel(t2, visit, "[", null, "]");
    }

    @Override
    public void visitLiteralAs(GroovySourceAST t2, int visit) {
        this.print(t2, visit, " as ", null, null);
    }

    @Override
    public void visitLiteralAssert(GroovySourceAST t2, int visit) {
        if (t2.getNumberOfChildren() > 1) {
            this.print(t2, visit, "assert ", null, " : ");
        } else {
            this.print(t2, visit, "assert ", null, null);
        }
    }

    @Override
    public void visitLiteralBoolean(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "boolean", null, null);
    }

    @Override
    public void visitLiteralBreak(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "break ", null, null);
    }

    @Override
    public void visitLiteralByte(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "byte", null, null);
    }

    @Override
    public void visitLiteralCase(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "case ", null, ":");
    }

    @Override
    public void visitLiteralCatch(GroovySourceAST t2, int visit) {
        this.printUpdatingTabLevel(t2, visit, " catch (", null, ") ");
    }

    @Override
    public void visitLiteralChar(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "char", null, null);
    }

    @Override
    public void visitLiteralContinue(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "continue ", null, null);
    }

    @Override
    public void visitLiteralDefault(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "default", null, ":");
    }

    @Override
    public void visitLiteralDouble(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "double", null, null);
    }

    @Override
    public void visitLiteralFalse(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "false", null, null);
    }

    @Override
    public void visitLiteralFinally(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "finally ", null, null);
    }

    @Override
    public void visitLiteralFloat(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "float", null, null);
    }

    @Override
    public void visitLiteralFor(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "for ", null, null);
    }

    @Override
    public void visitLiteralIf(GroovySourceAST t2, int visit) {
        this.printUpdatingTabLevel(t2, visit, "if (", " else ", ") ");
    }

    @Override
    public void visitLiteralIn(GroovySourceAST t2, int visit) {
        this.print(t2, visit, " in ", null, null);
    }

    @Override
    public void visitLiteralInstanceof(GroovySourceAST t2, int visit) {
        this.print(t2, visit, " instanceof ", null, null);
    }

    @Override
    public void visitLiteralInt(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "int", null, null);
    }

    @Override
    public void visitLiteralLong(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "long", null, null);
    }

    @Override
    public void visitLiteralNative(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "native ", null, null);
    }

    @Override
    public void visitLiteralNew(GroovySourceAST t2, int visit) {
        if (t2.childOfType(17) == null) {
            this.print(t2, visit, "new ", "(", ")");
        } else {
            this.print(t2, visit, "new ", null, null);
        }
    }

    @Override
    public void visitLiteralNull(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "null", null, null);
    }

    @Override
    public void visitLiteralPrivate(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "private ", null, null);
    }

    @Override
    public void visitLiteralProtected(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "protected ", null, null);
    }

    @Override
    public void visitLiteralPublic(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "public ", null, null);
    }

    @Override
    public void visitLiteralReturn(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "return ", null, null);
    }

    @Override
    public void visitLiteralShort(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "short", null, null);
    }

    @Override
    public void visitLiteralStatic(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "static ", null, null);
    }

    @Override
    public void visitLiteralSuper(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "super", null, null);
    }

    @Override
    public void visitLiteralSwitch(GroovySourceAST t2, int visit) {
        if (visit == 1) {
            this.print(t2, visit, "switch (");
            ++this.tabLevel;
        }
        if (visit == 3) {
            this.print(t2, visit, ") {");
        }
        if (visit == 4) {
            --this.tabLevel;
            this.print(t2, visit, "}");
        }
    }

    @Override
    public void visitLiteralSynchronized(GroovySourceAST t2, int visit) {
        if (t2.getNumberOfChildren() > 0) {
            this.print(t2, visit, "synchronized (", null, ") ");
        } else {
            this.print(t2, visit, "synchronized ", null, null);
        }
    }

    @Override
    public void visitLiteralThis(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "this", null, null);
    }

    @Override
    public void visitLiteralThreadsafe(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "threadsafe ", null, null);
    }

    @Override
    public void visitLiteralThrow(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "throw ", null, null);
    }

    @Override
    public void visitLiteralThrows(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "throws ", null, null);
    }

    @Override
    public void visitLiteralTransient(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "transient ", null, null);
    }

    @Override
    public void visitLiteralTrue(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "true", null, null);
    }

    @Override
    public void visitLiteralTry(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "try ", null, null);
    }

    @Override
    public void visitLiteralVoid(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "void", null, null);
    }

    @Override
    public void visitLiteralVolatile(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "volatile ", null, null);
    }

    @Override
    public void visitLiteralWhile(GroovySourceAST t2, int visit) {
        this.printUpdatingTabLevel(t2, visit, "while (", null, ") ");
    }

    @Override
    public void visitLnot(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "!", null, null);
    }

    @Override
    public void visitLor(GroovySourceAST t2, int visit) {
        this.print(t2, visit, " || ", null, null);
    }

    @Override
    public void visitLt(GroovySourceAST t2, int visit) {
        this.print(t2, visit, " < ", null, null);
    }

    @Override
    public void visitMapConstructor(GroovySourceAST t2, int visit) {
        if (t2.getNumberOfChildren() == 0) {
            this.print(t2, visit, "[:]", null, null);
        } else {
            this.printUpdatingTabLevel(t2, visit, "[", null, "]");
        }
    }

    @Override
    public void visitMemberPointer(GroovySourceAST t2, int visit) {
        this.print(t2, visit, ".&", null, null);
    }

    @Override
    public void visitMethodCall(GroovySourceAST t2, int visit) {
        if ("<command>".equals(t2.getText())) {
            this.printUpdatingTabLevel(t2, visit, " ", " ", null);
        } else {
            this.printUpdatingTabLevel(t2, visit, "(", " ", ")");
        }
    }

    @Override
    public void visitMethodDef(GroovySourceAST t2, int visit) {
    }

    @Override
    public void visitMinus(GroovySourceAST t2, int visit) {
        this.print(t2, visit, " - ", null, null);
    }

    @Override
    public void visitMinusAssign(GroovySourceAST t2, int visit) {
        this.print(t2, visit, " -= ", null, null);
    }

    @Override
    public void visitMod(GroovySourceAST t2, int visit) {
        this.print(t2, visit, " % ", null, null);
    }

    @Override
    public void visitModifiers(GroovySourceAST t2, int visit) {
    }

    @Override
    public void visitModAssign(GroovySourceAST t2, int visit) {
        this.print(t2, visit, " %= ", null, null);
    }

    @Override
    public void visitMultiCatch(GroovySourceAST t2, int visit) {
        if (visit == 4) {
            AST child = t2.getFirstChild();
            if ("MULTICATCH_TYPES".equals(child.getText())) {
                this.print(t2, visit, null, null, " " + child.getNextSibling().getText());
            } else {
                this.print(t2, visit, null, null, " " + child.getFirstChild().getText());
            }
        }
    }

    @Override
    public void visitMultiCatchTypes(GroovySourceAST t2, int visit) {
    }

    @Override
    public void visitNotEqual(GroovySourceAST t2, int visit) {
        this.print(t2, visit, " != ", null, null);
    }

    @Override
    public void visitNumBigDecimal(GroovySourceAST t2, int visit) {
        this.print(t2, visit, t2.getText(), null, null);
    }

    @Override
    public void visitNumBigInt(GroovySourceAST t2, int visit) {
        this.print(t2, visit, t2.getText(), null, null);
    }

    @Override
    public void visitNumDouble(GroovySourceAST t2, int visit) {
        this.print(t2, visit, t2.getText(), null, null);
    }

    @Override
    public void visitNumInt(GroovySourceAST t2, int visit) {
        this.print(t2, visit, t2.getText(), null, null);
    }

    @Override
    public void visitNumFloat(GroovySourceAST t2, int visit) {
        this.print(t2, visit, t2.getText(), null, null);
    }

    @Override
    public void visitNumLong(GroovySourceAST t2, int visit) {
        this.print(t2, visit, t2.getText(), null, null);
    }

    @Override
    public void visitObjblock(GroovySourceAST t2, int visit) {
        if (visit == 1) {
            ++this.tabLevel;
            this.print(t2, visit, "{");
        } else {
            --this.tabLevel;
            this.print(t2, visit, "}");
        }
    }

    @Override
    public void visitOptionalDot(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "?.", null, null);
    }

    @Override
    public void visitPackageDef(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "package ", null, null);
    }

    @Override
    public void visitParameterDef(GroovySourceAST t2, int visit) {
    }

    @Override
    public void visitParameters(GroovySourceAST t2, int visit) {
        if (this.getParentNode().getType() == 50) {
            this.printUpdatingTabLevel(t2, visit, null, ",", " ");
        } else {
            this.printUpdatingTabLevel(t2, visit, "(", ", ", ") ");
        }
    }

    @Override
    public void visitPlus(GroovySourceAST t2, int visit) {
        this.print(t2, visit, " + ", null, null);
    }

    @Override
    public void visitPlusAssign(GroovySourceAST t2, int visit) {
        this.print(t2, visit, " += ", null, null);
    }

    @Override
    public void visitPostDec(GroovySourceAST t2, int visit) {
        this.print(t2, visit, null, null, "--");
    }

    @Override
    public void visitPostInc(GroovySourceAST t2, int visit) {
        this.print(t2, visit, null, null, "++");
    }

    @Override
    public void visitQuestion(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "?", ":", null);
    }

    @Override
    public void visitRangeExclusive(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "..<", null, null);
    }

    @Override
    public void visitRangeInclusive(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "..", null, null);
    }

    @Override
    public void visitRegexFind(GroovySourceAST t2, int visit) {
        this.print(t2, visit, " =~ ", null, null);
    }

    @Override
    public void visitRegexMatch(GroovySourceAST t2, int visit) {
        this.print(t2, visit, " ==~ ", null, null);
    }

    @Override
    public void visitSelectSlot(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "@", null, null);
    }

    @Override
    public void visitSl(GroovySourceAST t2, int visit) {
        this.print(t2, visit, " << ", null, null);
    }

    @Override
    public void visitSlAssign(GroovySourceAST t2, int visit) {
        this.print(t2, visit, " <<= ", null, null);
    }

    @Override
    public void visitSlist(GroovySourceAST t2, int visit) {
        if (visit == 1) {
            ++this.tabLevel;
            this.print(t2, visit, "{");
        } else {
            --this.tabLevel;
            this.print(t2, visit, "}");
        }
    }

    @Override
    public void visitSpreadArg(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "*", null, null);
    }

    @Override
    public void visitSpreadDot(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "*.", null, null);
    }

    @Override
    public void visitSpreadMapArg(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "*:", null, null);
    }

    @Override
    public void visitSr(GroovySourceAST t2, int visit) {
        this.print(t2, visit, " >> ", null, null);
    }

    @Override
    public void visitSrAssign(GroovySourceAST t2, int visit) {
        this.print(t2, visit, " >>= ", null, null);
    }

    @Override
    public void visitStar(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "*", null, null);
    }

    @Override
    public void visitStarAssign(GroovySourceAST t2, int visit) {
        this.print(t2, visit, " *= ", null, null);
    }

    @Override
    public void visitStarStar(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "**", null, null);
    }

    @Override
    public void visitStarStarAssign(GroovySourceAST t2, int visit) {
        this.print(t2, visit, " **= ", null, null);
    }

    @Override
    public void visitStaticInit(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "static ", null, null);
    }

    @Override
    public void visitStaticImport(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "import static ", null, null);
    }

    @Override
    public void visitStrictfp(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "strictfp ", null, null);
    }

    @Override
    public void visitStringConstructor(GroovySourceAST t2, int visit) {
        if (visit == 1) {
            this.stringConstructorCounter = 0;
            this.print(t2, visit, "\"");
        }
        if (visit == 3) {
            if (this.stringConstructorCounter % 2 == 0) {
                this.print(t2, visit, "$");
            }
            ++this.stringConstructorCounter;
        }
        if (visit == 4) {
            this.print(t2, visit, "\"");
        }
    }

    @Override
    public void visitStringLiteral(GroovySourceAST t2, int visit) {
        if (visit == 1) {
            String theString = SourcePrinter.escape(t2.getText());
            if (this.getParentNode().getType() != 54 && this.getParentNode().getType() != 48) {
                theString = "\"" + theString + "\"";
            }
            this.print(t2, visit, theString);
        }
    }

    private static String escape(String literal) {
        literal = literal.replaceAll("\n", "\\\\<<REMOVE>>n");
        literal = literal.replaceAll("<<REMOVE>>", "");
        return literal;
    }

    @Override
    public void visitSuperCtorCall(GroovySourceAST t2, int visit) {
        this.printUpdatingTabLevel(t2, visit, "super(", " ", ")");
    }

    @Override
    public void visitTraitDef(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "trait ", null, null);
        if (visit == 1) {
            this.className = t2.childOfType(87).getText();
        }
    }

    @Override
    public void visitType(GroovySourceAST t2, int visit) {
        GroovySourceAST parent = this.getParentNode();
        GroovySourceAST modifiers = parent.childOfType(5);
        if (modifiers == null || modifiers.getNumberOfChildren() == 0) {
            if (visit == 1 && t2.getNumberOfChildren() == 0 && parent.getType() != 21) {
                this.print(t2, visit, "def");
            }
            if (visit == 4 && (parent.getType() == 9 || parent.getType() == 8 || parent.getType() == 68 || parent.getType() == 21 && t2.getNumberOfChildren() != 0)) {
                this.print(t2, visit, " ");
            }
        } else if (visit == 4 && t2.getNumberOfChildren() != 0) {
            this.print(t2, visit, " ");
        }
    }

    @Override
    public void visitTypeArgument(GroovySourceAST t2, int visit) {
    }

    @Override
    public void visitTypeArguments(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "<", ", ", ">");
    }

    @Override
    public void visitTypecast(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "(", null, ")");
    }

    @Override
    public void visitTypeLowerBounds(GroovySourceAST t2, int visit) {
        this.print(t2, visit, " super ", " & ", null);
    }

    @Override
    public void visitTypeParameter(GroovySourceAST t2, int visit) {
    }

    @Override
    public void visitTypeParameters(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "<", ", ", ">");
    }

    @Override
    public void visitTypeUpperBounds(GroovySourceAST t2, int visit) {
        this.print(t2, visit, " extends ", " & ", null);
    }

    @Override
    public void visitUnaryMinus(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "-", null, null);
    }

    @Override
    public void visitUnaryPlus(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "+", null, null);
    }

    @Override
    public void visitVariableDef(GroovySourceAST t2, int visit) {
    }

    @Override
    public void visitVariableParameterDef(GroovySourceAST t2, int visit) {
        this.print(t2, visit, null, "... ", null);
    }

    @Override
    public void visitWildcardType(GroovySourceAST t2, int visit) {
        this.print(t2, visit, "?", null, null);
    }

    @Override
    public void visitDefault(GroovySourceAST t2, int visit) {
        if (visit == 1) {
            this.print(t2, visit, "<" + this.tokenNames[t2.getType()] + ">");
        } else {
            this.print(t2, visit, "</" + this.tokenNames[t2.getType()] + ">");
        }
    }

    protected void printUpdatingTabLevel(GroovySourceAST t2, int visit, String opening, String subsequent, String closing) {
        if (visit == 1 && opening != null) {
            this.print(t2, visit, opening);
            ++this.tabLevel;
        }
        if (visit == 3 && subsequent != null) {
            this.print(t2, visit, subsequent);
        }
        if (visit == 4 && closing != null) {
            --this.tabLevel;
            this.print(t2, visit, closing);
        }
    }

    protected void print(GroovySourceAST t2, int visit, String opening, String subsequent, String closing) {
        if (visit == 1 && opening != null) {
            this.print(t2, visit, opening);
        }
        if (visit == 3 && subsequent != null) {
            this.print(t2, visit, subsequent);
        }
        if (visit == 4 && closing != null) {
            this.print(t2, visit, closing);
        }
    }

    protected void print(GroovySourceAST t2, int visit, String value) {
        if (visit == 1) {
            this.printNewlineAndIndent(t2, visit);
        }
        if (visit == 4) {
            this.printNewlineAndIndent(t2, visit);
        }
        this.out.print(value);
    }

    protected void printNewlineAndIndent(GroovySourceAST t2, int visit) {
        int currentLine = t2.getLine();
        if (this.lastLinePrinted == 0) {
            this.lastLinePrinted = currentLine;
        }
        if (this.lastLinePrinted != currentLine) {
            if (this.newLines && (visit != 1 || t2.getType() != 7)) {
                int i;
                for (i = this.lastLinePrinted; i < currentLine; ++i) {
                    this.out.println();
                }
                if (this.lastLinePrinted > currentLine) {
                    this.out.println();
                    this.lastLinePrinted = currentLine;
                }
                if (visit == 1 || visit == 4 && this.lastLinePrinted > currentLine) {
                    for (i = 0; i < this.tabLevel; ++i) {
                        this.out.print("    ");
                    }
                }
            }
            this.lastLinePrinted = Math.max(currentLine, this.lastLinePrinted);
        }
    }

    @Override
    public void push(GroovySourceAST t2) {
        this.stack.push(t2);
    }

    @Override
    public GroovySourceAST pop() {
        if (!this.stack.empty()) {
            return (GroovySourceAST)this.stack.pop();
        }
        return null;
    }

    private GroovySourceAST getParentNode() {
        Object currentNode = this.stack.pop();
        Object parentNode = this.stack.peek();
        this.stack.push(currentNode);
        return (GroovySourceAST)parentNode;
    }
}

