/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.testing.assertj;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;

public final class AttributesAssert
extends AbstractAssert<AttributesAssert, Attributes> {
    AttributesAssert(Attributes actual) {
        super((Object)actual, AttributesAssert.class);
    }

    public <T> AttributesAssert containsEntry(AttributeKey<T> key, T value) {
        this.isNotNull();
        T actualValue = ((Attributes)this.actual).get(key);
        if (!Objects.equals(actualValue, value)) {
            this.failWithActualExpectedAndMessage(actualValue, value, "Expected attributes to have key <%s> with value <%s> but was value <%s>", new Object[]{key, value, actualValue});
        }
        return this;
    }

    public AttributesAssert containsEntry(String key, String value) {
        return this.containsEntry(AttributeKey.stringKey(key), value);
    }

    public AttributesAssert containsEntry(String key, boolean value) {
        return this.containsEntry(AttributeKey.booleanKey(key), Boolean.valueOf(value));
    }

    public AttributesAssert containsEntry(String key, long value) {
        return this.containsEntry(AttributeKey.longKey(key), Long.valueOf(value));
    }

    public AttributesAssert containsEntry(String key, double value) {
        return this.containsEntry(AttributeKey.doubleKey(key), Double.valueOf(value));
    }

    public AttributesAssert containsEntry(String key, String ... value) {
        return this.containsEntry(AttributeKey.stringArrayKey(key), Arrays.asList(value));
    }

    public AttributesAssert containsEntry(String key, Boolean ... value) {
        return this.containsEntry(AttributeKey.booleanArrayKey(key), Arrays.asList(value));
    }

    public AttributesAssert containsEntry(String key, Long ... value) {
        return this.containsEntry(AttributeKey.longArrayKey(key), Arrays.asList(value));
    }

    public AttributesAssert containsEntry(String key, Double ... value) {
        return this.containsEntry(AttributeKey.doubleArrayKey(key), Arrays.asList(value));
    }

    public AttributesAssert containsEntryWithStringValuesOf(String key, Iterable<String> value) {
        this.isNotNull();
        List<String> actualValue = ((Attributes)this.actual).get(AttributeKey.stringArrayKey(key));
        ((ListAssert)Assertions.assertThat(actualValue).withFailMessage("Expected attributes to have key <%s> with value <%s> but was <%s>", new Object[]{key, value, actualValue})).containsExactlyElementsOf(value);
        return this;
    }

    public AttributesAssert containsEntryWithBooleanValuesOf(String key, Iterable<Boolean> value) {
        this.isNotNull();
        List<Boolean> actualValue = ((Attributes)this.actual).get(AttributeKey.booleanArrayKey(key));
        ((ListAssert)Assertions.assertThat(actualValue).withFailMessage("Expected attributes to have key <%s> with value <%s> but was <%s>", new Object[]{key, value, actualValue})).containsExactlyElementsOf(value);
        return this;
    }

    public AttributesAssert containsEntryWithLongValuesOf(String key, Iterable<Long> value) {
        this.isNotNull();
        List<Long> actualValue = ((Attributes)this.actual).get(AttributeKey.longArrayKey(key));
        ((ListAssert)Assertions.assertThat(actualValue).withFailMessage("Expected attributes to have key <%s> with value <%s> but was <%s>", new Object[]{key, value, actualValue})).containsExactlyElementsOf(value);
        return this;
    }

    public AttributesAssert containsEntryWithDoubleValuesOf(String key, Iterable<Double> value) {
        this.isNotNull();
        List<Double> actualValue = ((Attributes)this.actual).get(AttributeKey.doubleArrayKey(key));
        ((ListAssert)Assertions.assertThat(actualValue).withFailMessage("Expected attributes to have key <%s> with value <%s> but was <%s>", new Object[]{key, value, actualValue})).containsExactlyElementsOf(value);
        return this;
    }

    public <T> AttributesAssert hasEntrySatisfying(AttributeKey<T> key, Consumer<T> valueCondition) {
        this.isNotNull();
        ((ObjectAssert)Assertions.assertThat(((Attributes)this.actual).get(key)).as("value", new Object[0])).satisfies(valueCondition);
        return this;
    }

    @SafeVarargs
    public final AttributesAssert containsOnly(Map.Entry<? extends AttributeKey<?>, ?> ... entries) {
        this.isNotNull();
        Assertions.assertThat(((Attributes)this.actual).asMap()).containsOnly((Map.Entry[])entries);
        return this;
    }

    public AttributesAssert isEmpty() {
        return (AttributesAssert)this.isEqualTo(Attributes.empty());
    }

    public AttributesAssert hasSize(int numberOfEntries) {
        int size = ((Attributes)this.actual).size();
        if (size != numberOfEntries) {
            this.failWithActualExpectedAndMessage(size, numberOfEntries, "Expected attributes to have <%s> entries but actually has <%s>", new Object[]{numberOfEntries, size});
        }
        return this;
    }
}

