/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.autoconfigure;

import io.opentelemetry.api.baggage.propagation.W3CBaggagePropagator;
import io.opentelemetry.api.trace.propagation.W3CTraceContextPropagator;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.sdk.autoconfigure.ConfigProperties;
import io.opentelemetry.sdk.autoconfigure.ConfigurationException;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigurablePropagatorProvider;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

final class PropagatorConfiguration {
    static ContextPropagators configurePropagators(ConfigProperties config) {
        Map<String, TextMapPropagator> spiPropagators = StreamSupport.stream(ServiceLoader.load(ConfigurablePropagatorProvider.class).spliterator(), false).collect(Collectors.toMap(ConfigurablePropagatorProvider::getName, ConfigurablePropagatorProvider::getPropagator));
        LinkedHashSet<TextMapPropagator> propagators = new LinkedHashSet<TextMapPropagator>();
        List<String> requestedPropagators = config.getCommaSeparatedValues("otel.propagators");
        if (requestedPropagators.isEmpty()) {
            requestedPropagators = Arrays.asList("tracecontext", "baggage");
        }
        for (String propagatorName : requestedPropagators) {
            propagators.add(PropagatorConfiguration.getPropagator(propagatorName, spiPropagators));
        }
        return ContextPropagators.create(TextMapPropagator.composite(propagators));
    }

    private static TextMapPropagator getPropagator(String name, Map<String, TextMapPropagator> spiPropagators) {
        if (name.equals("tracecontext")) {
            return W3CTraceContextPropagator.getInstance();
        }
        if (name.equals("baggage")) {
            return W3CBaggagePropagator.getInstance();
        }
        TextMapPropagator spiPropagator = spiPropagators.get(name);
        if (spiPropagator != null) {
            return spiPropagator;
        }
        throw new ConfigurationException("Unrecognized value for otel.propagators: " + name + ". Make sure the artifact including the propagator is on the classpath.");
    }

    private PropagatorConfiguration() {
    }
}

