/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.jmxmetrics;

import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.metrics.AsynchronousInstrument;
import io.opentelemetry.api.metrics.DoubleCounter;
import io.opentelemetry.api.metrics.DoubleSumObserver;
import io.opentelemetry.api.metrics.DoubleUpDownCounter;
import io.opentelemetry.api.metrics.DoubleUpDownSumObserver;
import io.opentelemetry.api.metrics.DoubleValueObserver;
import io.opentelemetry.api.metrics.DoubleValueRecorder;
import io.opentelemetry.api.metrics.GlobalMeterProvider;
import io.opentelemetry.api.metrics.LongCounter;
import io.opentelemetry.api.metrics.LongSumObserver;
import io.opentelemetry.api.metrics.LongUpDownCounter;
import io.opentelemetry.api.metrics.LongUpDownSumObserver;
import io.opentelemetry.api.metrics.LongValueObserver;
import io.opentelemetry.api.metrics.LongValueRecorder;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.common.Labels;
import io.opentelemetry.api.metrics.common.LabelsBuilder;
import io.opentelemetry.contrib.jmxmetrics.JmxConfig;
import io.opentelemetry.sdk.metrics.SdkMeterProvider;
import io.opentelemetry.sdk.metrics.common.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.common.InstrumentType;
import io.opentelemetry.sdk.metrics.common.InstrumentValueType;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.export.MetricExporter;
import io.opentelemetry.sdk.metrics.testing.InMemoryMetricExporter;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public class GroovyMetricEnvironment {
    private final SdkMeterProvider meterProvider;
    private final Meter meter;
    private MetricExporter exporter;
    private final Map<Integer, AtomicReference<Consumer<AsynchronousInstrument.LongResult>>> longUpdaterRegistry = new ConcurrentHashMap<Integer, AtomicReference<Consumer<AsynchronousInstrument.LongResult>>>();
    private final Map<Integer, AtomicReference<Consumer<AsynchronousInstrument.DoubleResult>>> doubleUpdaterRegistry = new ConcurrentHashMap<Integer, AtomicReference<Consumer<AsynchronousInstrument.DoubleResult>>>();

    public GroovyMetricEnvironment(JmxConfig config, String instrumentationName, String instrumentationVersion) {
        switch (config.metricsExporterType.toLowerCase()) {
            case "otlp": 
            case "prometheus": 
            case "logging": {
                config.properties.setProperty("otel.traces.exporter", "none");
                config.properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, value) -> {
                    String key = k.toString();
                    if (key.startsWith("otel.") && !key.startsWith("otel.jmx")) {
                        System.setProperty(key, value.toString());
                    }
                }));
                GlobalOpenTelemetry.get();
                this.meterProvider = (SdkMeterProvider)GlobalMeterProvider.get();
                break;
            }
            default: {
                this.meterProvider = SdkMeterProvider.builder().buildAndRegisterGlobal();
                this.exporter = InMemoryMetricExporter.create();
            }
        }
        this.meter = this.meterProvider.get(instrumentationName, instrumentationVersion);
    }

    public GroovyMetricEnvironment(JmxConfig config) {
        this(config, "io.opentelemetry.contrib.jmxmetrics", "1.0.0-alpha");
    }

    public void exportMetrics() {
        if (this.exporter != null) {
            Collection<MetricData> md = this.meterProvider.collectAllMetrics();
            this.exporter.export(md);
        }
    }

    protected static Labels mapToLabels(Map<String, String> labelMap) {
        LabelsBuilder labels = Labels.builder();
        if (labelMap != null) {
            for (Map.Entry<String, String> kv : labelMap.entrySet()) {
                labels.put(kv.getKey(), kv.getValue());
            }
        }
        return labels.build();
    }

    public DoubleCounter getDoubleCounter(String name, String description, String unit) {
        return this.meter.doubleCounterBuilder(name).setDescription(description).setUnit(unit).build();
    }

    public LongCounter getLongCounter(String name, String description, String unit) {
        return this.meter.longCounterBuilder(name).setDescription(description).setUnit(unit).build();
    }

    public DoubleUpDownCounter getDoubleUpDownCounter(String name, String description, String unit) {
        return this.meter.doubleUpDownCounterBuilder(name).setDescription(description).setUnit(unit).build();
    }

    public LongUpDownCounter getLongUpDownCounter(String name, String description, String unit) {
        return this.meter.longUpDownCounterBuilder(name).setDescription(description).setUnit(unit).build();
    }

    public DoubleValueRecorder getDoubleValueRecorder(String name, String description, String unit) {
        return this.meter.doubleValueRecorderBuilder(name).setDescription(description).setUnit(unit).build();
    }

    public LongValueRecorder getLongValueRecorder(String name, String description, String unit) {
        return this.meter.longValueRecorderBuilder(name).setDescription(description).setUnit(unit).build();
    }

    public DoubleSumObserver getDoubleSumObserver(String name, String description, String unit, Consumer<AsynchronousInstrument.DoubleResult> updater) {
        return this.meter.doubleSumObserverBuilder(name).setDescription(description).setUnit(unit).setUpdater((Consumer)this.proxiedDoubleObserver(name, description, unit, InstrumentType.SUM_OBSERVER, updater)).build();
    }

    public LongSumObserver getLongSumObserver(String name, String description, String unit, Consumer<AsynchronousInstrument.LongResult> updater) {
        return this.meter.longSumObserverBuilder(name).setDescription(description).setUnit(unit).setUpdater((Consumer)this.proxiedLongObserver(name, description, unit, InstrumentType.SUM_OBSERVER, updater)).build();
    }

    public DoubleUpDownSumObserver getDoubleUpDownSumObserver(String name, String description, String unit, Consumer<AsynchronousInstrument.DoubleResult> updater) {
        return this.meter.doubleUpDownSumObserverBuilder(name).setDescription(description).setUnit(unit).setUpdater((Consumer)this.proxiedDoubleObserver(name, description, unit, InstrumentType.UP_DOWN_SUM_OBSERVER, updater)).build();
    }

    public LongUpDownSumObserver getLongUpDownSumObserver(String name, String description, String unit, Consumer<AsynchronousInstrument.LongResult> updater) {
        return this.meter.longUpDownSumObserverBuilder(name).setDescription(description).setUnit(unit).setUpdater((Consumer)this.proxiedLongObserver(name, description, unit, InstrumentType.UP_DOWN_SUM_OBSERVER, updater)).build();
    }

    public DoubleValueObserver getDoubleValueObserver(String name, String description, String unit, Consumer<AsynchronousInstrument.DoubleResult> updater) {
        return this.meter.doubleValueObserverBuilder(name).setDescription(description).setUnit(unit).setUpdater((Consumer)this.proxiedDoubleObserver(name, description, unit, InstrumentType.VALUE_OBSERVER, updater)).build();
    }

    public LongValueObserver getLongValueObserver(String name, String description, String unit, Consumer<AsynchronousInstrument.LongResult> updater) {
        return this.meter.longValueObserverBuilder(name).setDescription(description).setUnit(unit).setUpdater((Consumer)this.proxiedLongObserver(name, description, unit, InstrumentType.VALUE_OBSERVER, updater)).build();
    }

    private Consumer<AsynchronousInstrument.DoubleResult> proxiedDoubleObserver(String name, String description, String unit, InstrumentType instrumentType, Consumer<AsynchronousInstrument.DoubleResult> updater) {
        InstrumentDescriptor descriptor = InstrumentDescriptor.create(name, description, unit, instrumentType, InstrumentValueType.DOUBLE);
        this.doubleUpdaterRegistry.putIfAbsent(descriptor.hashCode(), new AtomicReference());
        AtomicReference<Consumer<AsynchronousInstrument.DoubleResult>> existingUpdater = this.doubleUpdaterRegistry.get(descriptor.hashCode());
        existingUpdater.set(updater);
        return doubleResult -> {
            Consumer existing = (Consumer)existingUpdater.get();
            existing.accept(doubleResult);
        };
    }

    private Consumer<AsynchronousInstrument.LongResult> proxiedLongObserver(String name, String description, String unit, InstrumentType instrumentType, Consumer<AsynchronousInstrument.LongResult> updater) {
        InstrumentDescriptor descriptor = InstrumentDescriptor.create(name, description, unit, instrumentType, InstrumentValueType.LONG);
        this.longUpdaterRegistry.putIfAbsent(descriptor.hashCode(), new AtomicReference());
        AtomicReference<Consumer<AsynchronousInstrument.LongResult>> existingUpdater = this.longUpdaterRegistry.get(descriptor.hashCode());
        existingUpdater.set(updater);
        return longResult -> {
            Consumer existing = (Consumer)existingUpdater.get();
            existing.accept(longResult);
        };
    }
}

