/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.api.metrics;

import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.MeterBuilder;
import io.opentelemetry.api.metrics.MeterProvider;
import java.util.concurrent.atomic.AtomicReference;

public final class GlobalMeterProvider {
    private static final Object mutex = new Object();
    private static final AtomicReference<MeterProvider> globalMeterProvider = new AtomicReference();

    private GlobalMeterProvider() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MeterProvider get() {
        MeterProvider meterProvider = globalMeterProvider.get();
        if (meterProvider == null) {
            Object object = mutex;
            synchronized (object) {
                if (globalMeterProvider.get() == null) {
                    return MeterProvider.noop();
                }
            }
        }
        return meterProvider;
    }

    public static void set(MeterProvider meterProvider) {
        globalMeterProvider.set(meterProvider);
    }

    public static Meter getMeter(String instrumentationName) {
        return GlobalMeterProvider.get().get(instrumentationName);
    }

    public static Meter getMeter(String instrumentationName, String instrumentationVersion) {
        return GlobalMeterProvider.get().get(instrumentationName, instrumentationVersion);
    }

    public static MeterBuilder meterBuilder(String instrumentationName) {
        return GlobalMeterProvider.get().meterBuilder(instrumentationName);
    }
}

