/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.testing.assertj;

import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.data.HistogramData;
import io.opentelemetry.sdk.testing.assertj.AssertUtil;
import io.opentelemetry.sdk.testing.assertj.HistogramPointAssert;
import java.util.Arrays;
import java.util.function.Consumer;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;

public final class HistogramAssert
extends AbstractAssert<HistogramAssert, HistogramData> {
    HistogramAssert(HistogramData actual) {
        super((Object)actual, HistogramAssert.class);
    }

    public HistogramAssert isCumulative() {
        this.isNotNull();
        if (((HistogramData)this.actual).getAggregationTemporality() != AggregationTemporality.CUMULATIVE) {
            this.failWithActualExpectedAndMessage(this.actual, "aggregationTemporality: CUMULATIVE", "Expected Histogram to have cumulative aggregation but found <%s>", new Object[]{AggregationTemporality.CUMULATIVE, ((HistogramData)this.actual).getAggregationTemporality()});
        }
        return this;
    }

    public HistogramAssert isDelta() {
        this.isNotNull();
        if (((HistogramData)this.actual).getAggregationTemporality() != AggregationTemporality.DELTA) {
            this.failWithActualExpectedAndMessage(this.actual, "aggregationTemporality: DELTA", "Expected Histgram to have cumulative aggregation but found <%s>", new Object[]{AggregationTemporality.DELTA, ((HistogramData)this.actual).getAggregationTemporality()});
        }
        return this;
    }

    @SafeVarargs
    public final HistogramAssert hasPointsSatisfying(Consumer<HistogramPointAssert> ... assertions) {
        return this.hasPointsSatisfying(Arrays.asList(assertions));
    }

    public HistogramAssert hasPointsSatisfying(Iterable<? extends Consumer<HistogramPointAssert>> assertions) {
        Assertions.assertThat(((HistogramData)this.actual).getPoints()).satisfiesExactlyInAnyOrder((Consumer[])AssertUtil.toConsumers(assertions, HistogramPointAssert::new));
        return this;
    }
}

