/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.otlp.http.trace;

import io.opentelemetry.api.internal.Utils;
import io.opentelemetry.api.metrics.MeterProvider;
import io.opentelemetry.exporter.internal.compression.Compressor;
import io.opentelemetry.exporter.internal.compression.CompressorUtil;
import io.opentelemetry.exporter.internal.http.HttpExporterBuilder;
import io.opentelemetry.exporter.internal.marshal.Marshaler;
import io.opentelemetry.exporter.otlp.http.trace.OtlpHttpSpanExporter;
import io.opentelemetry.exporter.otlp.internal.OtlpUserAgent;
import io.opentelemetry.sdk.common.export.MemoryMode;
import io.opentelemetry.sdk.common.export.ProxyOptions;
import io.opentelemetry.sdk.common.export.RetryPolicy;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.net.ssl.SSLContext;
import javax.net.ssl.X509TrustManager;

public final class OtlpHttpSpanExporterBuilder {
    private static final String DEFAULT_ENDPOINT = "http://localhost:4318/v1/traces";
    private static final MemoryMode DEFAULT_MEMORY_MODE = MemoryMode.IMMUTABLE_DATA;
    private final HttpExporterBuilder<Marshaler> delegate;
    private MemoryMode memoryMode;

    OtlpHttpSpanExporterBuilder(HttpExporterBuilder<Marshaler> delegate, MemoryMode memoryMode) {
        this.delegate = delegate;
        this.memoryMode = memoryMode;
        OtlpUserAgent.addUserAgentHeader(delegate::addConstantHeaders);
    }

    OtlpHttpSpanExporterBuilder() {
        this(new HttpExporterBuilder<Marshaler>("otlp", "span", DEFAULT_ENDPOINT), DEFAULT_MEMORY_MODE);
    }

    public OtlpHttpSpanExporterBuilder setTimeout(long timeout2, TimeUnit unit) {
        Objects.requireNonNull(unit, "unit");
        Utils.checkArgument(timeout2 >= 0L, "timeout must be non-negative");
        this.delegate.setTimeout(timeout2, unit);
        return this;
    }

    public OtlpHttpSpanExporterBuilder setTimeout(Duration timeout2) {
        Objects.requireNonNull(timeout2, "timeout");
        return this.setTimeout(timeout2.toNanos(), TimeUnit.NANOSECONDS);
    }

    public OtlpHttpSpanExporterBuilder setConnectTimeout(long timeout2, TimeUnit unit) {
        Objects.requireNonNull(unit, "unit");
        Utils.checkArgument(timeout2 >= 0L, "timeout must be non-negative");
        this.delegate.setConnectTimeout(timeout2, unit);
        return this;
    }

    public OtlpHttpSpanExporterBuilder setConnectTimeout(Duration timeout2) {
        Objects.requireNonNull(timeout2, "timeout");
        return this.setConnectTimeout(timeout2.toNanos(), TimeUnit.NANOSECONDS);
    }

    public OtlpHttpSpanExporterBuilder setEndpoint(String endpoint) {
        Objects.requireNonNull(endpoint, "endpoint");
        this.delegate.setEndpoint(endpoint);
        return this;
    }

    public OtlpHttpSpanExporterBuilder setCompression(String compressionMethod) {
        Objects.requireNonNull(compressionMethod, "compressionMethod");
        Compressor compressor = CompressorUtil.validateAndResolveCompressor(compressionMethod);
        this.delegate.setCompression(compressor);
        return this;
    }

    public OtlpHttpSpanExporterBuilder addHeader(String key, String value) {
        this.delegate.addConstantHeaders(key, value);
        return this;
    }

    public OtlpHttpSpanExporterBuilder setHeaders(Supplier<Map<String, String>> headerSupplier) {
        this.delegate.setHeadersSupplier(headerSupplier);
        return this;
    }

    public OtlpHttpSpanExporterBuilder setTrustedCertificates(byte[] trustedCertificatesPem) {
        this.delegate.setTrustManagerFromCerts(trustedCertificatesPem);
        return this;
    }

    public OtlpHttpSpanExporterBuilder setClientTls(byte[] privateKeyPem, byte[] certificatePem) {
        this.delegate.setKeyManagerFromCerts(privateKeyPem, certificatePem);
        return this;
    }

    public OtlpHttpSpanExporterBuilder setSslContext(SSLContext sslContext, X509TrustManager trustManager) {
        this.delegate.setSslContext(sslContext, trustManager);
        return this;
    }

    public OtlpHttpSpanExporterBuilder setRetryPolicy(@Nullable RetryPolicy retryPolicy) {
        this.delegate.setRetryPolicy(retryPolicy);
        return this;
    }

    public OtlpHttpSpanExporterBuilder setProxy(ProxyOptions proxyOptions) {
        Objects.requireNonNull(proxyOptions, "proxyOptions");
        this.delegate.setProxyOptions(proxyOptions);
        return this;
    }

    public OtlpHttpSpanExporterBuilder setMeterProvider(MeterProvider meterProvider) {
        Objects.requireNonNull(meterProvider, "meterProvider");
        this.setMeterProvider(() -> meterProvider);
        return this;
    }

    public OtlpHttpSpanExporterBuilder setMeterProvider(Supplier<MeterProvider> meterProviderSupplier) {
        Objects.requireNonNull(meterProviderSupplier, "meterProviderSupplier");
        this.delegate.setMeterProvider(meterProviderSupplier);
        return this;
    }

    public OtlpHttpSpanExporterBuilder setMemoryMode(MemoryMode memoryMode) {
        Objects.requireNonNull(memoryMode, "memoryMode");
        this.memoryMode = memoryMode;
        return this;
    }

    public OtlpHttpSpanExporter build() {
        return new OtlpHttpSpanExporter(this.delegate, this.delegate.build(), this.memoryMode);
    }
}

