/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.jmxmetrics;

import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import io.opentelemetry.contrib.jmxmetrics.ConfigurationException;
import io.opentelemetry.contrib.jmxmetrics.GroovyMetricEnvironment;
import io.opentelemetry.contrib.jmxmetrics.JmxClient;
import io.opentelemetry.contrib.jmxmetrics.JmxConfig;
import io.opentelemetry.contrib.jmxmetrics.OtelHelper;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.codehaus.groovy.control.CompilationFailedException;

public class GroovyRunner {
    private static final Logger logger = Logger.getLogger(GroovyRunner.class.getName());
    private final List<Script> scripts;
    private final GroovyMetricEnvironment groovyMetricEnvironment;

    GroovyRunner(JmxConfig config, JmxClient jmxClient, GroovyMetricEnvironment groovyMetricEnvironment) {
        this.groovyMetricEnvironment = groovyMetricEnvironment;
        ArrayList<String> scriptSources = new ArrayList<String>();
        try {
            if (config.targetSystems.size() != 0) {
                for (String target : config.targetSystems) {
                    String systemResourcePath = "target-systems/" + target + ".groovy";
                    scriptSources.add(this.getTargetSystemResourceAsString(systemResourcePath));
                }
            }
            if (config.groovyScript != null && !config.groovyScript.isEmpty()) {
                scriptSources.add(GroovyRunner.getFileAsString(config.groovyScript));
            }
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Failed to read groovy script", e);
            throw new ConfigurationException("Failed to read groovy script", e);
        }
        this.scripts = new ArrayList<Script>();
        try {
            for (String source2 : scriptSources) {
                this.scripts.add(new GroovyShell().parse(source2));
            }
        }
        catch (CompilationFailedException e) {
            logger.log(Level.SEVERE, "Failed to compile groovy script", e);
            throw new ConfigurationException("Failed to compile groovy script", e);
        }
        Binding binding = new Binding();
        binding.setVariable("log", logger);
        OtelHelper otelHelper = new OtelHelper(jmxClient, this.groovyMetricEnvironment);
        binding.setVariable("otel", otelHelper);
        for (Script script : this.scripts) {
            script.setBinding(binding);
        }
    }

    private static String getFileAsString(String fileName) throws IOException {
        try (FileInputStream is = new FileInputStream(fileName);){
            String string = GroovyRunner.getFileFromInputStream(is);
            return string;
        }
    }

    private String getTargetSystemResourceAsString(String targetSystem) throws IOException {
        URL res = this.getClass().getClassLoader().getResource(targetSystem);
        if (res == null) {
            throw new ConfigurationException("Failed to load " + targetSystem);
        }
        if (res.toString().contains("!")) {
            return GroovyRunner.getTargetSystemResourceFromJarAsString(res);
        }
        return GroovyRunner.getFileAsString(res.getPath());
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static String getTargetSystemResourceFromJarAsString(URL res) throws IOException {
        String[] array = res.toString().split("!");
        if (array.length != 2) {
            throw new ConfigurationException("Invalid path for target system resource from jar: " + res.toString());
        }
        Map env = Collections.emptyMap();
        try (FileSystem fs = FileSystems.newFileSystem(URI.create(array[0]), env);){
            String string;
            block15: {
                Path path = fs.getPath(array[1], new String[0]);
                InputStream is = Files.newInputStream(path, new OpenOption[0]);
                try {
                    string = GroovyRunner.getFileFromInputStream(is);
                    if (is == null) break block15;
                }
                catch (Throwable throwable) {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                is.close();
            }
            return string;
        }
        catch (IOException e) {
            throw new ConfigurationException("Failed to load " + res.toString(), e);
        }
    }

    private static String getFileFromInputStream(InputStream is) throws IOException {
        if (is == null) {
            return null;
        }
        try (InputStreamReader isr = new InputStreamReader(is, StandardCharsets.UTF_8);){
            String string;
            try (BufferedReader reader = new BufferedReader(isr);){
                String line;
                StringBuilder file = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    file.append(System.lineSeparator());
                    file.append(line);
                }
                string = file.toString();
            }
            return string;
        }
    }

    public void run() {
        for (Script script : this.scripts) {
            script.run();
        }
    }

    List<Script> getScripts() {
        return this.scripts;
    }
}

