/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.prometheus;

import io.opentelemetry.api.internal.Utils;
import io.opentelemetry.exporter.prometheus.PrometheusHttpServer;
import io.prometheus.metrics.model.registry.PrometheusRegistry;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.function.Predicate;
import javax.annotation.Nullable;

public final class PrometheusHttpServerBuilder {
    static final int DEFAULT_PORT = 9464;
    private static final String DEFAULT_HOST = "0.0.0.0";
    private String host = "0.0.0.0";
    private int port = 9464;
    private PrometheusRegistry prometheusRegistry = new PrometheusRegistry();
    private boolean otelScopeEnabled = true;
    @Nullable
    private Predicate<String> allowedResourceAttributesFilter;
    @Nullable
    private ExecutorService executor;

    public PrometheusHttpServerBuilder setHost(String host) {
        Objects.requireNonNull(host, "host");
        Utils.checkArgument(!host.isEmpty(), "host must not be empty");
        this.host = host;
        return this;
    }

    public PrometheusHttpServerBuilder setPort(int port) {
        Utils.checkArgument(port >= 0, "port must be positive");
        this.port = port;
        return this;
    }

    public PrometheusHttpServerBuilder setExecutor(ExecutorService executor) {
        Objects.requireNonNull(executor, "executor");
        this.executor = executor;
        return this;
    }

    public PrometheusHttpServerBuilder setPrometheusRegistry(PrometheusRegistry prometheusRegistry) {
        Objects.requireNonNull(prometheusRegistry, "prometheusRegistry");
        this.prometheusRegistry = prometheusRegistry;
        return this;
    }

    public PrometheusHttpServerBuilder setOtelScopeEnabled(boolean otelScopeEnabled) {
        this.otelScopeEnabled = otelScopeEnabled;
        return this;
    }

    public PrometheusHttpServerBuilder setAllowedResourceAttributesFilter(Predicate<String> resourceAttributesFilter) {
        this.allowedResourceAttributesFilter = Objects.requireNonNull(resourceAttributesFilter);
        return this;
    }

    public PrometheusHttpServer build() {
        return new PrometheusHttpServer(this.host, this.port, this.executor, this.prometheusRegistry, this.otelScopeEnabled, this.allowedResourceAttributesFilter);
    }

    PrometheusHttpServerBuilder() {
    }
}

