/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.testing.exporter;

import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.metrics.Aggregation;
import io.opentelemetry.sdk.metrics.InstrumentType;
import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.export.AggregationTemporalitySelector;
import io.opentelemetry.sdk.metrics.export.CollectionRegistration;
import io.opentelemetry.sdk.metrics.export.DefaultAggregationSelector;
import io.opentelemetry.sdk.metrics.export.MetricReader;
import io.opentelemetry.sdk.metrics.internal.export.MetricProducer;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;

public class InMemoryMetricReader
implements MetricReader {
    private final AggregationTemporalitySelector aggregationTemporalitySelector;
    private final DefaultAggregationSelector defaultAggregationSelector;
    private final AtomicBoolean isShutdown = new AtomicBoolean(false);
    private volatile MetricProducer metricProducer = MetricProducer.noop();

    public static InMemoryMetricReader create() {
        return new InMemoryMetricReader(AggregationTemporalitySelector.alwaysCumulative(), DefaultAggregationSelector.getDefault());
    }

    public static InMemoryMetricReader create(AggregationTemporalitySelector aggregationTemporalitySelector, DefaultAggregationSelector defaultAggregationSelector) {
        return new InMemoryMetricReader(aggregationTemporalitySelector, defaultAggregationSelector);
    }

    public static InMemoryMetricReader createDelta() {
        return new InMemoryMetricReader(unused -> AggregationTemporality.DELTA, DefaultAggregationSelector.getDefault());
    }

    private InMemoryMetricReader(AggregationTemporalitySelector aggregationTemporalitySelector, DefaultAggregationSelector defaultAggregationSelector) {
        this.aggregationTemporalitySelector = aggregationTemporalitySelector;
        this.defaultAggregationSelector = defaultAggregationSelector;
    }

    public Collection<MetricData> collectAllMetrics() {
        if (this.isShutdown.get()) {
            return Collections.emptyList();
        }
        return this.metricProducer.collectAllMetrics();
    }

    @Override
    public void register(CollectionRegistration registration) {
        this.metricProducer = MetricProducer.asMetricProducer(registration);
    }

    @Override
    public AggregationTemporality getAggregationTemporality(InstrumentType instrumentType) {
        return this.aggregationTemporalitySelector.getAggregationTemporality(instrumentType);
    }

    @Override
    public Aggregation getDefaultAggregation(InstrumentType instrumentType) {
        return this.defaultAggregationSelector.getDefaultAggregation(instrumentType);
    }

    @Override
    public CompletableResultCode forceFlush() {
        this.collectAllMetrics();
        return CompletableResultCode.ofSuccess();
    }

    @Override
    public CompletableResultCode shutdown() {
        this.isShutdown.set(true);
        return CompletableResultCode.ofSuccess();
    }

    public String toString() {
        return "InMemoryMetricReader{}";
    }
}

