/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.internal.grpc;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.MoreExecutors;
import io.grpc.Status;
import io.opentelemetry.api.metrics.MeterProvider;
import io.opentelemetry.exporter.internal.ExporterMetrics;
import io.opentelemetry.exporter.internal.grpc.GrpcExporter;
import io.opentelemetry.exporter.internal.grpc.GrpcExporterUtil;
import io.opentelemetry.exporter.internal.grpc.MarshalerServiceStub;
import io.opentelemetry.exporter.internal.marshal.Marshaler;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.internal.ThrottlingLogger;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class UpstreamGrpcExporter<T extends Marshaler>
implements GrpcExporter<T> {
    private static final Logger internalLogger = Logger.getLogger(UpstreamGrpcExporter.class.getName());
    private final ThrottlingLogger logger = new ThrottlingLogger(internalLogger);
    private final AtomicBoolean loggedUnimplemented = new AtomicBoolean();
    private final AtomicBoolean isShutdown = new AtomicBoolean();
    private final String type;
    private final ExporterMetrics exporterMetrics;
    private final MarshalerServiceStub<T, ?, ?> stub;
    private final long timeoutNanos;

    UpstreamGrpcExporter(String exporterName, String type, MarshalerServiceStub<T, ?, ?> stub, Supplier<MeterProvider> meterProviderSupplier, long timeoutNanos) {
        this.type = type;
        this.exporterMetrics = ExporterMetrics.createGrpc(exporterName, type, meterProviderSupplier);
        this.timeoutNanos = timeoutNanos;
        this.stub = stub;
    }

    @Override
    public CompletableResultCode export(T exportRequest, final int numItems) {
        if (this.isShutdown.get()) {
            return CompletableResultCode.ofFailure();
        }
        this.exporterMetrics.addSeen(numItems);
        final CompletableResultCode result = new CompletableResultCode();
        MarshalerServiceStub stub = this.stub;
        if (this.timeoutNanos > 0L) {
            stub = (MarshalerServiceStub)stub.withDeadlineAfter(this.timeoutNanos, TimeUnit.NANOSECONDS);
        }
        Futures.addCallback(stub.export(exportRequest), new FutureCallback<Object>(){

            @Override
            public void onSuccess(@Nullable Object unused) {
                UpstreamGrpcExporter.this.exporterMetrics.addSuccess(numItems);
                result.succeed();
            }

            @Override
            public void onFailure(Throwable t2) {
                UpstreamGrpcExporter.this.exporterMetrics.addFailed(numItems);
                Status status = Status.fromThrowable(t2);
                switch (status.getCode()) {
                    case UNIMPLEMENTED: {
                        if (!UpstreamGrpcExporter.this.loggedUnimplemented.compareAndSet(false, true)) break;
                        GrpcExporterUtil.logUnimplemented(internalLogger, UpstreamGrpcExporter.this.type, status.getDescription());
                        break;
                    }
                    case UNAVAILABLE: {
                        UpstreamGrpcExporter.this.logger.log(Level.SEVERE, "Failed to export " + UpstreamGrpcExporter.this.type + "s. Server is UNAVAILABLE. Make sure your collector is running and reachable from this network. Full error message:" + status.getDescription());
                        break;
                    }
                    default: {
                        UpstreamGrpcExporter.this.logger.log(Level.WARNING, "Failed to export " + UpstreamGrpcExporter.this.type + "s. Server responded with gRPC status code " + status.getCode().value() + ". Error message: " + status.getDescription());
                    }
                }
                if (UpstreamGrpcExporter.this.logger.isLoggable(Level.FINEST)) {
                    UpstreamGrpcExporter.this.logger.log(Level.FINEST, "Failed to export " + UpstreamGrpcExporter.this.type + "s. Details follow: " + t2);
                }
                result.fail();
            }
        }, MoreExecutors.directExecutor());
        return result;
    }

    @Override
    public CompletableResultCode shutdown() {
        if (!this.isShutdown.compareAndSet(false, true)) {
            this.logger.log(Level.INFO, "Calling shutdown() multiple times.");
        }
        return CompletableResultCode.ofSuccess();
    }
}

