/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.testing.logs;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.logs.Severity;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import io.opentelemetry.sdk.logs.data.Body;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.testing.logs.TestLogRecordData;
import javax.annotation.Nullable;

final class AutoValue_TestLogRecordData
extends TestLogRecordData {
    private final Resource resource;
    private final InstrumentationScopeInfo instrumentationScopeInfo;
    private final long timestampEpochNanos;
    private final long observedTimestampEpochNanos;
    private final SpanContext spanContext;
    private final Severity severity;
    private final String severityText;
    private final Body body;
    private final Attributes attributes;
    private final int totalAttributeCount;

    private AutoValue_TestLogRecordData(Resource resource, InstrumentationScopeInfo instrumentationScopeInfo, long timestampEpochNanos, long observedTimestampEpochNanos, SpanContext spanContext, Severity severity, @Nullable String severityText, Body body, Attributes attributes, int totalAttributeCount) {
        this.resource = resource;
        this.instrumentationScopeInfo = instrumentationScopeInfo;
        this.timestampEpochNanos = timestampEpochNanos;
        this.observedTimestampEpochNanos = observedTimestampEpochNanos;
        this.spanContext = spanContext;
        this.severity = severity;
        this.severityText = severityText;
        this.body = body;
        this.attributes = attributes;
        this.totalAttributeCount = totalAttributeCount;
    }

    @Override
    public Resource getResource() {
        return this.resource;
    }

    @Override
    public InstrumentationScopeInfo getInstrumentationScopeInfo() {
        return this.instrumentationScopeInfo;
    }

    @Override
    public long getTimestampEpochNanos() {
        return this.timestampEpochNanos;
    }

    @Override
    public long getObservedTimestampEpochNanos() {
        return this.observedTimestampEpochNanos;
    }

    @Override
    public SpanContext getSpanContext() {
        return this.spanContext;
    }

    @Override
    public Severity getSeverity() {
        return this.severity;
    }

    @Override
    @Nullable
    public String getSeverityText() {
        return this.severityText;
    }

    @Override
    public Body getBody() {
        return this.body;
    }

    @Override
    public Attributes getAttributes() {
        return this.attributes;
    }

    @Override
    public int getTotalAttributeCount() {
        return this.totalAttributeCount;
    }

    public String toString() {
        return "TestLogRecordData{resource=" + this.resource + ", instrumentationScopeInfo=" + this.instrumentationScopeInfo + ", timestampEpochNanos=" + this.timestampEpochNanos + ", observedTimestampEpochNanos=" + this.observedTimestampEpochNanos + ", spanContext=" + this.spanContext + ", severity=" + (Object)((Object)this.severity) + ", severityText=" + this.severityText + ", body=" + this.body + ", attributes=" + this.attributes + ", totalAttributeCount=" + this.totalAttributeCount + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof TestLogRecordData) {
            TestLogRecordData that = (TestLogRecordData)o;
            return this.resource.equals(that.getResource()) && this.instrumentationScopeInfo.equals(that.getInstrumentationScopeInfo()) && this.timestampEpochNanos == that.getTimestampEpochNanos() && this.observedTimestampEpochNanos == that.getObservedTimestampEpochNanos() && this.spanContext.equals(that.getSpanContext()) && this.severity.equals((Object)that.getSeverity()) && (this.severityText == null ? that.getSeverityText() == null : this.severityText.equals(that.getSeverityText())) && this.body.equals(that.getBody()) && this.attributes.equals(that.getAttributes()) && this.totalAttributeCount == that.getTotalAttributeCount();
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.resource.hashCode();
        h$ *= 1000003;
        h$ ^= this.instrumentationScopeInfo.hashCode();
        h$ *= 1000003;
        h$ ^= (int)(this.timestampEpochNanos >>> 32 ^ this.timestampEpochNanos);
        h$ *= 1000003;
        h$ ^= (int)(this.observedTimestampEpochNanos >>> 32 ^ this.observedTimestampEpochNanos);
        h$ *= 1000003;
        h$ ^= this.spanContext.hashCode();
        h$ *= 1000003;
        h$ ^= this.severity.hashCode();
        h$ *= 1000003;
        h$ ^= this.severityText == null ? 0 : this.severityText.hashCode();
        h$ *= 1000003;
        h$ ^= this.body.hashCode();
        h$ *= 1000003;
        h$ ^= this.attributes.hashCode();
        h$ *= 1000003;
        return h$ ^= this.totalAttributeCount;
    }

    static final class Builder
    extends TestLogRecordData.Builder {
        private Resource resource;
        private InstrumentationScopeInfo instrumentationScopeInfo;
        private long timestampEpochNanos;
        private long observedTimestampEpochNanos;
        private SpanContext spanContext;
        private Severity severity;
        private String severityText;
        private Body body;
        private Attributes attributes;
        private int totalAttributeCount;
        private byte set$0;

        Builder() {
        }

        @Override
        public TestLogRecordData.Builder setResource(Resource resource) {
            if (resource == null) {
                throw new NullPointerException("Null resource");
            }
            this.resource = resource;
            return this;
        }

        @Override
        public TestLogRecordData.Builder setInstrumentationScopeInfo(InstrumentationScopeInfo instrumentationScopeInfo) {
            if (instrumentationScopeInfo == null) {
                throw new NullPointerException("Null instrumentationScopeInfo");
            }
            this.instrumentationScopeInfo = instrumentationScopeInfo;
            return this;
        }

        @Override
        TestLogRecordData.Builder setTimestampEpochNanos(long timestampEpochNanos) {
            this.timestampEpochNanos = timestampEpochNanos;
            this.set$0 = (byte)(this.set$0 | 1);
            return this;
        }

        @Override
        TestLogRecordData.Builder setObservedTimestampEpochNanos(long observedTimestampEpochNanos) {
            this.observedTimestampEpochNanos = observedTimestampEpochNanos;
            this.set$0 = (byte)(this.set$0 | 2);
            return this;
        }

        @Override
        public TestLogRecordData.Builder setSpanContext(SpanContext spanContext) {
            if (spanContext == null) {
                throw new NullPointerException("Null spanContext");
            }
            this.spanContext = spanContext;
            return this;
        }

        @Override
        public TestLogRecordData.Builder setSeverity(Severity severity) {
            if (severity == null) {
                throw new NullPointerException("Null severity");
            }
            this.severity = severity;
            return this;
        }

        @Override
        public TestLogRecordData.Builder setSeverityText(String severityText) {
            this.severityText = severityText;
            return this;
        }

        @Override
        TestLogRecordData.Builder setBody(Body body) {
            if (body == null) {
                throw new NullPointerException("Null body");
            }
            this.body = body;
            return this;
        }

        @Override
        public TestLogRecordData.Builder setAttributes(Attributes attributes) {
            if (attributes == null) {
                throw new NullPointerException("Null attributes");
            }
            this.attributes = attributes;
            return this;
        }

        @Override
        public TestLogRecordData.Builder setTotalAttributeCount(int totalAttributeCount) {
            this.totalAttributeCount = totalAttributeCount;
            this.set$0 = (byte)(this.set$0 | 4);
            return this;
        }

        @Override
        TestLogRecordData autoBuild() {
            if (this.set$0 != 7 || this.resource == null || this.instrumentationScopeInfo == null || this.spanContext == null || this.severity == null || this.body == null || this.attributes == null) {
                StringBuilder missing = new StringBuilder();
                if (this.resource == null) {
                    missing.append(" resource");
                }
                if (this.instrumentationScopeInfo == null) {
                    missing.append(" instrumentationScopeInfo");
                }
                if ((this.set$0 & 1) == 0) {
                    missing.append(" timestampEpochNanos");
                }
                if ((this.set$0 & 2) == 0) {
                    missing.append(" observedTimestampEpochNanos");
                }
                if (this.spanContext == null) {
                    missing.append(" spanContext");
                }
                if (this.severity == null) {
                    missing.append(" severity");
                }
                if (this.body == null) {
                    missing.append(" body");
                }
                if (this.attributes == null) {
                    missing.append(" attributes");
                }
                if ((this.set$0 & 4) == 0) {
                    missing.append(" totalAttributeCount");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_TestLogRecordData(this.resource, this.instrumentationScopeInfo, this.timestampEpochNanos, this.observedTimestampEpochNanos, this.spanContext, this.severity, this.severityText, this.body, this.attributes, this.totalAttributeCount);
        }
    }
}

