/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.testing.assertj;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.logs.Severity;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import io.opentelemetry.sdk.logs.data.LogRecordData;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.testing.assertj.AssertUtil;
import io.opentelemetry.sdk.testing.assertj.AttributeAssertion;
import io.opentelemetry.sdk.testing.assertj.AttributesAssert;
import io.opentelemetry.sdk.testing.assertj.OpenTelemetryAssertions;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.assertj.core.api.AbstractAssert;

public final class LogRecordDataAssert
extends AbstractAssert<LogRecordDataAssert, LogRecordData> {
    LogRecordDataAssert(@Nullable LogRecordData actual) {
        super((Object)actual, LogRecordDataAssert.class);
    }

    public LogRecordDataAssert hasResource(Resource resource) {
        this.isNotNull();
        if (!((LogRecordData)this.actual).getResource().equals(resource)) {
            this.failWithActualExpectedAndMessage(this.actual, "resource: " + resource, "Expected log to have resource <%s> but found <%s>", new Object[]{resource, ((LogRecordData)this.actual).getResource()});
        }
        return this;
    }

    public LogRecordDataAssert hasInstrumentationScope(InstrumentationScopeInfo instrumentationScopeInfo) {
        this.isNotNull();
        if (!((LogRecordData)this.actual).getInstrumentationScopeInfo().equals(instrumentationScopeInfo)) {
            this.failWithActualExpectedAndMessage(this.actual, "instrumentation scope: " + instrumentationScopeInfo, "Expected log to have scope <%s> but found <%s>", new Object[]{instrumentationScopeInfo, ((LogRecordData)this.actual).getInstrumentationScopeInfo()});
        }
        return this;
    }

    public LogRecordDataAssert hasTimestamp(long timestampEpochNanos) {
        this.isNotNull();
        if (((LogRecordData)this.actual).getTimestampEpochNanos() != timestampEpochNanos) {
            this.failWithActualExpectedAndMessage(((LogRecordData)this.actual).getTimestampEpochNanos(), timestampEpochNanos, "Expected log to have timestamp <%s> nanos but was <%s>", new Object[]{timestampEpochNanos, ((LogRecordData)this.actual).getTimestampEpochNanos()});
        }
        return this;
    }

    public LogRecordDataAssert hasObservedTimestamp(long observedEpochNanos) {
        this.isNotNull();
        if (((LogRecordData)this.actual).getObservedTimestampEpochNanos() != observedEpochNanos) {
            this.failWithActualExpectedAndMessage(((LogRecordData)this.actual).getObservedTimestampEpochNanos(), observedEpochNanos, "Expected log to have observed timestamp <%s> nanos but was <%s>", new Object[]{observedEpochNanos, ((LogRecordData)this.actual).getObservedTimestampEpochNanos()});
        }
        return this;
    }

    public LogRecordDataAssert hasSpanContext(SpanContext spanContext) {
        this.isNotNull();
        if (!((LogRecordData)this.actual).getSpanContext().equals(spanContext)) {
            this.failWithActualExpectedAndMessage(((LogRecordData)this.actual).getSpanContext(), spanContext, "Expected log to have span context <%s> nanos but was <%s>", new Object[]{spanContext, ((LogRecordData)this.actual).getSpanContext()});
        }
        return this;
    }

    public LogRecordDataAssert hasSeverity(Severity severity) {
        this.isNotNull();
        if (((LogRecordData)this.actual).getSeverity() != severity) {
            this.failWithActualExpectedAndMessage((Object)((LogRecordData)this.actual).getSeverity(), (Object)severity, "Expected log to have severity <%s> but was <%s>", new Object[]{severity, ((LogRecordData)this.actual).getSeverity()});
        }
        return this;
    }

    public LogRecordDataAssert hasSeverityText(String severityText) {
        this.isNotNull();
        if (!severityText.equals(((LogRecordData)this.actual).getSeverityText())) {
            this.failWithActualExpectedAndMessage(((LogRecordData)this.actual).getSeverityText(), severityText, "Expected log to have severity text <%s> but was <%s>", new Object[]{severityText, ((LogRecordData)this.actual).getSeverityText()});
        }
        return this;
    }

    public LogRecordDataAssert hasBody(String body) {
        this.isNotNull();
        if (!((LogRecordData)this.actual).getBody().asString().equals(body)) {
            this.failWithActualExpectedAndMessage(((LogRecordData)this.actual).getBody(), body, "Expected log to have body <%s> but was <%s>", new Object[]{body, ((LogRecordData)this.actual).getBody().asString()});
        }
        return this;
    }

    public LogRecordDataAssert hasAttributes(Attributes attributes) {
        this.isNotNull();
        if (!this.attributesAreEqual(attributes)) {
            this.failWithActualExpectedAndMessage(((LogRecordData)this.actual).getAttributes(), attributes, "Expected log to have attributes <%s> but was <%s>", new Object[]{attributes, ((LogRecordData)this.actual).getAttributes()});
        }
        return this;
    }

    @SafeVarargs
    public final LogRecordDataAssert hasAttributes(Map.Entry<? extends AttributeKey<?>, ?> ... entries) {
        AttributesBuilder attributesBuilder = Attributes.builder();
        for (Map.Entry<AttributeKey<?>, ?> entry : entries) {
            attributesBuilder.put(entry.getKey(), entry.getValue());
        }
        Attributes attributes = attributesBuilder.build();
        return this.hasAttributes(attributes);
    }

    public LogRecordDataAssert hasAttributesSatisfying(Consumer<Attributes> attributes) {
        this.isNotNull();
        ((AttributesAssert)((Object)OpenTelemetryAssertions.assertThat(((LogRecordData)this.actual).getAttributes()).as("attributes", new Object[0]))).satisfies(new Consumer[]{attributes});
        return this;
    }

    public LogRecordDataAssert hasAttributesSatisfying(AttributeAssertion ... assertions) {
        return this.hasAttributesSatisfying(Arrays.asList(assertions));
    }

    public LogRecordDataAssert hasAttributesSatisfying(Iterable<AttributeAssertion> assertions) {
        AssertUtil.assertAttributes(((LogRecordData)this.actual).getAttributes(), assertions);
        return (LogRecordDataAssert)this.myself;
    }

    public LogRecordDataAssert hasAttributesSatisfyingExactly(AttributeAssertion ... assertions) {
        return this.hasAttributesSatisfyingExactly(Arrays.asList(assertions));
    }

    public LogRecordDataAssert hasAttributesSatisfyingExactly(Iterable<AttributeAssertion> assertions) {
        AssertUtil.assertAttributesExactly(((LogRecordData)this.actual).getAttributes(), assertions);
        return (LogRecordDataAssert)this.myself;
    }

    private boolean attributesAreEqual(Attributes attributes) {
        return ((LogRecordData)this.actual).getAttributes().asMap().equals(attributes.asMap());
    }

    public LogRecordDataAssert hasTotalAttributeCount(int totalAttributeCount) {
        this.isNotNull();
        if (((LogRecordData)this.actual).getTotalAttributeCount() != totalAttributeCount) {
            this.failWithActualExpectedAndMessage(((LogRecordData)this.actual).getTotalAttributeCount(), totalAttributeCount, "Expected log to have recorded <%s> total attributes but did not", new Object[]{totalAttributeCount});
        }
        return this;
    }
}

