/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.autoconfigure;

import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.events.GlobalEventEmitterProvider;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.OpenTelemetrySdkBuilder;
import io.opentelemetry.sdk.autoconfigure.AutoConfiguredOpenTelemetrySdk;
import io.opentelemetry.sdk.autoconfigure.LoggerProviderConfiguration;
import io.opentelemetry.sdk.autoconfigure.MeterProviderConfiguration;
import io.opentelemetry.sdk.autoconfigure.PropagatorConfiguration;
import io.opentelemetry.sdk.autoconfigure.ResourceConfiguration;
import io.opentelemetry.sdk.autoconfigure.SpiUtil;
import io.opentelemetry.sdk.autoconfigure.TracerProviderConfiguration;
import io.opentelemetry.sdk.autoconfigure.spi.AutoConfigurationCustomizer;
import io.opentelemetry.sdk.autoconfigure.spi.AutoConfigurationCustomizerProvider;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigurationException;
import io.opentelemetry.sdk.autoconfigure.spi.internal.DefaultConfigProperties;
import io.opentelemetry.sdk.autoconfigure.spi.traces.SdkTracerProviderConfigurer;
import io.opentelemetry.sdk.logs.SdkLoggerProvider;
import io.opentelemetry.sdk.logs.SdkLoggerProviderBuilder;
import io.opentelemetry.sdk.logs.export.LogRecordExporter;
import io.opentelemetry.sdk.logs.internal.SdkEventEmitterProvider;
import io.opentelemetry.sdk.metrics.SdkMeterProvider;
import io.opentelemetry.sdk.metrics.SdkMeterProviderBuilder;
import io.opentelemetry.sdk.metrics.export.MetricExporter;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.SdkTracerProvider;
import io.opentelemetry.sdk.trace.SdkTracerProviderBuilder;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import io.opentelemetry.sdk.trace.samplers.Sampler;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public final class AutoConfiguredOpenTelemetrySdkBuilder
implements AutoConfigurationCustomizer {
    private static final Logger logger = Logger.getLogger(AutoConfiguredOpenTelemetrySdkBuilder.class.getName());
    @Nullable
    private ConfigProperties config;
    private BiFunction<SdkTracerProviderBuilder, ConfigProperties, SdkTracerProviderBuilder> tracerProviderCustomizer = (a, unused) -> a;
    private BiFunction<? super TextMapPropagator, ConfigProperties, ? extends TextMapPropagator> propagatorCustomizer = (a, unused) -> a;
    private BiFunction<? super SpanExporter, ConfigProperties, ? extends SpanExporter> spanExporterCustomizer = (a, unused) -> a;
    private BiFunction<? super Sampler, ConfigProperties, ? extends Sampler> samplerCustomizer = (a, unused) -> a;
    private BiFunction<SdkMeterProviderBuilder, ConfigProperties, SdkMeterProviderBuilder> meterProviderCustomizer = (a, unused) -> a;
    private BiFunction<? super MetricExporter, ConfigProperties, ? extends MetricExporter> metricExporterCustomizer = (a, unused) -> a;
    private BiFunction<SdkLoggerProviderBuilder, ConfigProperties, SdkLoggerProviderBuilder> loggerProviderCustomizer = (a, unused) -> a;
    private BiFunction<? super LogRecordExporter, ConfigProperties, ? extends LogRecordExporter> logRecordExporterCustomizer = (a, unused) -> a;
    private BiFunction<? super Resource, ConfigProperties, ? extends Resource> resourceCustomizer = (a, unused) -> a;
    private Supplier<Map<String, String>> propertiesSupplier = Collections::emptyMap;
    private final List<Function<ConfigProperties, Map<String, String>>> propertiesCustomizers = new ArrayList<Function<ConfigProperties, Map<String, String>>>();
    private ClassLoader serviceClassLoader = AutoConfiguredOpenTelemetrySdkBuilder.class.getClassLoader();
    private boolean registerShutdownHook = true;
    private boolean setResultAsGlobal = true;
    private boolean customized;

    AutoConfiguredOpenTelemetrySdkBuilder() {
    }

    AutoConfiguredOpenTelemetrySdkBuilder setConfig(ConfigProperties config) {
        Objects.requireNonNull(config, "config");
        this.config = config;
        return this;
    }

    @Override
    public AutoConfiguredOpenTelemetrySdkBuilder addTracerProviderCustomizer(BiFunction<SdkTracerProviderBuilder, ConfigProperties, SdkTracerProviderBuilder> tracerProviderCustomizer) {
        Objects.requireNonNull(tracerProviderCustomizer, "tracerProviderCustomizer");
        this.tracerProviderCustomizer = AutoConfiguredOpenTelemetrySdkBuilder.mergeCustomizer(this.tracerProviderCustomizer, tracerProviderCustomizer);
        return this;
    }

    @Override
    public AutoConfiguredOpenTelemetrySdkBuilder addPropagatorCustomizer(BiFunction<? super TextMapPropagator, ConfigProperties, ? extends TextMapPropagator> propagatorCustomizer) {
        Objects.requireNonNull(propagatorCustomizer, "propagatorCustomizer");
        this.propagatorCustomizer = AutoConfiguredOpenTelemetrySdkBuilder.mergeCustomizer(this.propagatorCustomizer, propagatorCustomizer);
        return this;
    }

    @Override
    public AutoConfiguredOpenTelemetrySdkBuilder addResourceCustomizer(BiFunction<? super Resource, ConfigProperties, ? extends Resource> resourceCustomizer) {
        Objects.requireNonNull(resourceCustomizer, "resourceCustomizer");
        this.resourceCustomizer = AutoConfiguredOpenTelemetrySdkBuilder.mergeCustomizer(this.resourceCustomizer, resourceCustomizer);
        return this;
    }

    @Override
    public AutoConfiguredOpenTelemetrySdkBuilder addSamplerCustomizer(BiFunction<? super Sampler, ConfigProperties, ? extends Sampler> samplerCustomizer) {
        Objects.requireNonNull(samplerCustomizer, "samplerCustomizer");
        this.samplerCustomizer = AutoConfiguredOpenTelemetrySdkBuilder.mergeCustomizer(this.samplerCustomizer, samplerCustomizer);
        return this;
    }

    @Override
    public AutoConfiguredOpenTelemetrySdkBuilder addSpanExporterCustomizer(BiFunction<? super SpanExporter, ConfigProperties, ? extends SpanExporter> spanExporterCustomizer) {
        Objects.requireNonNull(spanExporterCustomizer, "spanExporterCustomizer");
        this.spanExporterCustomizer = AutoConfiguredOpenTelemetrySdkBuilder.mergeCustomizer(this.spanExporterCustomizer, spanExporterCustomizer);
        return this;
    }

    @Override
    public AutoConfiguredOpenTelemetrySdkBuilder addPropertiesSupplier(Supplier<Map<String, String>> propertiesSupplier) {
        Objects.requireNonNull(propertiesSupplier, "propertiesSupplier");
        this.propertiesSupplier = AutoConfiguredOpenTelemetrySdkBuilder.mergeProperties(this.propertiesSupplier, propertiesSupplier);
        return this;
    }

    @Override
    public AutoConfiguredOpenTelemetrySdkBuilder addPropertiesCustomizer(Function<ConfigProperties, Map<String, String>> propertiesCustomizer) {
        Objects.requireNonNull(propertiesCustomizer, "propertiesCustomizer");
        this.propertiesCustomizers.add(propertiesCustomizer);
        return this;
    }

    @Override
    public AutoConfiguredOpenTelemetrySdkBuilder addMeterProviderCustomizer(BiFunction<SdkMeterProviderBuilder, ConfigProperties, SdkMeterProviderBuilder> meterProviderCustomizer) {
        Objects.requireNonNull(meterProviderCustomizer, "meterProviderCustomizer");
        this.meterProviderCustomizer = AutoConfiguredOpenTelemetrySdkBuilder.mergeCustomizer(this.meterProviderCustomizer, meterProviderCustomizer);
        return this;
    }

    @Override
    public AutoConfiguredOpenTelemetrySdkBuilder addMetricExporterCustomizer(BiFunction<? super MetricExporter, ConfigProperties, ? extends MetricExporter> metricExporterCustomizer) {
        Objects.requireNonNull(metricExporterCustomizer, "metricExporterCustomizer");
        this.metricExporterCustomizer = AutoConfiguredOpenTelemetrySdkBuilder.mergeCustomizer(this.metricExporterCustomizer, metricExporterCustomizer);
        return this;
    }

    @Override
    public AutoConfiguredOpenTelemetrySdkBuilder addLoggerProviderCustomizer(BiFunction<SdkLoggerProviderBuilder, ConfigProperties, SdkLoggerProviderBuilder> loggerProviderCustomizer) {
        Objects.requireNonNull(loggerProviderCustomizer, "loggerProviderCustomizer");
        this.loggerProviderCustomizer = AutoConfiguredOpenTelemetrySdkBuilder.mergeCustomizer(this.loggerProviderCustomizer, loggerProviderCustomizer);
        return this;
    }

    @Override
    public AutoConfiguredOpenTelemetrySdkBuilder addLogRecordExporterCustomizer(BiFunction<? super LogRecordExporter, ConfigProperties, ? extends LogRecordExporter> logRecordExporterCustomizer) {
        Objects.requireNonNull(logRecordExporterCustomizer, "logRecordExporterCustomizer");
        this.logRecordExporterCustomizer = AutoConfiguredOpenTelemetrySdkBuilder.mergeCustomizer(this.logRecordExporterCustomizer, logRecordExporterCustomizer);
        return this;
    }

    public AutoConfiguredOpenTelemetrySdkBuilder registerShutdownHook(boolean registerShutdownHook) {
        this.registerShutdownHook = registerShutdownHook;
        return this;
    }

    public AutoConfiguredOpenTelemetrySdkBuilder setResultAsGlobal(boolean setResultAsGlobal) {
        this.setResultAsGlobal = setResultAsGlobal;
        return this;
    }

    public AutoConfiguredOpenTelemetrySdkBuilder setServiceClassLoader(ClassLoader serviceClassLoader) {
        Objects.requireNonNull(serviceClassLoader, "serviceClassLoader");
        this.serviceClassLoader = serviceClassLoader;
        return this;
    }

    public AutoConfiguredOpenTelemetrySdk build() {
        if (!this.customized) {
            this.customized = true;
            this.mergeSdkTracerProviderConfigurer();
            for (AutoConfigurationCustomizerProvider customizer : SpiUtil.loadOrdered(AutoConfigurationCustomizerProvider.class, this.serviceClassLoader)) {
                customizer.customize(this);
            }
        }
        ConfigProperties config = this.getConfig();
        Resource resource = ResourceConfiguration.configureResource(config, this.serviceClassLoader, this.resourceCustomizer);
        ArrayList<Closeable> closeables = new ArrayList<Closeable>();
        try {
            boolean sdkEnabled;
            OpenTelemetrySdk openTelemetrySdk = OpenTelemetrySdk.builder().build();
            boolean bl = sdkEnabled = !config.getBoolean("otel.sdk.disabled", false);
            if (sdkEnabled) {
                SdkMeterProviderBuilder meterProviderBuilder = SdkMeterProvider.builder();
                meterProviderBuilder.setResource(resource);
                MeterProviderConfiguration.configureMeterProvider(meterProviderBuilder, config, this.serviceClassLoader, this.metricExporterCustomizer, closeables);
                meterProviderBuilder = this.meterProviderCustomizer.apply(meterProviderBuilder, config);
                SdkMeterProvider meterProvider = meterProviderBuilder.build();
                closeables.add(meterProvider);
                SdkTracerProviderBuilder tracerProviderBuilder = SdkTracerProvider.builder();
                tracerProviderBuilder.setResource(resource);
                TracerProviderConfiguration.configureTracerProvider(tracerProviderBuilder, config, this.serviceClassLoader, meterProvider, this.spanExporterCustomizer, this.samplerCustomizer, closeables);
                tracerProviderBuilder = this.tracerProviderCustomizer.apply(tracerProviderBuilder, config);
                SdkTracerProvider tracerProvider = tracerProviderBuilder.build();
                closeables.add(tracerProvider);
                SdkLoggerProviderBuilder loggerProviderBuilder = SdkLoggerProvider.builder();
                loggerProviderBuilder.setResource(resource);
                LoggerProviderConfiguration.configureLoggerProvider(loggerProviderBuilder, config, this.serviceClassLoader, meterProvider, this.logRecordExporterCustomizer, closeables);
                loggerProviderBuilder = this.loggerProviderCustomizer.apply(loggerProviderBuilder, config);
                SdkLoggerProvider loggerProvider = loggerProviderBuilder.build();
                closeables.add(loggerProvider);
                ContextPropagators propagators = PropagatorConfiguration.configurePropagators(config, this.serviceClassLoader, this.propagatorCustomizer);
                OpenTelemetrySdkBuilder sdkBuilder = OpenTelemetrySdk.builder().setTracerProvider(tracerProvider).setLoggerProvider(loggerProvider).setMeterProvider(meterProvider).setPropagators(propagators);
                openTelemetrySdk = sdkBuilder.build();
            }
            if (this.registerShutdownHook) {
                Runtime.getRuntime().addShutdownHook(this.shutdownHook(openTelemetrySdk));
            }
            if (this.setResultAsGlobal) {
                GlobalOpenTelemetry.set(openTelemetrySdk);
                GlobalEventEmitterProvider.set(SdkEventEmitterProvider.create(openTelemetrySdk.getSdkLoggerProvider()));
                logger.log(Level.FINE, "Global OpenTelemetry set to {0} by autoconfiguration", openTelemetrySdk);
            }
            return AutoConfiguredOpenTelemetrySdk.create(openTelemetrySdk, resource, config);
        }
        catch (RuntimeException e) {
            logger.info("Error encountered during autoconfiguration. Closing partially configured components.");
            for (Closeable closeable : closeables) {
                try {
                    logger.fine("Closing " + closeable.getClass().getName());
                    closeable.close();
                }
                catch (IOException ex) {
                    logger.warning("Error closing " + closeable.getClass().getName() + ": " + ex.getMessage());
                }
            }
            if (e instanceof ConfigurationException) {
                throw e;
            }
            throw new ConfigurationException("Unexpected configuration error", e);
        }
    }

    private void mergeSdkTracerProviderConfigurer() {
        for (SdkTracerProviderConfigurer configurer : ServiceLoader.load(SdkTracerProviderConfigurer.class, this.serviceClassLoader)) {
            this.addTracerProviderCustomizer((builder, config) -> {
                configurer.configure((SdkTracerProviderBuilder)builder, (ConfigProperties)config);
                return builder;
            });
        }
    }

    private ConfigProperties getConfig() {
        ConfigProperties config = this.config;
        if (config == null) {
            config = this.computeConfigProperties();
        }
        return config;
    }

    private ConfigProperties computeConfigProperties() {
        DefaultConfigProperties properties = DefaultConfigProperties.create(this.propertiesSupplier.get());
        for (Function<ConfigProperties, Map<String, String>> customizer : this.propertiesCustomizers) {
            Map<String, String> overrides = customizer.apply(properties);
            properties = properties.withOverrides(overrides);
        }
        return properties;
    }

    Thread shutdownHook(OpenTelemetrySdk sdk) {
        return new Thread(sdk::close);
    }

    private static <I, O1, O2> BiFunction<I, ConfigProperties, O2> mergeCustomizer(BiFunction<? super I, ConfigProperties, ? extends O1> first, BiFunction<? super O1, ConfigProperties, ? extends O2> second) {
        return (configured, config) -> {
            Object firstResult = first.apply((Object)configured, (ConfigProperties)config);
            return second.apply((Object)firstResult, (ConfigProperties)config);
        };
    }

    private static Supplier<Map<String, String>> mergeProperties(Supplier<Map<String, String>> first, Supplier<Map<String, String>> second) {
        return () -> {
            HashMap merged = new HashMap();
            merged.putAll((Map)first.get());
            merged.putAll((Map)second.get());
            return merged;
        };
    }
}

