/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.prometheus;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import io.opentelemetry.exporter.prometheus.PrometheusHttpServerBuilder;
import io.opentelemetry.exporter.prometheus.Serializer;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.internal.DaemonThreadFactory;
import io.opentelemetry.sdk.metrics.InstrumentType;
import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.export.CollectionRegistration;
import io.opentelemetry.sdk.metrics.export.MetricReader;
import io.opentelemetry.sdk.metrics.internal.export.MetricProducer;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.InetSocketAddress;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.zip.GZIPOutputStream;
import javax.annotation.Nullable;

public final class PrometheusHttpServer
implements MetricReader {
    private static final DaemonThreadFactory THREAD_FACTORY = new DaemonThreadFactory("prometheus-http");
    private static final Logger LOGGER = Logger.getLogger(PrometheusHttpServer.class.getName());
    private final HttpServer server;
    private final ExecutorService executor;
    private volatile MetricProducer metricProducer = MetricProducer.noop();

    public static PrometheusHttpServer create() {
        return PrometheusHttpServer.builder().build();
    }

    public static PrometheusHttpServerBuilder builder() {
        return new PrometheusHttpServerBuilder();
    }

    PrometheusHttpServer(String host, int port, ExecutorService executor) {
        try {
            this.server = HttpServer.create(new InetSocketAddress(host, port), 3);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Could not create Prometheus HTTP server", e);
        }
        MetricsHandler metricsHandler = new MetricsHandler(() -> this.getMetricProducer().collectAllMetrics());
        this.server.createContext("/", metricsHandler);
        this.server.createContext("/metrics", metricsHandler);
        this.server.createContext("/-/healthy", HealthHandler.INSTANCE);
        this.executor = executor;
        this.server.setExecutor(executor);
        this.start();
    }

    private MetricProducer getMetricProducer() {
        return this.metricProducer;
    }

    private void start() {
        if (Thread.currentThread().isDaemon()) {
            this.server.start();
            return;
        }
        Thread thread2 = THREAD_FACTORY.newThread(this.server::start);
        thread2.start();
        try {
            thread2.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void register(CollectionRegistration registration) {
        this.metricProducer = MetricProducer.asMetricProducer(registration);
    }

    @Override
    public AggregationTemporality getAggregationTemporality(InstrumentType instrumentType) {
        return AggregationTemporality.CUMULATIVE;
    }

    @Override
    public CompletableResultCode forceFlush() {
        return CompletableResultCode.ofSuccess();
    }

    @Override
    public CompletableResultCode shutdown() {
        CompletableResultCode result = new CompletableResultCode();
        Thread thread2 = THREAD_FACTORY.newThread(() -> {
            try {
                this.server.stop(10);
                this.executor.shutdownNow();
            }
            catch (Throwable t) {
                result.fail();
                return;
            }
            result.succeed();
        });
        thread2.start();
        return result;
    }

    @Override
    public void close() {
        this.shutdown().join(10L, TimeUnit.SECONDS);
    }

    public String toString() {
        return "PrometheusHttpServer{address=" + this.server.getAddress() + "}";
    }

    InetSocketAddress getAddress() {
        return this.server.getAddress();
    }

    private static boolean shouldUseCompression(HttpExchange exchange) {
        Object encodingHeaders = exchange.getRequestHeaders().get("Accept-Encoding");
        if (encodingHeaders == null) {
            return false;
        }
        Iterator iterator2 = encodingHeaders.iterator();
        while (iterator2.hasNext()) {
            String[] encodings;
            String encodingHeader = (String)iterator2.next();
            for (String encoding : encodings = encodingHeader.split(",")) {
                if (!encoding.trim().equalsIgnoreCase("gzip")) continue;
                return true;
            }
        }
        return false;
    }

    private static Set<String> parseQuery(@Nullable String query) throws IOException {
        String[] pairs;
        if (query == null) {
            return Collections.emptySet();
        }
        HashSet<String> names = new HashSet<String>();
        for (String pair : pairs = query.split("&")) {
            int idx = pair.indexOf("=");
            if (idx == -1 || !URLDecoder.decode(pair.substring(0, idx), "UTF-8").equals("name[]")) continue;
            names.add(URLDecoder.decode(pair.substring(idx + 1), "UTF-8"));
        }
        return names;
    }

    private static class MetricsHandler
    implements HttpHandler {
        private final Set<String> allConflictHeaderNames = Collections.newSetFromMap(new ConcurrentHashMap());
        private final Supplier<Collection<MetricData>> metricsSupplier;

        private MetricsHandler(Supplier<Collection<MetricData>> metricsSupplier) {
            this.metricsSupplier = metricsSupplier;
        }

        @Override
        public void handle(HttpExchange exchange) throws IOException {
            Collection<MetricData> metrics = this.metricsSupplier.get();
            Set requestedNames = PrometheusHttpServer.parseQuery(exchange.getRequestURI().getRawQuery());
            Predicate<String> filter = requestedNames.isEmpty() ? unused -> true : requestedNames::contains;
            Serializer serializer = Serializer.create(exchange.getRequestHeaders().getFirst("Accept"), filter);
            exchange.getResponseHeaders().set("Content-Type", serializer.contentType());
            boolean compress = PrometheusHttpServer.shouldUseCompression(exchange);
            if (compress) {
                exchange.getResponseHeaders().set("Content-Encoding", "gzip");
            }
            if (exchange.getRequestMethod().equals("HEAD")) {
                exchange.sendResponseHeaders(200, -1L);
            } else {
                exchange.sendResponseHeaders(200, 0L);
                OutputStream out = compress ? new GZIPOutputStream(exchange.getResponseBody()) : exchange.getResponseBody();
                Set<String> conflictHeaderNames = serializer.write(metrics, out);
                conflictHeaderNames.removeAll(this.allConflictHeaderNames);
                if (conflictHeaderNames.size() > 0 && LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, "Metric conflict(s) detected. Multiple metrics with same name but different type: " + conflictHeaderNames.stream().collect(Collectors.joining(",", "[", "]")));
                    this.allConflictHeaderNames.addAll(conflictHeaderNames);
                }
            }
            exchange.close();
        }
    }

    private static enum HealthHandler implements HttpHandler
    {
        INSTANCE;

        private static final byte[] RESPONSE;
        private static final String CONTENT_LENGTH_VALUE;

        @Override
        public void handle(HttpExchange exchange) throws IOException {
            exchange.getResponseHeaders().set("Content-Length", CONTENT_LENGTH_VALUE);
            if (exchange.getRequestMethod().equals("HEAD")) {
                exchange.sendResponseHeaders(200, -1L);
            } else {
                exchange.sendResponseHeaders(200, RESPONSE.length);
                exchange.getResponseBody().write(RESPONSE);
            }
            exchange.close();
        }

        static {
            RESPONSE = "Exporter is Healthy.".getBytes(StandardCharsets.UTF_8);
            CONTENT_LENGTH_VALUE = String.valueOf(RESPONSE.length);
        }
    }
}

