/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.internal.otlp.metrics;

import io.opentelemetry.exporter.internal.marshal.Marshaler;
import io.opentelemetry.exporter.internal.marshal.MarshalerUtil;
import io.opentelemetry.exporter.internal.marshal.MarshalerWithSize;
import io.opentelemetry.exporter.internal.marshal.ProtoFieldInfo;
import io.opentelemetry.exporter.internal.marshal.Serializer;
import io.opentelemetry.exporter.internal.otlp.KeyValueMarshaler;
import io.opentelemetry.exporter.internal.otlp.metrics.ExemplarMarshaler;
import io.opentelemetry.exporter.internal.otlp.metrics.ExponentialHistogramBucketsMarshaler;
import io.opentelemetry.proto.metrics.v1.internal.ExponentialHistogramDataPoint;
import io.opentelemetry.sdk.metrics.data.ExponentialHistogramPointData;
import java.io.IOException;
import java.util.Collection;

public class ExponentialHistogramDataPointMarshaler
extends MarshalerWithSize {
    private final long startTimeUnixNano;
    private final long timeUnixNano;
    private final int scale;
    private final long count;
    private final long zeroCount;
    private final double sum;
    private final boolean hasMin;
    private final double min;
    private final boolean hasMax;
    private final double max;
    private final ExponentialHistogramBucketsMarshaler positiveBuckets;
    private final ExponentialHistogramBucketsMarshaler negativeBuckets;
    private final ExemplarMarshaler[] exemplars;
    private final KeyValueMarshaler[] attributes;

    private ExponentialHistogramDataPointMarshaler(long startEpochNanos, long epochNanos, int scale, long count, double sum, boolean hasMin, double min2, boolean hasMax, double max, long zeroCount, ExponentialHistogramBucketsMarshaler positiveBuckets, ExponentialHistogramBucketsMarshaler negativeBuckets, KeyValueMarshaler[] attributeMarshalers, ExemplarMarshaler[] exemplarMarshalers) {
        super(ExponentialHistogramDataPointMarshaler.calculateSize(startEpochNanos, epochNanos, scale, count, sum, hasMin, min2, hasMax, max, zeroCount, positiveBuckets, negativeBuckets, exemplarMarshalers, attributeMarshalers));
        this.startTimeUnixNano = startEpochNanos;
        this.timeUnixNano = epochNanos;
        this.scale = scale;
        this.sum = sum;
        this.hasMin = hasMin;
        this.min = min2;
        this.hasMax = hasMax;
        this.max = max;
        this.count = count;
        this.zeroCount = zeroCount;
        this.positiveBuckets = positiveBuckets;
        this.negativeBuckets = negativeBuckets;
        this.attributes = attributeMarshalers;
        this.exemplars = exemplarMarshalers;
    }

    static ExponentialHistogramDataPointMarshaler create(ExponentialHistogramPointData point) {
        KeyValueMarshaler[] attributes = KeyValueMarshaler.createRepeated(point.getAttributes());
        ExemplarMarshaler[] exemplars = ExemplarMarshaler.createRepeated(point.getExemplars());
        ExponentialHistogramBucketsMarshaler positiveBuckets = ExponentialHistogramBucketsMarshaler.create(point.getPositiveBuckets());
        ExponentialHistogramBucketsMarshaler negativeBuckets = ExponentialHistogramBucketsMarshaler.create(point.getNegativeBuckets());
        return new ExponentialHistogramDataPointMarshaler(point.getStartEpochNanos(), point.getEpochNanos(), point.getScale(), point.getCount(), point.getSum(), point.hasMin(), point.getMin(), point.hasMax(), point.getMax(), point.getZeroCount(), positiveBuckets, negativeBuckets, attributes, exemplars);
    }

    static ExponentialHistogramDataPointMarshaler[] createRepeated(Collection<ExponentialHistogramPointData> points) {
        ExponentialHistogramDataPointMarshaler[] marshalers = new ExponentialHistogramDataPointMarshaler[points.size()];
        int index = 0;
        for (ExponentialHistogramPointData point : points) {
            marshalers[index++] = ExponentialHistogramDataPointMarshaler.create(point);
        }
        return marshalers;
    }

    @Override
    protected void writeTo(Serializer output) throws IOException {
        output.serializeFixed64(ExponentialHistogramDataPoint.START_TIME_UNIX_NANO, this.startTimeUnixNano);
        output.serializeFixed64(ExponentialHistogramDataPoint.TIME_UNIX_NANO, this.timeUnixNano);
        output.serializeFixed64(ExponentialHistogramDataPoint.COUNT, this.count);
        output.serializeDouble(ExponentialHistogramDataPoint.SUM, this.sum);
        if (this.hasMin) {
            output.serializeDoubleOptional(ExponentialHistogramDataPoint.MIN, this.min);
        }
        if (this.hasMax) {
            output.serializeDoubleOptional(ExponentialHistogramDataPoint.MAX, this.max);
        }
        output.serializeSInt32(ExponentialHistogramDataPoint.SCALE, this.scale);
        output.serializeFixed64(ExponentialHistogramDataPoint.ZERO_COUNT, this.zeroCount);
        output.serializeMessage(ExponentialHistogramDataPoint.POSITIVE, this.positiveBuckets);
        output.serializeMessage(ExponentialHistogramDataPoint.NEGATIVE, this.negativeBuckets);
        output.serializeRepeatedMessage(ExponentialHistogramDataPoint.EXEMPLARS, this.exemplars);
        output.serializeRepeatedMessage(ExponentialHistogramDataPoint.ATTRIBUTES, this.attributes);
    }

    private static int calculateSize(long startTimeUnixNano, long timeUnixNano, int scale, long count, double sum, boolean hasMin, double min2, boolean hasMax, double max, long zeroCount, ExponentialHistogramBucketsMarshaler positiveBucketMarshaler, ExponentialHistogramBucketsMarshaler negativeBucketMarshaler, ExemplarMarshaler[] exemplarMarshalers, KeyValueMarshaler[] attributesMarshalers) {
        int size = 0;
        size += MarshalerUtil.sizeFixed64(ExponentialHistogramDataPoint.START_TIME_UNIX_NANO, startTimeUnixNano);
        size += MarshalerUtil.sizeFixed64(ExponentialHistogramDataPoint.TIME_UNIX_NANO, timeUnixNano);
        size += MarshalerUtil.sizeSInt32(ExponentialHistogramDataPoint.SCALE, scale);
        size += MarshalerUtil.sizeFixed64(ExponentialHistogramDataPoint.COUNT, count);
        size += MarshalerUtil.sizeDouble(ExponentialHistogramDataPoint.SUM, sum);
        if (hasMin) {
            size += MarshalerUtil.sizeDoubleOptional(ExponentialHistogramDataPoint.MIN, min2);
        }
        if (hasMax) {
            size += MarshalerUtil.sizeDoubleOptional(ExponentialHistogramDataPoint.MAX, max);
        }
        size += MarshalerUtil.sizeFixed64(ExponentialHistogramDataPoint.ZERO_COUNT, zeroCount);
        size += MarshalerUtil.sizeMessage(ExponentialHistogramDataPoint.POSITIVE, positiveBucketMarshaler);
        size += MarshalerUtil.sizeMessage(ExponentialHistogramDataPoint.NEGATIVE, negativeBucketMarshaler);
        size += MarshalerUtil.sizeRepeatedMessage((ProtoFieldInfo)ExponentialHistogramDataPoint.EXEMPLARS, (Marshaler[])exemplarMarshalers);
        return size += MarshalerUtil.sizeRepeatedMessage((ProtoFieldInfo)ExponentialHistogramDataPoint.ATTRIBUTES, (Marshaler[])attributesMarshalers);
    }
}

