/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.jmxmetrics;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.metrics.DoubleCounter;
import io.opentelemetry.api.metrics.DoubleHistogram;
import io.opentelemetry.api.metrics.DoubleUpDownCounter;
import io.opentelemetry.api.metrics.LongCounter;
import io.opentelemetry.api.metrics.LongHistogram;
import io.opentelemetry.api.metrics.LongUpDownCounter;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.ObservableDoubleMeasurement;
import io.opentelemetry.api.metrics.ObservableLongMeasurement;
import io.opentelemetry.contrib.jmxmetrics.InstrumentDescriptor;
import io.opentelemetry.contrib.jmxmetrics.JmxConfig;
import io.opentelemetry.sdk.autoconfigure.AutoConfiguredOpenTelemetrySdk;
import io.opentelemetry.sdk.autoconfigure.AutoConfiguredOpenTelemetrySdkBuilder;
import io.opentelemetry.sdk.metrics.InstrumentType;
import io.opentelemetry.sdk.metrics.InstrumentValueType;
import io.opentelemetry.sdk.metrics.SdkMeterProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nullable;

public class GroovyMetricEnvironment {
    private final SdkMeterProvider meterProvider;
    private final Meter meter;
    private final Map<Integer, AtomicReference<Consumer<ObservableLongMeasurement>>> longUpdaterRegistry = new ConcurrentHashMap<Integer, AtomicReference<Consumer<ObservableLongMeasurement>>>();
    private final Map<Integer, AtomicReference<Consumer<ObservableDoubleMeasurement>>> doubleUpdaterRegistry = new ConcurrentHashMap<Integer, AtomicReference<Consumer<ObservableDoubleMeasurement>>>();

    public GroovyMetricEnvironment(JmxConfig config, String instrumentationName, String instrumentationVersion) {
        switch (config.metricsExporterType.toLowerCase()) {
            case "otlp": 
            case "prometheus": 
            case "logging": {
                this.meterProvider = ((AutoConfiguredOpenTelemetrySdkBuilder)AutoConfiguredOpenTelemetrySdk.builder().setResultAsGlobal(false).addPropertiesSupplier(() -> {
                    HashMap<String, String> properties = new HashMap<String, String>();
                    properties.put("otel.traces.exporter", "none");
                    config.properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, value) -> {
                        String key = k.toString();
                        if (key.startsWith("otel.") && !key.startsWith("otel.jmx")) {
                            properties.put(key, value.toString());
                        }
                    }));
                    return properties;
                })).build().getOpenTelemetrySdk().getSdkMeterProvider();
                break;
            }
            default: {
                this.meterProvider = SdkMeterProvider.builder().build();
            }
        }
        this.meter = this.meterProvider.meterBuilder(instrumentationName).setInstrumentationVersion(instrumentationVersion).build();
    }

    GroovyMetricEnvironment(SdkMeterProvider meterProvider, String instrumentationName) {
        this.meterProvider = meterProvider;
        this.meter = meterProvider.meterBuilder(instrumentationName).build();
    }

    public GroovyMetricEnvironment(JmxConfig config) {
        this(config, "io.opentelemetry.contrib.jmxmetrics", GroovyMetricEnvironment.class.getPackage().getImplementationVersion());
    }

    public void flush() {
        this.meterProvider.forceFlush().join(10L, TimeUnit.SECONDS);
    }

    protected static Attributes mapToAttributes(@Nullable Map<String, String> labelMap) {
        if (labelMap == null) {
            return Attributes.empty();
        }
        AttributesBuilder attrs = Attributes.builder();
        for (Map.Entry<String, String> kv : labelMap.entrySet()) {
            attrs.put(kv.getKey(), kv.getValue());
        }
        return attrs.build();
    }

    public DoubleCounter getDoubleCounter(String name, String description, String unit) {
        return this.meter.counterBuilder(name).setDescription(description).setUnit(unit).ofDoubles().build();
    }

    public LongCounter getLongCounter(String name, String description, String unit) {
        return this.meter.counterBuilder(name).setDescription(description).setUnit(unit).build();
    }

    public DoubleUpDownCounter getDoubleUpDownCounter(String name, String description, String unit) {
        return this.meter.upDownCounterBuilder(name).setDescription(description).setUnit(unit).ofDoubles().build();
    }

    public LongUpDownCounter getLongUpDownCounter(String name, String description, String unit) {
        return this.meter.upDownCounterBuilder(name).setDescription(description).setUnit(unit).build();
    }

    public DoubleHistogram getDoubleHistogram(String name, String description, String unit) {
        return this.meter.histogramBuilder(name).setDescription(description).setUnit(unit).build();
    }

    public LongHistogram getLongHistogram(String name, String description, String unit) {
        return this.meter.histogramBuilder(name).setDescription(description).setUnit(unit).ofLongs().build();
    }

    public void registerDoubleValueCallback(String name, String description, String unit, Consumer<ObservableDoubleMeasurement> updater) {
        this.meter.gaugeBuilder(name).setDescription(description).setUnit(unit).buildWithCallback(this.proxiedDoubleObserver(name, description, unit, InstrumentType.OBSERVABLE_GAUGE, updater));
    }

    public void registerLongValueCallback(String name, String description, String unit, Consumer<ObservableLongMeasurement> updater) {
        this.meter.gaugeBuilder(name).ofLongs().setDescription(description).setUnit(unit).buildWithCallback(this.proxiedLongObserver(name, description, unit, InstrumentType.OBSERVABLE_GAUGE, updater));
    }

    public void registerDoubleCounterCallback(String name, String description, String unit, Consumer<ObservableDoubleMeasurement> updater) {
        this.meter.counterBuilder(name).ofDoubles().setDescription(description).setUnit(unit).buildWithCallback(this.proxiedDoubleObserver(name, description, unit, InstrumentType.OBSERVABLE_COUNTER, updater));
    }

    public void registerLongCounterCallback(String name, String description, String unit, Consumer<ObservableLongMeasurement> updater) {
        this.meter.counterBuilder(name).setDescription(description).setUnit(unit).buildWithCallback(this.proxiedLongObserver(name, description, unit, InstrumentType.OBSERVABLE_COUNTER, updater));
    }

    public void registerDoubleUpDownCounterCallback(String name, String description, String unit, Consumer<ObservableDoubleMeasurement> updater) {
        this.meter.upDownCounterBuilder(name).ofDoubles().setDescription(description).setUnit(unit).buildWithCallback(this.proxiedDoubleObserver(name, description, unit, InstrumentType.OBSERVABLE_UP_DOWN_COUNTER, updater));
    }

    public void registerLongUpDownCounterCallback(String name, String description, String unit, Consumer<ObservableLongMeasurement> updater) {
        this.meter.upDownCounterBuilder(name).setDescription(description).setUnit(unit).buildWithCallback(this.proxiedLongObserver(name, description, unit, InstrumentType.OBSERVABLE_UP_DOWN_COUNTER, updater));
    }

    private Consumer<ObservableDoubleMeasurement> proxiedDoubleObserver(String name, String description, String unit, InstrumentType instrumentType, Consumer<ObservableDoubleMeasurement> updater) {
        InstrumentDescriptor descriptor = InstrumentDescriptor.create(name, description, unit, instrumentType, InstrumentValueType.DOUBLE);
        this.doubleUpdaterRegistry.putIfAbsent(descriptor.hashCode(), new AtomicReference());
        AtomicReference<Consumer<ObservableDoubleMeasurement>> existingUpdater = this.doubleUpdaterRegistry.get(descriptor.hashCode());
        existingUpdater.set(updater);
        return doubleResult -> {
            Consumer existing = (Consumer)existingUpdater.get();
            existing.accept(doubleResult);
        };
    }

    private Consumer<ObservableLongMeasurement> proxiedLongObserver(String name, String description, String unit, InstrumentType instrumentType, Consumer<ObservableLongMeasurement> updater) {
        InstrumentDescriptor descriptor = InstrumentDescriptor.create(name, description, unit, instrumentType, InstrumentValueType.LONG);
        this.longUpdaterRegistry.putIfAbsent(descriptor.hashCode(), new AtomicReference());
        AtomicReference<Consumer<ObservableLongMeasurement>> existingUpdater = this.longUpdaterRegistry.get(descriptor.hashCode());
        existingUpdater.set(updater);
        return longResult -> {
            Consumer existing = (Consumer)existingUpdater.get();
            existing.accept(longResult);
        };
    }
}

