/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.internal;

import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class InstrumentNameValidator {
    public static final String LOGGER_NAME = "io.opentelemetry.sdk.metrics.internal.InstrumentNameValidator";
    private static final Logger LOGGER = Logger.getLogger("io.opentelemetry.sdk.metrics.internal.InstrumentNameValidator");
    private static final Pattern VALID_INSTRUMENT_NAME_PATTERN = Pattern.compile("([A-Za-z]){1}([A-Za-z0-9\\_\\-\\.]){0,62}");

    public static boolean checkValidInstrumentName(String name) {
        return InstrumentNameValidator.checkValidInstrumentName(name, "");
    }

    public static boolean checkValidInstrumentName(String name, String logSuffix) {
        if (name != null && VALID_INSTRUMENT_NAME_PATTERN.matcher(name).matches()) {
            return true;
        }
        if (LOGGER.isLoggable(Level.WARNING)) {
            LOGGER.log(Level.WARNING, "Instrument name \"" + name + "\" is invalid, returning noop instrument. Instrument names must consist of 63 or fewer characters including alphanumeric, _, ., -, and start with a letter." + logSuffix, (Throwable)((Object)new AssertionError()));
        }
        return false;
    }

    private InstrumentNameValidator() {
    }
}

