/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics;

import io.opentelemetry.api.metrics.BatchCallback;
import io.opentelemetry.api.metrics.DoubleGaugeBuilder;
import io.opentelemetry.api.metrics.DoubleHistogramBuilder;
import io.opentelemetry.api.metrics.LongCounterBuilder;
import io.opentelemetry.api.metrics.LongUpDownCounterBuilder;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.MeterProvider;
import io.opentelemetry.api.metrics.ObservableMeasurement;
import io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import io.opentelemetry.sdk.metrics.SdkDoubleGaugeBuilder;
import io.opentelemetry.sdk.metrics.SdkDoubleHistogram;
import io.opentelemetry.sdk.metrics.SdkLongCounter;
import io.opentelemetry.sdk.metrics.SdkLongUpDownCounter;
import io.opentelemetry.sdk.metrics.SdkObservableInstrument;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.internal.InstrumentNameValidator;
import io.opentelemetry.sdk.metrics.internal.export.RegisteredReader;
import io.opentelemetry.sdk.metrics.internal.state.CallbackRegistration;
import io.opentelemetry.sdk.metrics.internal.state.MeterProviderSharedState;
import io.opentelemetry.sdk.metrics.internal.state.MeterSharedState;
import io.opentelemetry.sdk.metrics.internal.state.SdkObservableMeasurement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

final class SdkMeter
implements Meter {
    private static final Logger logger = Logger.getLogger(SdkMeter.class.getName());
    private static final String NOOP_INSTRUMENT_WARNING = " Returning noop instrument.";
    private static final Meter NOOP_METER = MeterProvider.noop().get("noop");
    private static final String NOOP_INSTRUMENT_NAME = "noop";
    private final InstrumentationScopeInfo instrumentationScopeInfo;
    private final MeterProviderSharedState meterProviderSharedState;
    private final MeterSharedState meterSharedState;

    SdkMeter(MeterProviderSharedState meterProviderSharedState, InstrumentationScopeInfo instrumentationScopeInfo, List<RegisteredReader> registeredReaders) {
        this.instrumentationScopeInfo = instrumentationScopeInfo;
        this.meterProviderSharedState = meterProviderSharedState;
        this.meterSharedState = MeterSharedState.create(instrumentationScopeInfo, registeredReaders);
    }

    InstrumentationScopeInfo getInstrumentationScopeInfo() {
        return this.instrumentationScopeInfo;
    }

    Collection<MetricData> collectAll(RegisteredReader registeredReader, long epochNanos) {
        return this.meterSharedState.collectAll(registeredReader, this.meterProviderSharedState, epochNanos);
    }

    void resetForTest() {
        this.meterSharedState.resetForTest();
    }

    @Override
    public LongCounterBuilder counterBuilder(String name) {
        return !InstrumentNameValidator.checkValidInstrumentName(name, NOOP_INSTRUMENT_WARNING) ? NOOP_METER.counterBuilder(NOOP_INSTRUMENT_NAME) : new SdkLongCounter.SdkLongCounterBuilder(this.meterProviderSharedState, this.meterSharedState, name);
    }

    @Override
    public LongUpDownCounterBuilder upDownCounterBuilder(String name) {
        return !InstrumentNameValidator.checkValidInstrumentName(name, NOOP_INSTRUMENT_WARNING) ? NOOP_METER.upDownCounterBuilder(NOOP_INSTRUMENT_NAME) : new SdkLongUpDownCounter.SdkLongUpDownCounterBuilder(this.meterProviderSharedState, this.meterSharedState, name);
    }

    @Override
    public DoubleHistogramBuilder histogramBuilder(String name) {
        return !InstrumentNameValidator.checkValidInstrumentName(name, NOOP_INSTRUMENT_WARNING) ? NOOP_METER.histogramBuilder(NOOP_INSTRUMENT_NAME) : new SdkDoubleHistogram.SdkDoubleHistogramBuilder(this.meterProviderSharedState, this.meterSharedState, name);
    }

    @Override
    public DoubleGaugeBuilder gaugeBuilder(String name) {
        return !InstrumentNameValidator.checkValidInstrumentName(name, NOOP_INSTRUMENT_WARNING) ? NOOP_METER.gaugeBuilder(NOOP_INSTRUMENT_NAME) : new SdkDoubleGaugeBuilder(this.meterProviderSharedState, this.meterSharedState, name);
    }

    @Override
    public BatchCallback batchCallback(Runnable callback, ObservableMeasurement observableMeasurement, ObservableMeasurement ... additionalMeasurements) {
        HashSet<ObservableMeasurement> measurements = new HashSet<ObservableMeasurement>();
        measurements.add(observableMeasurement);
        Collections.addAll(measurements, additionalMeasurements);
        ArrayList<SdkObservableMeasurement> sdkMeasurements = new ArrayList<SdkObservableMeasurement>();
        for (ObservableMeasurement measurement : measurements) {
            if (!(measurement instanceof SdkObservableMeasurement)) {
                logger.log(Level.WARNING, "batchCallback called with instruments that were not created by the SDK.");
                continue;
            }
            SdkObservableMeasurement sdkMeasurement = (SdkObservableMeasurement)measurement;
            if (!this.meterSharedState.getInstrumentationScopeInfo().equals(sdkMeasurement.getInstrumentationScopeInfo())) {
                logger.log(Level.WARNING, "batchCallback called with instruments that belong to a different Meter.");
                continue;
            }
            sdkMeasurements.add(sdkMeasurement);
        }
        CallbackRegistration callbackRegistration = CallbackRegistration.create(sdkMeasurements, callback);
        this.meterSharedState.registerCallback(callbackRegistration);
        return new SdkObservableInstrument(this.meterSharedState, callbackRegistration);
    }

    public String toString() {
        return "SdkMeter{instrumentationScopeInfo=" + this.instrumentationScopeInfo + "}";
    }
}

