/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.internal.grpc;

import io.grpc.Channel;
import io.grpc.ClientInterceptors;
import io.grpc.Codec;
import io.grpc.ManagedChannel;
import io.grpc.Metadata;
import io.grpc.stub.MetadataUtils;
import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.metrics.MeterProvider;
import io.opentelemetry.exporter.internal.ExporterBuilderUtil;
import io.opentelemetry.exporter.internal.TlsConfigHelper;
import io.opentelemetry.exporter.internal.grpc.GrpcExporter;
import io.opentelemetry.exporter.internal.grpc.MarshalerServiceStub;
import io.opentelemetry.exporter.internal.grpc.OkHttpGrpcExporter;
import io.opentelemetry.exporter.internal.grpc.UpstreamGrpcExporter;
import io.opentelemetry.exporter.internal.marshal.Marshaler;
import io.opentelemetry.exporter.internal.okhttp.OkHttpUtil;
import io.opentelemetry.exporter.internal.retry.RetryInterceptor;
import io.opentelemetry.exporter.internal.retry.RetryPolicy;
import java.net.URI;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import okhttp3.Headers;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;

public class GrpcExporterBuilder<T extends Marshaler> {
    private final String exporterName;
    private final String type;
    private final String grpcEndpointPath;
    private final Supplier<BiFunction<Channel, String, MarshalerServiceStub<T, ?, ?>>> grpcStubFactory;
    private long timeoutNanos;
    private URI endpoint;
    private boolean compressionEnabled = false;
    private final Map<String, String> headers = new HashMap<String, String>();
    private final TlsConfigHelper tlsConfigHelper = new TlsConfigHelper();
    @Nullable
    private RetryPolicy retryPolicy;
    private Supplier<MeterProvider> meterProviderSupplier = GlobalOpenTelemetry::getMeterProvider;
    @Nullable
    private Object grpcChannel;

    GrpcExporterBuilder(String exporterName, String type, long defaultTimeoutSecs, URI defaultEndpoint, Supplier<BiFunction<Channel, String, MarshalerServiceStub<T, ?, ?>>> grpcStubFactory, String grpcEndpointPath) {
        this.exporterName = exporterName;
        this.type = type;
        this.grpcEndpointPath = grpcEndpointPath;
        this.timeoutNanos = TimeUnit.SECONDS.toNanos(defaultTimeoutSecs);
        this.endpoint = defaultEndpoint;
        this.grpcStubFactory = grpcStubFactory;
    }

    public GrpcExporterBuilder<T> setChannel(ManagedChannel channel) {
        this.grpcChannel = channel;
        return this;
    }

    public GrpcExporterBuilder<T> setTimeout(long timeout2, TimeUnit unit) {
        this.timeoutNanos = unit.toNanos(timeout2);
        return this;
    }

    public GrpcExporterBuilder<T> setTimeout(Duration timeout2) {
        return this.setTimeout(timeout2.toNanos(), TimeUnit.NANOSECONDS);
    }

    public GrpcExporterBuilder<T> setEndpoint(String endpoint) {
        this.endpoint = ExporterBuilderUtil.validateEndpoint(endpoint);
        return this;
    }

    public GrpcExporterBuilder<T> setCompression(String compressionMethod) {
        this.compressionEnabled = compressionMethod.equals("gzip");
        return this;
    }

    public GrpcExporterBuilder<T> configureTrustManager(byte[] trustedCertificatesPem) {
        this.tlsConfigHelper.createTrustManager(trustedCertificatesPem);
        return this;
    }

    public GrpcExporterBuilder<T> configureKeyManager(byte[] privateKeyPem, byte[] certificatePem) {
        this.tlsConfigHelper.createKeyManager(privateKeyPem, certificatePem);
        return this;
    }

    public GrpcExporterBuilder<T> addHeader(String key, String value) {
        this.headers.put(key, value);
        return this;
    }

    public GrpcExporterBuilder<T> setRetryPolicy(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
        return this;
    }

    public GrpcExporterBuilder<T> setMeterProvider(MeterProvider meterProvider) {
        this.meterProviderSupplier = () -> meterProvider;
        return this;
    }

    public GrpcExporter<T> build() {
        if (this.grpcChannel != null) {
            return new UpstreamGrpcExporterFactory().buildWithChannel((Channel)this.grpcChannel);
        }
        OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder().dispatcher(OkHttpUtil.newDispatcher());
        clientBuilder.callTimeout(Duration.ofNanos(this.timeoutNanos));
        this.tlsConfigHelper.configureWithSocketFactory(clientBuilder::sslSocketFactory);
        String endpoint = this.endpoint.resolve(this.grpcEndpointPath).toString();
        if (endpoint.startsWith("http://")) {
            clientBuilder.protocols(Collections.singletonList(Protocol.H2_PRIOR_KNOWLEDGE));
        } else {
            clientBuilder.protocols(Arrays.asList(Protocol.HTTP_2, Protocol.HTTP_1_1));
        }
        Headers.Builder headers = new Headers.Builder();
        this.headers.forEach(headers::add);
        headers.add("te", "trailers");
        if (this.compressionEnabled) {
            headers.add("grpc-encoding", "gzip");
        }
        if (this.retryPolicy != null) {
            clientBuilder.addInterceptor(new RetryInterceptor(this.retryPolicy, OkHttpGrpcExporter::isRetryable));
        }
        return new OkHttpGrpcExporter(this.exporterName, this.type, clientBuilder.build(), this.meterProviderSupplier, endpoint, headers.build(), this.compressionEnabled);
    }

    private class UpstreamGrpcExporterFactory {
        private UpstreamGrpcExporterFactory() {
        }

        private GrpcExporter<T> buildWithChannel(Channel channel) {
            Metadata metadata = new Metadata();
            String authorityOverride = null;
            for (Map.Entry entry : GrpcExporterBuilder.this.headers.entrySet()) {
                String name = (String)entry.getKey();
                String value = (String)entry.getValue();
                if (name.equals("host")) {
                    authorityOverride = value;
                    continue;
                }
                metadata.put(Metadata.Key.of(name, Metadata.ASCII_STRING_MARSHALLER), value);
            }
            channel = ClientInterceptors.intercept(channel, MetadataUtils.newAttachHeadersInterceptor((Metadata)metadata));
            Codec codec = GrpcExporterBuilder.this.compressionEnabled ? new Codec.Gzip() : Codec.Identity.NONE;
            MarshalerServiceStub stub = (MarshalerServiceStub)((MarshalerServiceStub)((Object)((BiFunction)GrpcExporterBuilder.this.grpcStubFactory.get()).apply(channel, authorityOverride))).withCompression(codec.getMessageEncoding());
            return new UpstreamGrpcExporter(GrpcExporterBuilder.this.exporterName, GrpcExporterBuilder.this.type, stub, GrpcExporterBuilder.this.meterProviderSupplier, GrpcExporterBuilder.this.timeoutNanos);
        }
    }
}

