/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.internal.aggregator;

import com.google.auto.value.AutoValue;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.data.DoubleExemplarData;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.internal.aggregator.Aggregator;
import io.opentelemetry.sdk.metrics.internal.aggregator.AggregatorHandle;
import io.opentelemetry.sdk.metrics.internal.aggregator.AutoValue_DoubleExponentialHistogramAggregator_EmptyExponentialHistogramBuckets;
import io.opentelemetry.sdk.metrics.internal.aggregator.DoubleExponentialHistogramBuckets;
import io.opentelemetry.sdk.metrics.internal.aggregator.ExponentialHistogramAccumulation;
import io.opentelemetry.sdk.metrics.internal.aggregator.MetricDataUtils;
import io.opentelemetry.sdk.metrics.internal.data.ImmutableMetricData;
import io.opentelemetry.sdk.metrics.internal.data.exponentialhistogram.ExponentialHistogramBuckets;
import io.opentelemetry.sdk.metrics.internal.data.exponentialhistogram.ExponentialHistogramData;
import io.opentelemetry.sdk.metrics.internal.descriptor.MetricDescriptor;
import io.opentelemetry.sdk.metrics.internal.exemplar.ExemplarReservoir;
import io.opentelemetry.sdk.resources.Resource;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public final class DoubleExponentialHistogramAggregator
implements Aggregator<ExponentialHistogramAccumulation, DoubleExemplarData> {
    private final Supplier<ExemplarReservoir<DoubleExemplarData>> reservoirSupplier;
    private final int maxBuckets;
    private final int startingScale;

    public DoubleExponentialHistogramAggregator(Supplier<ExemplarReservoir<DoubleExemplarData>> reservoirSupplier, int maxBuckets, int startingScale) {
        this.reservoirSupplier = reservoirSupplier;
        this.maxBuckets = maxBuckets;
        this.startingScale = startingScale;
    }

    @Override
    public AggregatorHandle<ExponentialHistogramAccumulation, DoubleExemplarData> createHandle() {
        return new Handle(this.reservoirSupplier.get(), this.maxBuckets, this.startingScale);
    }

    @Override
    public ExponentialHistogramAccumulation merge(ExponentialHistogramAccumulation previous, ExponentialHistogramAccumulation current) {
        ExponentialHistogramBuckets posBuckets = DoubleExponentialHistogramAggregator.merge(previous.getPositiveBuckets(), current.getPositiveBuckets());
        ExponentialHistogramBuckets negBuckets = DoubleExponentialHistogramAggregator.merge(previous.getNegativeBuckets(), current.getNegativeBuckets());
        int commonScale = Math.min(posBuckets.getScale(), negBuckets.getScale());
        posBuckets = DoubleExponentialHistogramAggregator.downscale(posBuckets, commonScale);
        negBuckets = DoubleExponentialHistogramAggregator.downscale(negBuckets, commonScale);
        double min2 = -1.0;
        double max = -1.0;
        if (previous.hasMinMax() && current.hasMinMax()) {
            min2 = Math.min(previous.getMin(), current.getMin());
            max = Math.max(previous.getMax(), current.getMax());
        } else if (previous.hasMinMax()) {
            min2 = previous.getMin();
            max = previous.getMax();
        } else if (current.hasMinMax()) {
            min2 = current.getMin();
            max = current.getMax();
        }
        return ExponentialHistogramAccumulation.create(commonScale, previous.getSum() + current.getSum(), previous.hasMinMax() || current.hasMinMax(), min2, max, posBuckets, negBuckets, previous.getZeroCount() + current.getZeroCount(), current.getExemplars());
    }

    private static ExponentialHistogramBuckets merge(ExponentialHistogramBuckets a, ExponentialHistogramBuckets b) {
        if (a instanceof EmptyExponentialHistogramBuckets || a.getTotalCount() == 0L) {
            return b;
        }
        if (b instanceof EmptyExponentialHistogramBuckets || b.getTotalCount() == 0L) {
            return a;
        }
        if (a instanceof DoubleExponentialHistogramBuckets && b instanceof DoubleExponentialHistogramBuckets) {
            DoubleExponentialHistogramBuckets a1 = (DoubleExponentialHistogramBuckets)a;
            DoubleExponentialHistogramBuckets b2 = (DoubleExponentialHistogramBuckets)b;
            a1.mergeInto(b2);
            return a1;
        }
        throw new IllegalStateException("Unable to merge ExponentialHistogramBuckets. Unrecognized implementation.");
    }

    private static ExponentialHistogramBuckets downscale(ExponentialHistogramBuckets buckets, int targetScale) {
        if (buckets.getScale() == targetScale) {
            return buckets;
        }
        if (buckets instanceof EmptyExponentialHistogramBuckets) {
            return EmptyExponentialHistogramBuckets.get(targetScale);
        }
        if (buckets instanceof DoubleExponentialHistogramBuckets) {
            DoubleExponentialHistogramBuckets buckets1 = (DoubleExponentialHistogramBuckets)buckets;
            buckets1.downscale(buckets1.getScale() - targetScale);
            return buckets1;
        }
        throw new IllegalStateException("Unable to merge ExponentialHistogramBuckets. Unrecognized implementation");
    }

    @Override
    public MetricData toMetricData(Resource resource, InstrumentationScopeInfo instrumentationScopeInfo, MetricDescriptor metricDescriptor, Map<Attributes, ExponentialHistogramAccumulation> accumulationByLabels, AggregationTemporality temporality, long startEpochNanos, long lastCollectionEpoch, long epochNanos) {
        return ImmutableMetricData.createExponentialHistogram(resource, instrumentationScopeInfo, metricDescriptor.getName(), metricDescriptor.getDescription(), metricDescriptor.getSourceInstrument().getUnit(), ExponentialHistogramData.create(temporality, MetricDataUtils.toExponentialHistogramPointList(accumulationByLabels, temporality == AggregationTemporality.CUMULATIVE ? startEpochNanos : lastCollectionEpoch, epochNanos)));
    }

    static final class Handle
    extends AggregatorHandle<ExponentialHistogramAccumulation, DoubleExemplarData> {
        private final int maxBuckets;
        @Nullable
        private DoubleExponentialHistogramBuckets positiveBuckets;
        @Nullable
        private DoubleExponentialHistogramBuckets negativeBuckets;
        private long zeroCount;
        private double sum;
        private double min;
        private double max;
        private long count;
        private int scale;

        Handle(ExemplarReservoir<DoubleExemplarData> reservoir, int maxBuckets, int startingScale) {
            super(reservoir);
            this.maxBuckets = maxBuckets;
            this.sum = 0.0;
            this.zeroCount = 0L;
            this.min = Double.MAX_VALUE;
            this.max = -1.0;
            this.count = 0L;
            this.scale = startingScale;
        }

        @Override
        protected synchronized ExponentialHistogramAccumulation doAccumulateThenReset(List<DoubleExemplarData> exemplars) {
            ExponentialHistogramBuckets negativeBuckets;
            ExponentialHistogramBuckets positiveBuckets;
            if (this.positiveBuckets != null) {
                positiveBuckets = this.positiveBuckets.copy();
                this.positiveBuckets.clear();
            } else {
                positiveBuckets = EmptyExponentialHistogramBuckets.get(this.scale);
            }
            if (this.negativeBuckets != null) {
                negativeBuckets = this.negativeBuckets.copy();
                this.negativeBuckets.clear();
            } else {
                negativeBuckets = EmptyExponentialHistogramBuckets.get(this.scale);
            }
            ExponentialHistogramAccumulation acc = ExponentialHistogramAccumulation.create(this.scale, this.sum, this.count > 0L, this.count > 0L ? this.min : -1.0, this.count > 0L ? this.max : -1.0, positiveBuckets, negativeBuckets, this.zeroCount, exemplars);
            this.sum = 0.0;
            this.zeroCount = 0L;
            this.min = Double.MAX_VALUE;
            this.max = -1.0;
            this.count = 0L;
            return acc;
        }

        @Override
        protected synchronized void doRecordDouble(double value) {
            DoubleExponentialHistogramBuckets buckets;
            if (!Double.isFinite(value)) {
                return;
            }
            this.sum += value;
            this.min = Math.min(this.min, value);
            this.max = Math.max(this.max, value);
            ++this.count;
            int c = Double.compare(value, 0.0);
            if (c == 0) {
                ++this.zeroCount;
                return;
            }
            if (c > 0) {
                if (this.positiveBuckets == null) {
                    this.positiveBuckets = new DoubleExponentialHistogramBuckets(this.scale, this.maxBuckets);
                }
                buckets = this.positiveBuckets;
            } else {
                if (this.negativeBuckets == null) {
                    this.negativeBuckets = new DoubleExponentialHistogramBuckets(this.scale, this.maxBuckets);
                }
                buckets = this.negativeBuckets;
            }
            if (!buckets.record(value)) {
                this.downScale(buckets.getScaleReduction(value));
                buckets.record(value);
            }
        }

        @Override
        protected void doRecordLong(long value) {
            this.doRecordDouble(value);
        }

        void downScale(int by) {
            if (this.positiveBuckets != null) {
                this.positiveBuckets.downscale(by);
                this.scale = this.positiveBuckets.getScale();
            }
            if (this.negativeBuckets != null) {
                this.negativeBuckets.downscale(by);
                this.scale = this.negativeBuckets.getScale();
            }
        }
    }

    @AutoValue
    static abstract class EmptyExponentialHistogramBuckets
    implements ExponentialHistogramBuckets {
        private static final Map<Integer, ExponentialHistogramBuckets> ZERO_BUCKETS = new ConcurrentHashMap<Integer, ExponentialHistogramBuckets>();

        EmptyExponentialHistogramBuckets() {
        }

        static ExponentialHistogramBuckets get(int scale) {
            return ZERO_BUCKETS.computeIfAbsent(scale, scale1 -> new AutoValue_DoubleExponentialHistogramAggregator_EmptyExponentialHistogramBuckets((int)scale1, 0, Collections.emptyList(), 0L));
        }
    }
}

