/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.testing.assertj;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.sdk.metrics.data.LongExemplarData;
import io.opentelemetry.sdk.testing.assertj.AssertUtil;
import io.opentelemetry.sdk.testing.assertj.AttributeAssertion;
import io.opentelemetry.sdk.testing.assertj.OpenTelemetryAssertions;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;

public final class LongExemplarAssert
extends AbstractAssert<LongExemplarAssert, LongExemplarData> {
    LongExemplarAssert(@Nullable LongExemplarData actual) {
        super((Object)actual, LongExemplarAssert.class);
    }

    public LongExemplarAssert hasEpochNanos(long expected) {
        this.isNotNull();
        ((AbstractLongAssert)Assertions.assertThat((long)((LongExemplarData)this.actual).getEpochNanos()).as("epochNanos", new Object[0])).isEqualTo(expected);
        return this;
    }

    public LongExemplarAssert hasSpanId(String expected) {
        this.isNotNull();
        ((AbstractStringAssert)Assertions.assertThat((String)((LongExemplarData)this.actual).getSpanContext().getSpanId()).as("spanId", new Object[0])).isEqualTo(expected);
        return this;
    }

    public LongExemplarAssert hasTraceId(String expected) {
        this.isNotNull();
        ((AbstractStringAssert)Assertions.assertThat((String)((LongExemplarData)this.actual).getSpanContext().getTraceId()).as("traceId", new Object[0])).isEqualTo(expected);
        return this;
    }

    public LongExemplarAssert hasValue(long expected) {
        this.isNotNull();
        ((AbstractLongAssert)Assertions.assertThat((long)((LongExemplarData)this.actual).getValue()).as("value", new Object[0])).isEqualTo(expected);
        return this;
    }

    public <T> LongExemplarAssert hasFilteredAttribute(AttributeKey<T> key, T value) {
        return this.hasFilteredAttribute(OpenTelemetryAssertions.equalTo(key, value));
    }

    public LongExemplarAssert hasFilteredAttribute(AttributeAssertion attributeAssertion) {
        this.isNotNull();
        Set<AttributeKey<?>> actualKeys = ((LongExemplarData)this.actual).getFilteredAttributes().asMap().keySet();
        AttributeKey<?> key = attributeAssertion.getKey();
        ((AbstractCollectionAssert)Assertions.assertThat(actualKeys).as("attribute keys", new Object[0])).contains((Object[])new AttributeKey[]{key});
        Object value = ((LongExemplarData)this.actual).getFilteredAttributes().get(key);
        AbstractAssert<?, ?> assertion = AttributeAssertion.attributeValueAssertion(key, value);
        attributeAssertion.getAssertion().accept(assertion);
        return this;
    }

    public LongExemplarAssert hasFilteredAttributes(Attributes expected) {
        this.isNotNull();
        ((ObjectAssert)Assertions.assertThat((Object)((LongExemplarData)this.actual).getFilteredAttributes()).as("filtered_attributes", new Object[0])).isEqualTo((Object)expected);
        return this;
    }

    @SafeVarargs
    public final LongExemplarAssert hasFilteredAttributes(Map.Entry<? extends AttributeKey<?>, ?> ... entries) {
        AttributesBuilder attributesBuilder = Attributes.builder();
        for (Map.Entry<AttributeKey<?>, ?> entry : entries) {
            attributesBuilder.put(entry.getKey(), entry.getValue());
        }
        Attributes attributes = attributesBuilder.build();
        return this.hasFilteredAttributes(attributes);
    }

    public LongExemplarAssert hasFilteredAttributesSatisfying(AttributeAssertion ... assertions) {
        return this.hasFilteredAttributesSatisfying(Arrays.asList(assertions));
    }

    public LongExemplarAssert hasFilteredAttributesSatisfying(Iterable<AttributeAssertion> assertions) {
        AssertUtil.assertAttributes(((LongExemplarData)this.actual).getFilteredAttributes(), assertions);
        return (LongExemplarAssert)this.myself;
    }
}

