/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.testing.assertj;

import io.opentelemetry.sdk.metrics.data.DoubleExemplarData;
import io.opentelemetry.sdk.metrics.data.HistogramPointData;
import io.opentelemetry.sdk.testing.assertj.AbstractPointAssert;
import io.opentelemetry.sdk.testing.assertj.AssertUtil;
import io.opentelemetry.sdk.testing.assertj.DoubleExemplarAssert;
import java.util.Arrays;
import java.util.function.Consumer;
import org.assertj.core.api.AbstractDoubleAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;

public final class HistogramPointAssert
extends AbstractPointAssert<HistogramPointAssert, HistogramPointData> {
    HistogramPointAssert(HistogramPointData actual) {
        super(actual, HistogramPointAssert.class);
    }

    public HistogramPointAssert hasSum(double expected) {
        this.isNotNull();
        ((AbstractDoubleAssert)Assertions.assertThat((double)((HistogramPointData)this.actual).getSum()).as("sum", new Object[0])).isEqualTo(expected);
        return this;
    }

    public HistogramPointAssert hasSumGreaterThan(double boundary) {
        this.isNotNull();
        ((AbstractDoubleAssert)Assertions.assertThat((double)((HistogramPointData)this.actual).getSum()).as("sum", new Object[0])).isGreaterThan(boundary);
        return this;
    }

    public HistogramPointAssert hasMin(double expected) {
        this.isNotNull();
        Assertions.assertThat((boolean)((HistogramPointData)this.actual).hasMin()).isTrue();
        ((AbstractDoubleAssert)Assertions.assertThat((double)((HistogramPointData)this.actual).getMin()).as("min", new Object[0])).isEqualTo(expected);
        return this;
    }

    public HistogramPointAssert hasMax(double expected) {
        this.isNotNull();
        Assertions.assertThat((boolean)((HistogramPointData)this.actual).hasMax()).isTrue();
        ((AbstractDoubleAssert)Assertions.assertThat((double)((HistogramPointData)this.actual).getMax()).as("max", new Object[0])).isEqualTo(expected);
        return this;
    }

    public HistogramPointAssert hasCount(long expected) {
        this.isNotNull();
        ((AbstractLongAssert)Assertions.assertThat((long)((HistogramPointData)this.actual).getCount()).as("count", new Object[0])).isEqualTo(expected);
        return this;
    }

    public HistogramPointAssert hasBucketBoundaries(double ... boundaries) {
        this.isNotNull();
        Object[] bigBoundaries = (Double[])Arrays.stream(boundaries).boxed().toArray(Double[]::new);
        ((ListAssert)Assertions.assertThat(((HistogramPointData)this.actual).getBoundaries()).as("boundaries", new Object[0])).containsExactly(bigBoundaries);
        return this;
    }

    public HistogramPointAssert hasBucketCounts(long ... counts) {
        this.isNotNull();
        Object[] bigCounts = (Long[])Arrays.stream(counts).boxed().toArray(Long[]::new);
        ((ListAssert)Assertions.assertThat(((HistogramPointData)this.actual).getCounts()).as("bucketCounts", new Object[0])).containsExactly(bigCounts);
        return this;
    }

    public HistogramPointAssert hasExemplars(DoubleExemplarData ... exemplars) {
        this.isNotNull();
        ((ListAssert)Assertions.assertThat(((HistogramPointData)this.actual).getExemplars()).as("exemplars", new Object[0])).containsExactlyInAnyOrder((Object[])exemplars);
        return (HistogramPointAssert)this.myself;
    }

    @SafeVarargs
    public final HistogramPointAssert hasExemplarsSatisfying(Consumer<DoubleExemplarAssert> ... assertions) {
        return this.hasExemplarsSatisfying(Arrays.asList(assertions));
    }

    public HistogramPointAssert hasExemplarsSatisfying(Iterable<? extends Consumer<DoubleExemplarAssert>> assertions) {
        this.isNotNull();
        Assertions.assertThat(((HistogramPointData)this.actual).getExemplars()).satisfiesExactlyInAnyOrder((Consumer[])AssertUtil.toConsumers(assertions, DoubleExemplarAssert::new));
        return (HistogramPointAssert)this.myself;
    }
}

