/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.autoconfigure;

import io.opentelemetry.exporter.internal.retry.RetryUtil;
import io.opentelemetry.exporter.logging.LoggingMetricExporter;
import io.opentelemetry.exporter.otlp.http.metrics.OtlpHttpMetricExporter;
import io.opentelemetry.exporter.otlp.http.metrics.OtlpHttpMetricExporterBuilder;
import io.opentelemetry.exporter.otlp.metrics.OtlpGrpcMetricExporter;
import io.opentelemetry.exporter.otlp.metrics.OtlpGrpcMetricExporterBuilder;
import io.opentelemetry.exporter.prometheus.PrometheusHttpServer;
import io.opentelemetry.exporter.prometheus.PrometheusHttpServerBuilder;
import io.opentelemetry.sdk.autoconfigure.ClasspathUtil;
import io.opentelemetry.sdk.autoconfigure.NamedSpiManager;
import io.opentelemetry.sdk.autoconfigure.OtlpConfigUtil;
import io.opentelemetry.sdk.autoconfigure.SpiUtil;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigurationException;
import io.opentelemetry.sdk.autoconfigure.spi.metrics.ConfigurableMetricExporterProvider;
import io.opentelemetry.sdk.metrics.export.MetricExporter;
import io.opentelemetry.sdk.metrics.export.MetricReader;
import io.opentelemetry.sdk.metrics.export.PeriodicMetricReader;
import java.time.Duration;
import java.util.function.BiFunction;
import javax.annotation.Nullable;

final class MetricExporterConfiguration {
    private static final Duration DEFAULT_EXPORT_INTERVAL = Duration.ofMinutes(1L);

    static MetricReader configureExporter(String name, ConfigProperties config, ClassLoader serviceClassLoader, BiFunction<? super MetricExporter, ConfigProperties, ? extends MetricExporter> metricExporterCustomizer) {
        MetricExporter metricExporter;
        if (name.equals("prometheus")) {
            return MetricExporterConfiguration.configurePrometheusMetricReader(config);
        }
        switch (name) {
            case "otlp": {
                metricExporter = MetricExporterConfiguration.configureOtlpMetrics(config);
                break;
            }
            case "logging": {
                metricExporter = MetricExporterConfiguration.configureLoggingExporter();
                break;
            }
            default: {
                MetricExporter spiExporter = MetricExporterConfiguration.configureSpiExporter(name, config, serviceClassLoader);
                if (spiExporter == null) {
                    throw new ConfigurationException("Unrecognized value for otel.metrics.exporter: " + name);
                }
                metricExporter = spiExporter;
            }
        }
        metricExporter = metricExporterCustomizer.apply(metricExporter, config);
        return MetricExporterConfiguration.configurePeriodicMetricReader(config, metricExporter);
    }

    private static MetricExporter configureLoggingExporter() {
        ClasspathUtil.checkClassExists("io.opentelemetry.exporter.logging.LoggingMetricExporter", "Logging Metrics Exporter", "opentelemetry-exporter-logging");
        return LoggingMetricExporter.create();
    }

    @Nullable
    static MetricExporter configureSpiExporter(String name, ConfigProperties config, ClassLoader serviceClassLoader) {
        NamedSpiManager<MetricExporter> spiExportersManager = SpiUtil.loadConfigurable(ConfigurableMetricExporterProvider.class, ConfigurableMetricExporterProvider::getName, ConfigurableMetricExporterProvider::createExporter, config, serviceClassLoader);
        return spiExportersManager.getByName(name);
    }

    static MetricExporter configureOtlpMetrics(ConfigProperties config) {
        String protocol = OtlpConfigUtil.getOtlpProtocol("metrics", config);
        if (protocol.equals("http/protobuf")) {
            ClasspathUtil.checkClassExists("io.opentelemetry.exporter.otlp.http.metrics.OtlpHttpMetricExporter", "OTLP HTTP Metrics Exporter", "opentelemetry-exporter-otlp-http-metrics");
            OtlpHttpMetricExporterBuilder builder = OtlpHttpMetricExporter.builder();
            OtlpConfigUtil.configureOtlpExporterBuilder("metrics", config, builder::setEndpoint, builder::addHeader, builder::setCompression, builder::setTimeout, builder::setTrustedCertificates, builder::setClientTls, retryPolicy -> RetryUtil.setRetryPolicyOnDelegate(builder, retryPolicy));
            OtlpConfigUtil.configureOtlpAggregationTemporality(config, builder::setAggregationTemporalitySelector);
            OtlpConfigUtil.configureOtlpHistogramDefaultAggregation(config, builder::setDefaultAggregationSelector);
            return builder.build();
        }
        if (protocol.equals("grpc")) {
            ClasspathUtil.checkClassExists("io.opentelemetry.exporter.otlp.metrics.OtlpGrpcMetricExporter", "OTLP gRPC Metrics Exporter", "opentelemetry-exporter-otlp");
            OtlpGrpcMetricExporterBuilder builder = OtlpGrpcMetricExporter.builder();
            OtlpConfigUtil.configureOtlpExporterBuilder("metrics", config, builder::setEndpoint, builder::addHeader, builder::setCompression, builder::setTimeout, builder::setTrustedCertificates, builder::setClientTls, retryPolicy -> RetryUtil.setRetryPolicyOnDelegate(builder, retryPolicy));
            OtlpConfigUtil.configureOtlpAggregationTemporality(config, builder::setAggregationTemporalitySelector);
            OtlpConfigUtil.configureOtlpHistogramDefaultAggregation(config, builder::setDefaultAggregationSelector);
            return builder.build();
        }
        throw new ConfigurationException("Unsupported OTLP metrics protocol: " + protocol);
    }

    private static PeriodicMetricReader configurePeriodicMetricReader(ConfigProperties config, MetricExporter exporter) {
        return PeriodicMetricReader.builder(exporter).setInterval(config.getDuration("otel.metric.export.interval", DEFAULT_EXPORT_INTERVAL)).build();
    }

    private static PrometheusHttpServer configurePrometheusMetricReader(ConfigProperties config) {
        String host;
        ClasspathUtil.checkClassExists("io.opentelemetry.exporter.prometheus.PrometheusHttpServer", "Prometheus Metrics Server", "opentelemetry-exporter-prometheus");
        PrometheusHttpServerBuilder prom = PrometheusHttpServer.builder();
        Integer port = config.getInt("otel.exporter.prometheus.port");
        if (port != null) {
            prom.setPort(port);
        }
        if ((host = config.getString("otel.exporter.prometheus.host")) != null) {
            prom.setHost(host);
        }
        return prom.build();
    }

    private MetricExporterConfiguration() {
    }
}

