/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.autoconfigure;

import io.opentelemetry.api.metrics.MeterProvider;
import io.opentelemetry.sdk.autoconfigure.LogRecordExporterConfiguration;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.logs.LogLimits;
import io.opentelemetry.sdk.logs.LogLimitsBuilder;
import io.opentelemetry.sdk.logs.LogRecordProcessor;
import io.opentelemetry.sdk.logs.SdkLoggerProviderBuilder;
import io.opentelemetry.sdk.logs.export.BatchLogRecordProcessor;
import io.opentelemetry.sdk.logs.export.BatchLogRecordProcessorBuilder;
import io.opentelemetry.sdk.logs.export.LogRecordExporter;
import io.opentelemetry.sdk.logs.export.SimpleLogRecordProcessor;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;

final class LoggerProviderConfiguration {
    static void configureLoggerProvider(SdkLoggerProviderBuilder loggerProviderBuilder, ConfigProperties config, ClassLoader serviceClassLoader, MeterProvider meterProvider, BiFunction<? super LogRecordExporter, ConfigProperties, ? extends LogRecordExporter> logRecordExporterCustomizer) {
        loggerProviderBuilder.setLogLimits(() -> LoggerProviderConfiguration.configureLogLimits(config));
        Map<String, LogRecordExporter> exportersByName = LogRecordExporterConfiguration.configureLogRecordExporters(config, serviceClassLoader, meterProvider, logRecordExporterCustomizer);
        LoggerProviderConfiguration.configureLogRecordProcessors(config, exportersByName, meterProvider).forEach(loggerProviderBuilder::addLogRecordProcessor);
    }

    static List<LogRecordProcessor> configureLogRecordProcessors(ConfigProperties config, Map<String, LogRecordExporter> exportersByName, MeterProvider meterProvider) {
        HashMap<String, LogRecordExporter> exportersByNameCopy = new HashMap<String, LogRecordExporter>(exportersByName);
        ArrayList<LogRecordProcessor> logRecordProcessors = new ArrayList<LogRecordProcessor>();
        LogRecordExporter exporter = (LogRecordExporter)exportersByNameCopy.remove("logging");
        if (exporter != null) {
            logRecordProcessors.add(SimpleLogRecordProcessor.create(exporter));
        }
        if (!exportersByNameCopy.isEmpty()) {
            LogRecordExporter compositeLogRecordExporter = LogRecordExporter.composite(exportersByNameCopy.values());
            logRecordProcessors.add(LoggerProviderConfiguration.configureBatchLogRecordProcessor(config, compositeLogRecordExporter, meterProvider));
        }
        return logRecordProcessors;
    }

    static BatchLogRecordProcessor configureBatchLogRecordProcessor(ConfigProperties config, LogRecordExporter exporter, MeterProvider meterProvider) {
        Duration timeout2;
        Integer maxExportBatch;
        Integer maxQueue;
        BatchLogRecordProcessorBuilder builder = BatchLogRecordProcessor.builder(exporter).setMeterProvider(meterProvider);
        Duration scheduleDelay = config.getDuration("otel.blrp.schedule.delay");
        if (scheduleDelay != null) {
            builder.setScheduleDelay(scheduleDelay);
        }
        if ((maxQueue = config.getInt("otel.blrp.max.queue.size")) != null) {
            builder.setMaxQueueSize(maxQueue);
        }
        if ((maxExportBatch = config.getInt("otel.blrp.max.export.batch.size")) != null) {
            builder.setMaxExportBatchSize(maxExportBatch);
        }
        if ((timeout2 = config.getDuration("otel.blrp.export.timeout")) != null) {
            builder.setExporterTimeout(timeout2);
        }
        return builder.build();
    }

    static LogLimits configureLogLimits(ConfigProperties config) {
        Integer maxAttrs;
        LogLimitsBuilder builder = LogLimits.builder();
        Integer maxAttrLength = config.getInt("otel.attribute.value.length.limit");
        if (maxAttrLength != null) {
            builder.setMaxAttributeValueLength(maxAttrLength);
        }
        if ((maxAttrs = config.getInt("otel.attribute.count.limit")) != null) {
            builder.setMaxNumberOfAttributes(maxAttrs);
        }
        return builder.build();
    }

    private LoggerProviderConfiguration() {
    }
}

